/* eslint-disable prefer-rest-params */
let estaNoTutorial = false;
$('#tutorial').on('click', function () {
    estaNoTutorial = true;
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false,
            animate: true,
            onNext: (Element) => {
                if ((Element.node.id == 'avancar1')) {
                    avancarPag();
                    $('#avancar1').trigger('click');
                };
                if ((Element.node.id == 'avancar2')) {
                    $('#avancar2').trigger('click');
                }
            },
            onPrevious: (Element) => {
                if (Element.node.id == 'tourEmpresas') {
                    $('#voltar').trigger('click');
                };
                if (Element.node.id == 'tourGuias') {
                    $('#voltar2').trigger('click');
                }
            }
        });

        driver.defineSteps([{
            element: '#formcard1',
            popover: {
                title: 'Dados Gerais',
                description: 'Aqui estão os campos disponíveis para o cadastro.',
                position: 'top'
            }
        },
        {
            element: '#txtCodigo',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#txtDesc',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#txtCpf',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#txtDiaPagto',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#avancar1',
            popover: {
                title: 'Botão Avançar',
                description: 'Clique aqui para ir para a próxima aba.',
                position: 'left'
            }
        },
        {
            element: '#tourEmpresas',
            popover: {
                title: 'Empresas Disponíveis',
                description: 'Aqui estão as empresas do representante.',
                position: 'top'
            }
        },
        {
            element: '#avancar2',
            popover: {
                title: 'Botão Avançar',
                description: 'Clique aqui para ir para a próxima aba.',
                position: 'left'
            }
        },
        {
            element: '#tourGuias',
            popover: {
                title: 'Dados de Alteração',
                description: 'Aqui estão os guias que este representate pode ter.',
                position: 'top'
            }
        },
        {
            element: '#gravar',
            popover: {
                title: 'Botão Gravar',
                description: 'Clique aqui para gravar os dados do Representante.',
                position: 'left'
            }
        }
        ]);
        driver.start();
    });
});

$(document).ready(async function () {
    const queryString = window.location.href;
    const parametros = queryString.split("/");
    const chaveCadastro = parametros[parametros.length - 1];
    const habilitaCampoMaterial = await CopiaParametro('PEDIDO', 19) == 1;

    addPesquisas()

    if (habilitaCampoMaterial) {
        $('#divMaterialGeral').removeClass('d-none')
        $('#divGrupoMaterialGeral').removeClass('d-none')
    }

    $('.2casasDecimais').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });

    $('.3casasDecimais').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 3
    });

    $('.4casasDecimais').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 4
    });

    async function buscaDadosCadastro(id) {
        const response = await requisicao("GET", `/sisplan/cadcaracteristica/V1/buscadadoscadastro?`, `&ID=${id}`, '', 30000)

        if (!response) {
            return
        }

        const json = await response.json()
        if (response.status != 200) {
            msgErro(json.mensagem)
            return
        }

        const capa = JSON.parse(json.capa)
        const consumos = JSON.parse(json.consumos)
        const tecidos = JSON.parse(json.tecidos)
        const { caracteristicas } = json
        const subcaracteristicas = JSON.parse(caracteristicas.subcaracteristicas)
        const aplicacoesCaracteristicas = JSON.parse(caracteristicas.aplicacoes)
        const consumosCaracteristicas = JSON.parse(caracteristicas.consumos)
        const { fluxos } = json
        const fluxosFluxos = JSON.parse(fluxos.fluxos)
        const setoresFluxos = JSON.parse(fluxos.setores)

        preencheDadosCapa(capa[0] || {})
        criaTabelaConsumos(consumos)
        criaTabelaTecidos(tecidos)
        criaTabelaSubcaracteristicas(subcaracteristicas)
        criaTabelaAplicacoesCaracteristicas(aplicacoesCaracteristicas)
        criaTabelaConsumosCaracteristicas(consumosCaracteristicas)
        criaTabelaFluxos(fluxosFluxos)
        criaTabelaSetores(setoresFluxos)

        preencheSelectSubstituirConsumosCaracteristica()
    }

    function preencheDadosCapa(data) {
        if (habilitaCampoMaterial) insereValor('#txtMaterialGeral', data.MATERIAL, data.DESC_MATERIAL)
        if (habilitaCampoMaterial) insereValor('#txtGrupoMaterialGeral', data.GRUPO_MA, data.DESC_GRUPO_MA)
        insereValor('#txtIdGeral', data.ID)
        insereValor('#txtLinhaGeral', data.LINHA, data.DESC_LINHA)
        insereValor('#txtGrupoGeral', data.GRUPO, data.DESC_GRUPO)
        insereValor('#txtEtiquetaGeral', data.ETIQUETA, data.DESC_ETIQUETA)
        insereValor('#txtFaixaGeral', data.FAIXA, data.DESC_FAIXA)
        insereValor('#txtMarkupGeral', data.MARKUP, data.DESC_MARKUP)
        insereValor('#txtNCMGeral', data.NCM, data.DESC_CODFIS)
        insereValor('#txtDescricaoGeral', data.DESCRICAO)
        insereValor('#txtTempoCosturaGeral', data.TEMPO_COST)
        insereValor('#txtValorCosturaGeral', data.VALOR_COST)
        insereValor('#txtValorLinhaGeral', data.VALOR_LINHA)
        insereValor('#txtMExtraGeral', data.MARGEM)
        insereValor('#txtViradaGeral', data.VIRADA)
        $('#cbAtivoGeral').prop('checked', data.ATIVO === 'S')
    }

    $('.consumoControl').prop('disabled', true)
    $('.tecidoControl').prop('disabled', true)
    $('.caracteristicaControl').prop('disabled', true)
    $('.aplicacoesCaracteristicaControl').prop('disabled', true)
    $('.consumosCaracteristicaControl').prop('disabled', true)
    $('.fluxoControl').prop('disabled', true)

    $('#txtLinhaGeral, #txtGrupoGeral, #txtEtiquetaGeral').on('blur', async function () {
        const linha = pegaChave('#txtLinhaGeral')
        const grupo = pegaChave('#txtGrupoGeral')
        const etiqueta = pegaChave('#txtEtiquetaGeral')

        if (linha == '' || grupo == '' || etiqueta == '') {
            return
        }

        $.LoadingOverlay('show')
        try {
            if (await Existe('CARACT', ['COD_LINHA', 'COD_GRUPO', 'COD_ETQ'], [linha, grupo, etiqueta])) {
                await criaMensagemAlerta(`Já existe uma característica cadastrada com o Grupo, Linha e Etiqueta informados.\nImpossivel cadastrar novamente com estes dados!`, () => {
                    $('#txtEtiquetaGeral').val('')
                    $('#txtEtiquetaGeral').focus()
                })
            }
        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    // consumos
    $("#tabelaConsumos").on("click", "#btnAlterar", async function () {
        $($(this).closest('tr')).addClass('selected')
        const data = $("#tabelaConsumos").DataTable().row($(this).parents("tr")).data()
        insereValoresEdicaoConsumo(data)
        habilitaEdicaoConsumo()
    })

    $("#tabelaConsumos").on("click", "#btnExcluir", async function () {
        $("#tabelaConsumos").DataTable().row($(this).parents("tr")).remove().draw(false)
        preencheSelectSubstituirConsumosCaracteristica()
    })

    $('#btnIncluirConsumo').on('click', function () {
        habilitaEdicaoConsumo()
    })

    $('#btnDesistirConsumo').on('click', function () {
        desabilitaEdicaoConsumo()
    })
    $('#btnConfirmarConsumo').on('click', function () {
        const data = {
            QTDE: $('#txtQuantidadeConsumo').val(),
            CUSTO: $('#txtCustoUniConsumo').val(),
            CODIGO: pegaChave('#txtMaterialConsumo'),
            DESCRICAO: pegaDescricao('#txtMaterialConsumo'),
            ATIVO: $('#cbAtivoConsumo').prop('checked') ? 'S' : 'N',
            SETOR: pegaChave('#txtSetorConsumo'),
            DESC_SETOR: pegaDescricao('#txtSetorConsumo'),
            COR: pegaChave('#txtCorConsumo'),
            DESC_COR: pegaDescricao('#txtCorConsumo'),
            FAIXA: pegaChave('#txtFaixaConsumo'),
            DESC_FAIXA: pegaDescricao('#txtFaixaConsumo'),
            PRECO: $('#cbPrecoConsumo').prop('checked') ? 'S' : 'N',
            TIPO: isChecked('#radioMaterial') ? 'M' : 'P'
        }

        if (!data.CODIGO || data.CODIGO === '') {
            msgErro('Material não informado, impossível continuar.')
            return
        }

        if (!data.COR || data.COR === '') {
            msgErro('Cor não informada, impossível continuar.')
            return
        }

        if (!data.SETOR || data.SETOR === '') {
            msgErro('Setor não informado, impossível continuar.')
            return
        }

        adicionaRegistroConsumo(data)
        preencheSelectSubstituirConsumosCaracteristica()
    })

    $('input[name="tipoItem"]').change(function () {
        pesquisaItemConsumo();
    });

    // tecidos
    $("#tabelaTecidos").on("click", "#btnAlterar", async function () {
        $($(this).closest('tr')).addClass('selected')
        const data = $("#tabelaTecidos").DataTable().row($(this).parents("tr")).data()
        insereValoresEdicaoTecido(data)
        habilitaEdicaoTecido()
    })

    $("#tabelaTecidos").on("click", "#btnExcluir", async function () {
        $("#tabelaTecidos").DataTable().row($(this).parents("tr")).remove().draw(false)
    })

    $('#btnIncluirTecido').on('click', function () {
        habilitaEdicaoTecido()
    })

    $('#btnDesistirTecido').on('click', function () {
        desabilitaEdicaoTecido()
    })

    $('#btnConfirmarTecido').on('click', function () {
        const data = {
            CODIGO: pegaChave('#txtMaterialTecido'),
            DESCRICAO: pegaDescricao('#txtMaterialTecido')
        }

        if (!data.CODIGO || data.CODIGO === '') {
            msgErro('Material não informado, impossível continuar.')
            return
        }

        adicionaRegistroTecido(data)
    })

    // subcaracterísticas
    $("#tabelaSubcaracteristicas").on("click", "#btnAlterar", async function () {
        $($(this).closest('tr')).addClass('selected')
        const data = $("#tabelaSubcaracteristicas").DataTable().row($(this).parents("tr")).data()
        insereValoresEdicaoSubcaracteristica(data)
        habilitaEdicaoSubcaracteristica()
        filtraAplicacoesSubcaracteristicas(data)
        filtraConsumosSubcaracteristicas(data)
        $('#txtAplicacaoSubcaracteristica').prop('disabled', true)
        $('#btnAplicacaoSubcaracteristica').prop('disabled', true)
        $('#btnLimpaAplicacaoSubcaracteristica').prop('disabled', true)
        $('#txtCaracteristicaSubcaracteristica').prop('disabled', true)
        $('#btnCaracteristicaSubcaracteristica').prop('disabled', true)
        $('#btnLimpaCaracteristicaSubcaracteristica').prop('disabled', true)
    })

    $("#tabelaSubcaracteristicas").on("click", "#btnExcluir", async function () {
        excluiSubcaracteristica($("#tabelaSubcaracteristicas").DataTable().row($(this).parents("tr")))
    })

    $('#btnIncluirSubcaracteristica').on('click', function () {
        $("#tabelaSubcaracteristicas tr").removeClass("selected")
        filtraAplicacoesSubcaracteristicas({ COD_APL: '', OPCIONAL: '' })
        filtraConsumosSubcaracteristicas({ COD_APL: '', OPCIONAL: '' })
        habilitaEdicaoSubcaracteristica()
    })

    $('#btnDesistirSubcaracteristica').on('click', function () {
        const aplicacoesData = JSON.parse(localStorage.getItem('aplicacoesSubcaracteristicas'))
        const consumosData = JSON.parse(localStorage.getItem('consumosSubcaracteristicas'))
        criaTabelaAplicacoesCaracteristicas(aplicacoesData)
        criaTabelaConsumosCaracteristicas(consumosData)
        desabilitaEdicaoSubcaracteristica()
    })

    $('#btnConfirmarSubcaracteristica').on('click', function () {
        const data = {
            COD_APL: pegaChave('#txtAplicacaoSubcaracteristica'),
            DESC_APL: pegaDescricao('#txtAplicacaoSubcaracteristica'),
            OPCIONAL: pegaChave('#txtCaracteristicaSubcaracteristica'),
            DESC_OPCIONAL: pegaDescricao('#txtCaracteristicaSubcaracteristica'),
            VALOR_VENDA: $('#txtValorVendaSubcaracteristica').val(),
            ATIVO: $('#cbAtivoSubcaracteristica').prop('checked') ? 'S' : 'N',
            IMP_NFE: $('#cbImprimeNFeSubcaracteristica').prop('checked') ? 'S' : 'N',
            TEMPO_ADC_COST: $('#txtTempoAdcCosturaSubcaracteristica').val(),
            PADRAO: $('#cbPadraoSubcaracteristica').prop('checked') ? 'S' : 'N',
        }

        if (!data.COD_APL || data.COD_APL === '') {
            msgErro('Aplicação não informada, impossível continuar.')
            return
        }

        if (!data.OPCIONAL || data.OPCIONAL === '') {
            msgErro('Subcaracterística não informada, impossível continuar.')
            return
        }

        adicionaRegistroSubcaracteristica(data)
    })

    // aplicações características
    $("#tabelaAplicacoesCaracteristicas").on("click", "#btnAlterar", async function () {
        $($(this).closest('tr')).addClass('selected')
        const data = $("#tabelaAplicacoesCaracteristicas").DataTable().row($(this).parents("tr")).data()
        insereValoresEdicaoAplicacoesCaracteristica(data)
        habilitaEdicaoAplicacoesCaracteristica()
    })

    $("#tabelaAplicacoesCaracteristicas").on("click", "#btnExcluir", async function () {
        $("#tabelaAplicacoesCaracteristicas").DataTable().row($(this).parents("tr")).remove().draw(false)
    })

    $('#btnIncluirAplicacoesCaracteristica').on('click', function () {
        $("#tabelaAplicacoesCaracteristicas tr").removeClass("selected")
        habilitaEdicaoAplicacoesCaracteristica()
    })

    $('#btnDesistirAplicacoesCaracteristica').on('click', function () {
        desabilitaEdicaoAplicacoesCaracteristica()
    })

    $('#btnConfirmarAplicacoesCaracteristica').on('click', function () {
        const data = {
            COD_APL: pegaChave('#txtAplicacaoSubcaracteristica'),
            DESCRICAO: pegaDescricao('#txtAplicacaoSubcaracteristica'),
            QTDE: $('#txtQuantidadeAplicacoesCaracteristica').val(),
            QTDE_TECIDO: $('#txtQuantidadeTecidoAplicacoesCaracteristica').val(),
            SUBSTITUIR_CORTE: $('#cbSubstituirAplicacoesCaracteristica').prop('checked') ? 'S' : 'N',
            SUBCARACTERISTICA: pegaChave('#txtCaracteristicaSubcaracteristica'),
            TECIDO_FIXO: pegaChave('#txtTecidoFixoAplicacoesCaracteristica'),
            DESC_TECIDO: pegaDescricao('#txtTecidoFixoAplicacoesCaracteristica')
        }

        if (!data.COD_APL || data.COD_APL === '') {
            msgErro('Aplicação não informada, impossível continuar.')
            return
        }

        if (!data.SUBCARACTERISTICA || data.SUBCARACTERISTICA === '') {
            msgErro('Subcaracterística não informada, impossível continuar.')
            return
        }

        if (!data.TECIDO_FIXO || data.TECIDO_FIXO === '') {
            msgErro('Tecido não informado, impossível continuar.')
            return
        }

        adicionaRegistroAplicacoesCaracteristica(data)
    })

    // consumos características
    $("#tabelaConsumosCaracteristicas").on("click", "#btnAlterar", async function () {
        $($(this).closest('tr')).addClass('selected')
        const data = $("#tabelaConsumosCaracteristicas").DataTable().row($(this).parents("tr")).data()
        insereValoresEdicaoConsumosCaracteristica(data)
        habilitaEdicaoConsumosCaracteristica()
    })

    $("#tabelaConsumosCaracteristicas").on("click", "#btnExcluir", async function () {
        $("#tabelaConsumosCaracteristicas").DataTable().row($(this).parents("tr")).remove().draw(false)
    })

    $('#btnIncluirConsumosCaracteristica').on('click', function () {
        $("#tabelaConsumosCaracteristicas tr").removeClass("selected")
        habilitaEdicaoConsumosCaracteristica()
    })

    $('#btnDesistirConsumosCaracteristica').on('click', function () {
        desabilitaEdicaoConsumosCaracteristica()
    })

    $('#btnConfirmarConsumosCaracteristica').on('click', function () {
        const data = {
            COD_SUB: pegaChave('#txtCaracteristicaSubcaracteristica'),
            COD_APL: pegaChave('#txtAplicacaoSubcaracteristica'),
            COD_MAT: pegaChave('#txtMaterialConsumosCaracteristica'),
            DESC_MAT: pegaDescricao('#txtMaterialConsumosCaracteristica'),
            COD_COR: pegaChave('#txtCorConsumosCaracteristica'),
            DESC_COR: pegaDescricao('#txtCorConsumosCaracteristica'),
            QTDE: $('#txtQuantidadeConsumosCaracteristica').val(),
            CUSTO: $('#txtCustoUniFixoConsumosCaracteristica').val(),
            SETOR: pegaChave('#txtSetorConsumosCaracteristica'),
            DESC_SETOR: pegaDescricao('#txtSetorConsumosCaracteristica'),
            FAIXA: pegaChave('#txtFaixaConsumosCaracteristica'),
            DESC_FAIXA: pegaDescricao('#txtFaixaConsumosCaracteristica'),
            PRECO: $('#cbPrecoConsumosCaracteristica').prop('checked') ? 'S' : 'N',
            COD_SUBST: String($('#selectSubstituirConsumosCaracteristica option:selected').data('codigo')),
            DESC_SUBST: String($('#selectSubstituirConsumosCaracteristica option:selected').data('descricao')),
            ORDEM_SUBST: $('#selectSubstituirConsumosCaracteristica').val()
        }

        if (!data.COD_APL || data.COD_APL === '') {
            msgErro('Aplicação não informada, impossível continuar.')
            return
        }

        if (!data.COD_SUB || data.COD_SUB === '') {
            msgErro('Subcaracterística não informada, impossível continuar.')
            return
        }

        if (!data.COD_MAT || data.COD_MAT === '') {
            msgErro('Material não informado, impossível continuar.')
            return
        }

        if (!data.COD_COR || data.COD_COR === '') {
            msgErro('Cor não informada, impossível continuar.')
            return
        }

        if (!data.SETOR || data.SETOR === '') {
            msgErro('Setor não informado, impossível continuar.')
            return
        }

        adicionaRegistroConsumosCaracteristica(data)
    })

    // fluxos
    $("#tabelaFluxos").on("click", "#btnAlterar", async function () {
        $($(this).closest('tr')).addClass('selected')
        const data = $("#tabelaFluxos").DataTable().row($(this).parents("tr")).data()
        insereValoresEdicaoFluxo(data)
        habilitaEdicaoFluxo()
    })

    $("#tabelaFluxos").on("click", "#btnExcluir", async function () {
        excluiFluxo($("#tabelaFluxos").DataTable().row($(this).parents("tr")))
    })

    $('#btnIncluirFluxo').on('click', function () {
        $("#tabelaFluxos tr").removeClass("selected")
        filtraSetoresFluxo({ COD_FLUXO: ' ', COD_PARTE: ' ' })
        habilitaEdicaoFluxo()
    })

    $('#btnDesistirFluxo').on('click', function () {
        desabilitaEdicaoFluxo()
    })

    $('#btnConfirmarFluxo').on('click', async function () {
        const data = {
            COD_FLUXO: pegaChave('#txtFluxoFluxo'),
            DESC_FLUXO: pegaDescricao('#txtFluxoFluxo'),
            COD_PARTE: pegaChave('#txtParteFluxo'),
            DESC_PARTE: pegaDescricao('#txtParteFluxo'),
        }

        if (!data.COD_PARTE || data.COD_PARTE === '') {
            msgErro('Parte não informada, impossível continuar.')
            return
        }

        if (!data.COD_FLUXO || data.COD_FLUXO === '') {
            msgErro('Fluxo não informada, impossível continuar.')
            return
        }

        await adicionaRegistroFluxo(data)
    })

    await buscaDadosCadastro(chaveCadastro)

    $('#btnVoltar').on('click', function () {
        window.location.href = `${BASE_URI}/cadcaracteristica`;
    })

    $('#btnGravar').on('click', async function () {
        if ($('.addButton').filter('.d-none').length > 0) {
            msgErro('Existem registros em alteração, impossível continuar. Confirme ou desista das alterações e tente novamente.')
            return
        }
        msgAlerta('Deseja realmente gravar os dados?',
            () => { },
            () => { },
            async () => {
                const objCaracteristica = retornaDadosGravar()
                const { capa, subcaracteristicas } = objCaracteristica

                if (!capa.linha || capa.linha === '') {
                    msgErro('Linha não informada, impossível continuar.')
                    return
                }

                if (!capa.grupo || capa.grupo === '') {
                    msgErro('Grupo não informado, impossível continuar.')
                    return
                }

                if (!capa.etiqueta || capa.etiqueta === '') {
                    msgErro('Etiqueta não informada, impossível continuar.')
                    return
                }

                // if (!capa.faixa || capa.faixa === '') {
                //     msgErro('Faixa não informada, impossível continuar.')
                //     return
                // }

                if (!subcaracteristicas || subcaracteristicas.length === 0) {
                    msgErro('Nenhuma característica informada, impossível continuar.')
                    return
                }

                await gravaDados(objCaracteristica)
            }
        )
    })

    function retornaDadosGravar() {
        const capa = {
            id: $('#txtIdGeral').val() && $('#txtIdGeral').val() !== '' ? parseInt($('#txtIdGeral').val()) : 0,
            material: pegaChave('#txtMaterialGeral'),
            linha: pegaChave('#txtLinhaGeral'),
            grupo: pegaChave('#txtGrupoGeral'),
            etiqueta: pegaChave('#txtEtiquetaGeral'),
            faixa: pegaChave('#txtFaixaGeral'),
            markup: pegaChave('#txtMarkupGeral'),
            ncm: pegaChave('#txtNCMGeral'),
            descricao: $('#txtDescricaoGeral').val(),
            tempo_cost: $('#txtTempoCosturaGeral').val(),
            valor_cost: $('#txtValorCosturaGeral').val(),
            valor_linha: $('#txtValorLinhaGeral').val(),
            margem: $('#txtMExtraGeral').val(),
            virada: $('#txtViradaGeral').val(),
            ativo: $('#cbAtivoGeral').prop('checked') ? 'S' : 'N',            
            grupo_material: pegaChave('#txtGrupoMaterialGeral'),
        }

        const consumos =
            $('#tabelaConsumos')
                .DataTable()
                .data()
                .toArray()

        const tecidos = $('#tabelaTecidos').DataTable().data().toArray()
        const subcaracteristicas =
            $('#tabelaSubcaracteristicas')
                .DataTable()
                .data()
                .toArray()
                .map(e => {
                    const aplicacoes =
                        $('#tabelaAplicacoesCaracteristicas')
                            .DataTable()
                            .data()
                            .toArray()
                            .filter(d => d.COD_APL === e.COD_APL && d.SUBCARACTERISTICA === e.OPCIONAL)

                    const consumos =
                        $('#tabelaConsumosCaracteristicas')
                            .DataTable()
                            .data()
                            .toArray()
                            .filter(d => d.COD_APL === e.COD_APL && d.COD_SUB === e.OPCIONAL)

                    return {
                        ...e,
                        aplicacoes,
                        consumos
                    }
                })

        const fluxos =
            $('#tabelaFluxos')
                .DataTable()
                .data()
                .toArray()
                .map(e => {
                    const setores =
                        $('#tabelaSetores')
                            .DataTable()
                            .data()
                            .toArray()
                            .filter(d => d.COD_PARTE === e.PARTE && d.COD_FLUXO === e.FLUXO)
                    return {
                        ...e,
                        setores
                    }
                })

        return {
            capa,
            consumos,
            tecidos,
            subcaracteristicas,
            fluxos
        }
    }

    async function gravaDados(objCaracteristica) {
        try {
            $.LoadingOverlay('show')

            const response = await requisicao("POST", `/sisplan/cadcaracteristica/V1/gravadados?`, ``, JSON.stringify(objCaracteristica), 600000)

            if (!response) {
                return
            }

            const json = await response.json()
            if (response.status != 200) {
                msgErro(json.mensagem)
                return
            }

            toastr.success("Dados gravados com sucesso!", "Confirmação", {
                toastClass: "alert",
                iconClasses: {
                    error: "alert-error",
                    info: "alert-info",
                    success: "alert-success",
                    warning: "alert-warning",
                },
                positionClass: "toast-top-center",
                progressBar: true,
                timeOut: 3000,
                fadeOut: 1000,
                onHidden() {
                    window.location.href = `${BASE_URI}/cadcaracteristica`;
                },
            }).css({
                "margin-top": "20%",
                width: "500px",
                "max-width": "500px",
            })
        } catch (e) {
            console.log(e)
            msgErro('Ocorreu um problema ao gravar os dados, tente novamente.')
        } finally {
            $.LoadingOverlay('hide')
        }
    }

    function addPesquisas() {
        componenteFiltro('material', false, false, 'MaterialGeral')
        componenteFiltro('grupoMA', false, false, 'GrupoMaterialGeral')
        componenteFiltro('linha', false, false, 'LinhaGeral')
        componenteFiltro('grupo', false, false, 'GrupoGeral')
        componenteFiltro('etiqueta', false, false, 'EtiquetaGeral')
        componenteFiltro('faixa', false, false, 'FaixaGeral', [`ATIVO = 'S'`])
        componenteFiltro('markup', false, false, 'MarkupGeral')
        componenteFiltro('ncm', false, false, 'NCMGeral')

        componenteFiltro('material', false, false, 'MaterialConsumo')
        componenteFiltro('cor', false, false, 'CorConsumo')
        componenteFiltro('setor', false, false, 'SetorConsumo')
        componenteFiltro('faixa', false, false, 'FaixaConsumo')

        componenteFiltro('material', false, false, 'MaterialTecido')

        componenteFiltro('aplicacao', false, false, 'AplicacaoSubcaracteristica')
        componenteFiltro('caracteristica', false, false, 'CaracteristicaSubcaracteristica')

        componenteFiltro('material', false, false, 'TecidoFixoAplicacoesCaracteristica')

        componenteFiltro('material', false, false, 'MaterialConsumosCaracteristica')
        componenteFiltro('cor', false, false, 'CorConsumosCaracteristica')
        componenteFiltro('setor', false, false, 'SetorConsumosCaracteristica')
        componenteFiltro('faixa', false, false, 'FaixaConsumosCaracteristica')

        componenteFiltro('parte', false, false, 'ParteFluxo')
        componenteFiltro('fluxo', false, false, 'FluxoFluxo')

        $('#txtMaterialConsumo').on('focusout', async function () {
            $.LoadingOverlay('show')
            try {
                const codigo = pegaChave('#txtMaterialConsumo');
                if (codigo == '') {
                    return;
                }

                $('#txtCorConsumo').off('autocompleta');
                $('#txtCorConsumo').autocompleta(1, `JSON={ "tabela":"MAT_ITEN", "camposSelect":["MAT_ITEN.COR CHAVE, CADCOR.DESCRICAO"], "leftjoin": [{ "tabela" : "CADCOR", "condicao" : "MAT_ITEN.COR = CADCOR.COR" }], "groupBy": ["MAT_ITEN.COR", "CADCOR.DESCRICAO"], "where": ["MAT_ITEN.CODIGO = '${codigo}' AND MAT_ITEN.ATIVO = 'S' AND CADCOR.INATIVO = 'N'"] }`, undefined, undefined, undefined);
                $('#btnCorConsumo').off();
                $('#btnCorConsumo').pesquisa_array(['#txtCorConsumo'], ['COR'], ['DESCRICAO'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MAT_ITEN", "camposSelect":[ "MAT_ITEN.COR", "CADCOR.DESCRICAO" ],"leftjoin": [{ "tabela" : "CADCOR", "condicao" : "MAT_ITEN.COR = CADCOR.COR" }], "groupBy": ["MAT_ITEN.COR", "CADCOR.DESCRICAO"], "where": ["MAT_ITEN.CODIGO = '${codigo}' AND MAT_ITEN.ATIVO = 'S' AND CADCOR.INATIVO = 'N'"]}`, 'Pesquisa Cor', 'CADCOR');
            } catch (error) {
                console.error(error)
                msgAlerta(error.message)
            } finally {
                $.LoadingOverlay('hide');
                await buscaPrecoMatCor();
            }
        })
    }
})