$(document).ready(async function () {
  $('#tabelaEtapasCompra').on('click', '#btnEditar', function () {
    // if (permissaoUsuarioLogado.ALTERA == 'S') {
    const { tipo } = $('#tabelaEtapasCompra').DataTable().row($(this).parents('tr')).data()
    switch (tipo) {
      case 'D':
        window.location.href = `central_compras/compra_digitadas`
        break
      case 'B':
        window.location.href = `central_compras/compra_bloqueadas`
        break
      case 'N':
        window.location.href = `central_compras/compra_retornadas`
        break
      case 'L':
        window.location.href = `central_compras/compra_liberadas`
        break
      case 'E':
        window.location.href = `central_compras/compra_enviadas`
        break
      default:
        break
    }
    // } else {
    //   msgAlertaSemConfirmacao("Sem permissão para alterar!");
    // }
  })

  $('#tabelaEtapasCompra').on('dblclick', 'tr', function () {
    // if (permissaoUsuarioLogado.ALTERA == 'S') {
    const { tipo } = $('#tabelaEtapasCompra').DataTable().row($(this)).data()
    switch (tipo) {
      case 'D':
        window.location.href = `central_compras/compra_digitadas`
        break
      case 'B':
        window.location.href = `central_compras/compra_bloqueadas`
        break
      case 'N':
        window.location.href = `central_compras/compra_retornadas`
        break
      case 'L':
        window.location.href = `central_compras/compra_liberadas`
        break
      case 'E':
        window.location.href = `central_compras/compra_enviadas`
        break
      default:
        break
    }
    // } else {
    //   msgAlertaSemConfirmacao("Sem permissão para alterar!")
    // }
  })
})

window.ComprasAcesso = window.ComprasAcesso || {}

ComprasAcesso.carregarGrafico = ({ data }) => {
  const gradientes = {
    digitadas: {
      linearGradient: { x1: 0.5, y1: 1, x2: 0.5, y2: 0 },
      stops: [
        [0.25, 'rgb(219, 219, 219)'],
        [1, 'rgba(89, 89, 89)'],
      ]
    },
    bloqueadas: {
      linearGradient: { x1: 0.5, y1: 1, x2: 0.5, y2: 0 },
      stops: [
        [0.25, 'rgb(252, 159, 159)'],
        [1, 'rgba(128, 13, 6)'],
      ]
    },
    retornadas: {
      linearGradient: { x1: 0.5, y1: 1, x2: 0.5, y2: 0 },
      stops: [
        [0.25, 'rgb(252, 202, 151)'], ,
        [1, 'rgba(135, 79, 12)'],
      ]
    },
    liberadas: {
      linearGradient: { x1: 0.5, y1: 1, x2: 0.5, y2: 0 },
      stops: [
        [0.25, 'rgb(178, 252, 159)'], ,
        [1, 'rgba(24, 117, 0)'],
      ]
    },
    enviadas: {
      linearGradient: { x1: 0.5, y1: 1, x2: 0.5, y2: 0 },
      stops: [
        [0.25, 'rgb(157, 192, 252)'], ,
        [1, 'rgba(17, 79, 186)'],
      ]
    },
    canceladas: {
      linearGradient: { x1: 0.5, y1: 1, x2: 0.5, y2: 0 },
      stops: [
        [0.25, 'rgb(91, 227, 214, 1)'],
        [1, 'rgba(19, 148, 136)'],
      ]
    },
    aceitas: {
      linearGradient: { x1: 0.5, y1: 1, x2: 0.5, y2: 0 },
      stops: [
        [0.25, 'rgb(157, 133, 230)'],
        [1, 'rgba(63, 27, 171)'],
      ]
    },
    rejeitadas: {
      linearGradient: { x1: 0.5, y1: 1, x2: 0.5, y2: 0 },
      stops: [
        [0.25, 'rgb(230, 230, 133)'],
        [1, 'rgba(171, 171, 27)'],
      ]
    },
  }

  const dadosGrafico = []
  const categorias = []

  data.forEach((item) => {
    const nomeItem = item.etapa.replace('Ordens de Compra ', '')
    dadosGrafico.push({
      y: item.quantidade,
      color: gradientes[nomeItem.toLowerCase()],
    })
    categorias.push(nomeItem)
  })

  GraficosCentralCompras.criarGraficoBarra({ container: 'graficoCompras', data: dadosGrafico, categories: categorias, })
}

ComprasAcesso.carregarCards = ({ data }) => {
  data.forEach((item) => {
    const nomeItem = item.etapa.replace('Ordens de Compra ', '')
    $(`#quantidade${nomeItem}Compras`).html(item.quantidade?.toLocaleString('pt-BR'))
  })
}

ComprasAcesso.criarTabelaEtapas = ({ data, columns, }) => {
  if ($.fn.DataTable.isDataTable('#tabelaEtapasCompra')) {
    $('#tabelaEtapasCompra').DataTable().destroy()
    $('#tabelaEtapasCompra').empty()
  }

  $('#tabelaEtapasCompra').DataTable({
    sort: false,
    paging: false,
    destroy: true,
    lengthChange: false,
    filter: false,
    info: false,
    ordering: false,
    sorting: false,
    order: false,
    data,
    columns,
    scrollX: true,
    scrollY: '200px',
  })
}