$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    })
    driver.defineSteps([
      {
        element: "#tutorial-step1",
        popover: {
          title: "Campos",
          description:
            "Aqui se encontram os campos essenciais para consultar e gravar as informações.",
          position: "bottom",
        },
      },
      {
        element: '#btnVoltar',
        popover: {
          title: 'Voltar',
          description: 'Aqui está o botão para voltar à consulta.',
          position: 'bottom'
        }
      },
      {
        element: '#btnGravar',
        popover: {
          title: 'Gravar',
          description: 'Aqui está o botão para gravar as informações.',
          position: 'bottom'
        }
      }
    ])
    driver.start()
  })
})

$(document).ready(async function () {
  $('#tabelaItens').on('click', '#btnItens', async function () {
    const datatableItens = $('#tabelaItens').DataTable()
    const dados = datatableItens?.row($(this)?.parents('tr'))?.data()
    window.location.href = `${BASE_URI}/itens_compra/ID=${dados?.id ?? 0}&STATUS=L`
  })

  $("#tabelaItens").on('change', '.checkSel', function () {
    const linha = $(this).closest('tr')
    const [data] = $('#tabelaItens').DataTable().rows(linha).data().toArray()
    const { id } = data
    const isChecked = this.checked
    $(linha).toggleClass('selected', isChecked)

    if (!isChecked) {
      ComprasLiberadas.idsSelecionados.delete(id)
      return
    }

    ComprasLiberadas.idsSelecionados.add(id)
  })

  ComprasLiberadas.criarTabelaItens()

  $('#btnEnviar').on('click', () => enviar())

  const enviar = async () => {
    try {
      $.LoadingOverlay('show')
      const idsSelecionados = [...ComprasLiberadas.idsSelecionados]
      if (!idsSelecionados) return msgErro('Nenhum registro selecionado.')

      const response = await requisicao("POST", `/sisplan/centralcompras/compra/v1/enviarvarias?`, '', JSON.stringify({ ids: idsSelecionados }), 3600000)

      const dados = await response.json()
      if (dados) {
        const { mensagem } = dados
        if (mensagem?.codigo !== 200) {
          throw mensagem?.mensagem
        }

        toastr.success("Dados gravados com sucesso!", "Confirmação", {
          toastClass: "alert",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 1000,
          fadeOut: 1000,
          onShown() {
            ComprasLiberadas.idsSelecionados.clear()
            ComprasLiberadas.criarTabelaItens()
          },
        }).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        })
      }
    } catch (error) {
      console.error(error)
      msgErro('Ocorreu um erro ao enviar os itens selecionados.')
    } finally {
      $.LoadingOverlay('hide')
    }
  }

  $('#btnVoltar').on('click', function () {
    window.location.href = `${BASE_URI}/central_compras`
  })
})

window.ComprasLiberadas = window.ComprasLiberadas || {}

ComprasLiberadas.idsSelecionados = new Set()

ComprasLiberadas.criarTabelaItens = () => {
  if ($.fn.DataTable.isDataTable('#tabelaItens')) {
    $('#tabelaItens').DataTable().destroy()
    $('#tabelaItens').empty()
  }

  const columns = [
    {
      data: 'sel',
      title: `<div class="icheck-primary d-inline">
                <input type="checkbox" id="cbSelAll">
                <label for="cbSelAll"></label>
              </div>
              `,
      render: (_data, _type, _row, { row: rowIndex, col: colIndex }) => (
        `<div class="icheck-primary d-inline">
          <input type="checkbox" id="check_col_${colIndex}_row_${rowIndex}" class="checkSel">
          <label for="check_col_${colIndex}_row_${rowIndex}"></label>
        </div>`
      )
    },
    {
      data: 'numero',
      title: 'Número',
      render: (data) => (
        '<div style="text-align:start;"> ' +
        '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" id="tutorialTabela" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
        '      ' + data + ' ' +
        '    </button> ' +
        '    <div class="dropdown-menu"> ' +
        '    <button class="dropdown-item" type="button" title="Itens" id="btnItens">Itens</button>     ' +
        '</div>'
      )
    },
    {
      data: 'status',
      title: 'Status',
    },
    {
      data: 'usuario',
      title: 'Usuário',
    },
    {
      data: 'dataEmissao',
      title: 'Emissão',
      render: function (data) {
        return retornarDataISOEmYMD({ dataISO: data, usarUTC: true, reverso: true, separadorData: '/' })
      }
    },
    {
      data: 'dataEntrega',
      title: 'Entrega',
      render: function (data) {
        return retornarDataISOEmYMD({ dataISO: data, usarUTC: true, reverso: true, separadorData: '/' })
      }
    },
    {
      data: 'fornecedor',
      title: 'Fornecedor',
    },
    {
      data: 'nomeFornecedor',
      title: 'Nome',
    },
    {
      data: 'colecao',
      title: 'Coleção',
    },
    {
      data: 'descricaoColecao',
      title: 'Desc. Coleção',
    },
    {
      data: 'motivo',
      title: 'Motivo',
    },
    {
      data: 'descricaoMotivo',
      title: 'Desc. Motivo',
    },
    {
      data: 'centroCusto',
      title: 'Centro de Custo',
    },
    {
      data: 'descricaoCentroCusto',
      title: 'Desc. Centro de Custo',
    },
    {
      data: 'observacao',
      title: 'Observação',
    },
    {
      data: 'id',
      title: 'Id',
      visible: false,
    },
  ]

  $('#tabelaItens').DataTable({
    sort: false,
    paging: true,
    destroy: true,
    lengthChange: false,
    filter: false,
    info: false,
    ordering: false,
    sorting: false,
    order: false,
    pageLength: 18,
    colReorder: true,
    serverSide: true,
    ajax: {
      url: `${getCookie('protocolo')}://${getCookie('ip_api')}/sisplan/centralcompras/compra/v1/liberadas`,
      type: "POST",
      headers: {
        'Authorization': getCookie('accessToken') ? 'Bearer ' + getCookie('accessToken') : '',
      },
      data: function (data) {
        const { start, length, draw } = data;
        return JSON.stringify({
          paginacao: {
            quantidadeMaximaRegistros: length,
            quantidadeRegistrosPular: start,
            contadorRequisicoes: draw,
          },
          empresa: getCookie('empresa'),
          idUsuario: getCookie('id_usuario'),
        })
      },
      dataSrc: function (json) {
        if (!json || !json.data) {
          return []
        }
        return json.data
      },
      cache: true,
      beforeSend: function () {
        $.LoadingOverlay('show')
      },
      complete: function () {
        $.LoadingOverlay('hide')
      },
    },
    autoWidth: true,
    columns,
    scrollX: true,
    scrollY: '737px',
    rowCallback: function (row, data) {
      const ids = [...ComprasLiberadas.idsSelecionados]
      const isChecked = ids?.some(item => item === data.id) ?? false
      $(row).toggleClass('selected', isChecked)
      const checkbox = $(row).find('.checkSel')
      $(checkbox).prop('checked', isChecked)
    },
  })
  ComprasLiberadas.adicionarEventoSelecionarTodos()
  // UtilsCentralCompras.criarContainerBotoes({
  //   tabela: 'tabelaItens',
  // })
  // UtilsCentralCompras.habilitarEsconderColunas({
  //   tabela: 'tabelaItens',
  //   tela: 'itensCompraLiberados',
  // })
  // UtilsCentralCompras.habilitarExportarCsv({
  //   tabela: 'tabelaItens',
  //   status: 'L',
  //   tipo: 'COM',
  // })
}

ComprasLiberadas.adicionarEventoSelecionarTodos = () => {
  $('#cbSelAll').off('change')
  $('#cbSelAll').on('change', function () {
    const isChecked = this.checked
    const table = $('#tabelaItens').DataTable()
    if (!isChecked) {
      ComprasLiberadas.idsSelecionados.clear()
      table.draw(false)
      return
    }

    $.LoadingOverlay('show')
    requisicao(
      'GET',
      `/sisplan/centralcompras/compra/v1/seltodasliberadas?`,
      '',
      '',
      3600000
    ).then(async (response) => {
      const json = await response.json()

      if (json) {
        const { resultado, mensagem } = json
        if (mensagem?.codigo !== 200) {
          throw mensagem?.mensagem
        }
        if (!resultado)
          throw new Error('Ids não foram buscados corretamente da API.')

        resultado.forEach(({ id }) => ComprasLiberadas.idsSelecionados.add(id))
      }
      table.draw(false)
    }).catch((error) => {
      console.error(error)
      msgErro('Ocorreu um erro ao selecionar todos os itens.')
    }).finally(() => $.LoadingOverlay('hide'))
  })
}