$(document).ready(async function () {
  const permissaoUsuarioLogado = await permissaoAcessos("CLAFISCAL");

  // autocompleta
  $("#txtNCMconsulta").autocompleta(
    1,
    `JSON={ "tabela":"tabfis", "camposSelect":[ "codigo chave", "tipo descricao"], "where": null}`
  );
  // pesquisa
  $("#btn-NCM").pesquisa(
    "#txtNCMconsulta",
    "CODIGO",
    "TIPO",
    `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"tabfis", "camposSelect":[ "codigo", "tipo"]}`,
    "Pesquisa NCM",
    "tabfis"
  );
  // limpaCampo
  $("#btn-limpa-NCM").on("click", function () {
    $("#txtNCMconsulta").val("");
  });

  function retornaBotaoOpcoes(data) {
    var retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
      '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
      '</div>';
    return retorno;
  };

  ConsultaNCM();

  $("#btnFiltros").on("click", async function () {
    $("#modal-filtros").modal("show");
  });

  $("#btnNovaClaFiscal").on("click", async function () {
    if (permissaoUsuarioLogado.INCLUI == 'S') {
      window.location.href = "clafiscal/create";
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }

  });

  $("#btnConsultar").on("click", async function () {
    await ConsultaNCM(true);
    $("#modal-filtros").modal("hide");
  });

  $("#btnLimparFiltros").on("click", async function () {
    $("#txtNCMconsulta").val("");
    $("#txtTipoConsulta").val("");
  });

  async function ConsultaNCM(bBotao = false) {
    try {
      let response;
      $.LoadingOverlay("show");
      let ncm =
        pegaChave("#txtNCMconsulta") != ""
          ? ` AND CODIGO = '${pegaChave("#txtNCMconsulta")}'`
          : "";
      let tipo =
        $("#txtTipoConsulta").val() != ""
          ? ` AND TIPO LIKE '[PERCENTUAL]${$(
            "#txtTipoConsulta"
          ).val()}[PERCENTUAL]'`
          : "";

      if (bBotao) {
        response = await requisicao(
          "GET",
          "/Sisplan/Funcoes/V1/pesquisa?",
          `JSON={ "tabela":"tabfis", "camposSelect":[ "codigo", "descricao", "tipo", "observacao"], "where": ["1=1 ${ncm} ${tipo}"]}`,
          null
        );
      } else {
        response = await requisicao(
          "GET",
          "/Sisplan/Funcoes/V1/pesquisa?",
          'JSON={ "tabela":"tabfis", "camposSelect":[ "codigo", "descricao", "tipo", "observacao"], "where": null}',
          null
        );
      }

      if (!response) {
        $.LoadingOverlay("hide");
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        $.LoadingOverlay("hide");
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }

      $("#tabelaClaFiscal").DataTable({
        destroy: true,
        lengthChange: false,
        serverside: true,
        autoWidth: true,
        data: jsonStr.RESULT[0],
        columns: [
          {
            data: "CODIGO",
          },
          {
            data: "DESCRICAO",
          },
          {
            data: "TIPO",
          },
          {
            data: "OBSERVACAO"
          }
        ],
        columnDefs: [
          {
            targets: [0], render: function (data, type, row) {
              return retornaBotaoOpcoes(data);
            }
          },
        ],
      });

      $.LoadingOverlay("hide");
    } catch (error) {
      console.error(error);
      $.LoadingOverlay("hide");
    }
  }
  $("#tabelaClaFiscal").on("click", "#btn-editar", async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $("#tabelaClaFiscal").DataTable().row($(this).parents("tr")).data();
      let registroLiberado = await verificarRegistro("CLAFISCAL", data.CODIGO);
      if (registroLiberado) {
        window.location.href = `clafiscal/${data.CODIGO}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }

  });

  $("#tabelaClaFiscal").on("dblclick", "tr", async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $("#tabelaClaFiscal").DataTable().row($(this)).data();
      let registroLiberado = await verificarRegistro("CLAFISCAL", data.CODIGO);
      if (registroLiberado) {
        window.location.href = `clafiscal/${data.CODIGO}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }

  });

  $('#tabelaClaFiscal').on('click', '#btn-excluir', async function () {
    if (permissaoUsuarioLogado.EXCLUI == 'S') {
      msgAlerta('Você realmente deseja excluir esse registro?', async () => {
        const data = $("#tabelaClaFiscal").DataTable().row($(this).parents("tr"));
        await excluiRegistro(data);
      });
    } else {
      msgAlertaSemConfirmacao("Sem permissão para excluir!");
    }

  });

  async function excluiRegistro(data) {
    try {
      $.LoadingOverlay("show");
      try {
        let valorLinha = data.data();
        let response = await requisicao("DELETE", "/Sisplan/clafiscal/v1/clafiscal?", `CODIGOCLAFISCAL=${encodeURIComponent(valorLinha.CODIGO)}`, null);
        if (!response) {
          return;
        }
        if (response.status != 200) {
          let jsonStr = await response.json();
          msgErro(jsonStr.mensagem);
          return;
        }

        toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
          toastClass: "success",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden() {
            data.remove().draw(false);
          },
        }).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        });

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  // INICIO IMPORTAR LEI TRANSPARÊNCIA

  $('#mdModalUpload').on('change', async function () {
    let nomeAnexo = $(this).val().split('\\')[$(this).val().split('\\').length - 1];
    $('#txtArquivoImportar').val(nomeAnexo);

    let file = document.getElementById('mdModalUpload').files[0];
    let reader = new FileReader();
    dados = leArquivoExcel(reader, file, nomeAnexo);
  });

  function leArquivoExcel(reader, file, name) {
    try {
      const extension = (name.split('.')[name.split('.').length - 1]);
      if (extension == 'csv') {
        reader.onload = function (e) {
          $('#fileContent').text(e.target.result);
        }
        reader.readAsText(file);
      } else if (extension == 'xls' || extension == 'xlsx' || extension == 'xlsm' || extension == 'xlt') {
        reader.onload = function (e) {
          const data = new Uint8Array(e.target.result);
          const workbook = XLSX.read(data, { type: 'array' });
          const sheetName = workbook.SheetNames[0];
          const sheet = workbook.Sheets[sheetName];

          // Get the range of the sheet
          const range = XLSX.utils.decode_range(sheet['!ref']);
          let resultString = '';

          for (let R = range.s.r; R <= range.e.r; ++R) {
            for (let C = range.s.c; C <= range.e.c; ++C) {
              const cellAddress = { c: C, r: R };
              const cellRef = XLSX.utils.encode_cell(cellAddress);
              const cell = sheet[cellRef];
              let cellValue = cell ? cell.v : null;

              if (cell && cell.t === 'n' && cell.z === 'm/d/yy') {
                const serialDate = cellValue;
                const jsDate = excelSerialToJSDate(serialDate);
                cellValue = formatDate(jsDate);
              }

              resultString += `${cellValue},`;
            }
            resultString = resultString.slice(0, -1); // Remove the trailing comma
            resultString += ';';
          }

          $('#fileContent').text(resultString);
        }
        reader.readAsArrayBuffer(file);

      }
    } catch (e) {
      msgErro(`Não foi possível ler o arquivo: ${e}`)
      return;
    }
  }

  function formataDadosExcel(info, ext) {
    let char1, char2;
    if (ext == 'csv') {
      char1 = '\n';
      char2 = ';';
    } else {
      char1 = ';';
      char2 = ',';
    }

    let data = (info.split(char1)).filter(item => item != '');
    let arrayRetorno = [];

    let firstLine = data[0].split(char2);

    firstLine = firstLine.map(e => {
      return e.normalize("NFD").replaceAll('R$', '').replace(/[\u0300-\u036f]/g, '').replace(/[^\w\s]/gi, '').replaceAll('.', '').replaceAll(',', '').toUpperCase().trim();
    })

    data.map((e, i) => {
      let d
      if (e.indexOf('\r') != -1) {
        d = e.replace('\r', '').split(char2);
      } else {
        d = e.split(char2);
      }
      if (d[0] == 'null' && d[1] == 'null' && d[2] == 'null' && d[3] == 'null' && d[4] == 'null' && d[5] == 'null' && d[6] == 'null' && d[7] == 'null' && d[8] == 'null' && d[9] == 'null') {
        return;
      }

      arrayRetorno.push({
        CODIGO: d[0] == 'null' || !d[0] ? '' : d[0],
        DESCRICAO: d[1] == 'null' || !d[1] ? '' : d[1],
        NACIONALFEDERAL: d[2] == 'null' || !d[2] ? 0 : d[2],
        IMPORTADADOSFEDERAL: d[3] == 'null' || !d[3] ? 0 : d[3],
        ESTADUAL: d[4] == 'null' || !d[4] ? 0 : d[4],
        MUNICIPAL: d[5] == 'null' || !d[5] ? 0 : d[5],
      });
    });

    return arrayRetorno;
  }

  function retornaDadosImportar() {
    let info = $('#fileContent').text();
    let arquivo = $('#txtArquivoImportar').val();
    let ext = (arquivo.split('.'))[(arquivo.split('.')).length - 1];
    let dados = '';
    dados = formataDadosExcel(info, ext);
    return dados;
  }

  $('#btnCarregarImportar').on('click', async function () {
    await carregaDadosImportacao()
  })

  async function carregaDadosImportacao() {
    $.LoadingOverlay('show')
    try {
      const dadosImportacao = retornaDadosImportar()

      if (!dadosImportacao || !dadosImportacao.length) {
        msgErro('Nenhum dado para importar.');
        return;
      }

      const response = await requisicao(
        "POST",
        "/sisplan/clafiscal/v1/carregarimportacaoleitransp?",
        "",
        JSON.stringify({ itens: dadosImportacao }),
        36000000
      );

      if (!response) {
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.mensagem);
        return;
      }

      criaTabelaImportar(jsonStr)
    } catch (e) {
      msgErro('Não foi possível realizar a importação.')
      console.log(e)
    } finally {
      $.LoadingOverlay('hide')
      $('#btnCarregarImportar').prop('disabled', false)
    }
  }

  function retornaDataImportar() {
    const itens = $('#tabelaImportar').DataTable().data().toArray()
    return itens.map((e, i) => {
      return {
        codigo: e.CODIGO,
        descricao: e.DESCRICAO,
        nacionalfederal: e.PERC_IMPOSTO,
        importadadosfederal: e.PERC_IMPOS_IMP,
        estadual: e.PERC_IMPOS_EST,
        municipal: e.PERC_IMPOS_MUN,
      }
    })

  }

  $('#btnConfirmarImportar').on('click', async function () {
    const data = retornaDataImportar()
    msgAlerta('Deseja realmente atualizar os percentuais?',
      () => { },
      () => { },
      async () => {
        await importaClassificaoFiscal(data)
      }
    )
  })

  async function importaClassificaoFiscal(data) {
    $('#btnConfirmarImportar').prop('disabled', true)
    $.LoadingOverlay('show')
    try {

      const response = await requisicao(
        "POST",
        "/sisplan/clafiscal/v1/importaleistranspitens?",
        "",
        JSON.stringify({ itens: data }),
        36000000
      );

      if (!response) {
        return;
      }

      if (response.status != 200) {
        let jsonStr = await response.json();
        msgErro(jsonStr.mensagem);
        return;
      }

      toastr.success("Percentuais atualizados com sucesso!", "Confirmação", {
        toastClass: "success",
        iconClasses: {
          error: "alert-error",
          info: "alert-info",
          success: "alert-success",
          warning: "alert-warning",
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
        onHidden() {
          $('#modal-importar-leitransparencia').modal('hide')
          $('#txtArquivoImportar').val('')
        },
      }).css({
        "margin-top": "20%",
        width: "500px",
        "max-width": "500px",
      });

    } catch (e) {
      msgErro('Não foi possível importar os dados.')
      console.log(e)
    } finally {
      $('#btnConfirmarImportar').prop('disabled', false)
      $.LoadingOverlay('hide')
      $('#btnConsultar').trigger('click')
    }
  }

  function criaTabelaImportar(info = []) {

    if ($.fn.DataTable.isDataTable('#tabelaImportar')) {
      $('#tabelaImportar').DataTable().destroy();
      $('#tabelaImportar').empty();
    }

    const cols = [
      {
        data: 'CODIGO',
        title: 'CODIGO'
      },
      {
        data: 'DESCRICAO',
        title: 'DESCRICAO'
      },
      {
        data: 'PERC_IMPOSTO',
        title: 'NACIONALFEDERAL'
      },
      {
        data: 'PERC_IMPOS_IMP',
        title: 'IMPORTADADOSFEDERAL'
      },
      {
        data: 'PERC_IMPOS_EST',
        title: 'ESTADUAL'
      },
      {
        data: 'PERC_IMPOS_MUN',
        title: 'MUNICIPAL'
      }
    ];

    $("#tabelaImportar").DataTable({
      sort: true,
      paging: false,
      destroy: true,
      lengthChange: false,
      filter: false,
      autoWidth: true,
      data: info,
      columns: cols
    });

    if (info.length > 0) {
      $('#btnConfirmarImportar').prop('disabled', false);
    } else {
      $('#btnConfirmarImportar').prop('disabled', true);
    }

  }

  $("#btnAddArquivo").on("click", function () {
    $("#mdModalUpload").trigger("click");
  })

  $("#btnImpLeiTransp").on('click', async function () {
    modalImportarLeiTransp()
  });

  async function modalImportarLeiTransp() {
    $.LoadingOverlay("show");
    $("#modal-importar-leitransparencia").modal("show");
    criaTabelaImportar()
    $.LoadingOverlay("hide");
  }

  // FIM IMPORTAR LEI TRANSPARÊNCIA 
});

$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([
      {
        element: "#btnFiltros",
        popover: {
          title: "Botão Filtros",
          description: "Clique aqui para filtrar a consulta.",
          position: "right",
        },
      },
      {
        element: "#btnNovaClaFiscal",
        popover: {
          title: "Botão Incluir",
          description:
            "Clique aqui para iniciar o cadastro de uma Classificação Fiscal.",
          position: "right",
        },
      },
      {
        element: "#tabelaClaFiscal",
        popover: {
          title: "Tabela de Classificações Fiscais",
          description: "Aqui estão todas as classificações cadastradas.",
          position: "top",
        },
      },
    ]);
    driver.start();
  });
});
