<?php include_once('../../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Material</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.2511.28.1">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/adminlte.min.css?versao=3.2511.28.1">

  <!-- Google Font: Source Sans Pro -->
  <link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,600,700,400italic' rel='stylesheet' type='text/css'>

  <link rel="stylesheet" href="dist/css/custom.css?versao=3.2511.28.1">
  <link rel="stylesheet" href="dist/css/sisplan.css?versao=3.2511.28.1">
  <link rel="stylesheet" href="dist/css/PesquisaVariosSelect2.css?versao=3.2511.28.1">
  <link rel="stylesheet" type="text/css" href="dist/css/dataTables.bootstrap4.min.css?versao=3.2511.28.1" />
  <link rel="shortcut icon" href="favicon.ico">
  <link rel="stylesheet" href="plugins/toastr/toastr.min.css?versao=3.2511.28.1">
  <link rel="stylesheet" type="text/css" href="dist/css/driver.min.css?versao=3.2511.28.1" />
  <link rel="stylesheet" href="dist/css/jquery-ui.css?versao=3.2511.28.1">
  <link rel="stylesheet" href="plugins/select2/css/select2.min.css?versao=3.2511.28.1">
  <link rel="stylesheet" href="plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css?versao=3.2511.28.1">
  <link rel="stylesheet" href="https://cdn.datatables.net/select/1.6.0/css/select.dataTables.min.css">
  <link rel="stylesheet" href="plugins/datatables-colreorder/css/colReorder.bootstrap4.min.css?versao=3.2511.28.1">
  <link rel="stylesheet" type="text/css" href="dist/css/sisplan.newColorsButtons.css?versao=3.2511.28.1" />
  <link rel="stylesheet" type="text/css" href="dist/css/sisplan.adjustDataTableButtons.css?versao=3.2511.28.1" />
  <style>
    #tabelaCadMaterial td div button {
      padding: .0rem .5rem;
      margin-top: .1rem;
      margin-bottom: .2rem;
    }

    #tabelaCadMaterial td {
      padding: 0 !important;
      padding-left: 10px !important;
    }

    .border-Field .textoBorda {
      font-size: 1.1em !important;
      text-align: left !important;
      width: auto;
      padding: 0 10px;
      border-bottom: none;
    }

    .border-Field {
      border: 1px solid var(--font-color) !important;
      border-radius: 3px !important;
      padding: 0 1.0em 0 1.0em !important;
      margin: 0 0 0 0 !important;
      -webkit-box-shadow: 0px 0px 0px 0px #000;
      box-shadow: 0px 0px 0px 0px #000;
    }


    #tabelaProdutosUtilizacao tr td,
    #tabelaProdutosUtilizacao th {
      padding: 4px 12px;
    }

    .bordaTabelasUtilizacao {
      padding: 10px;
      border: solid #e0e4e6;
      border-radius: 4px;
      border-width: 2px;
    }

    .table.dataTable tbody td,
    .table.dataTable thead {
      white-space: nowrap;
      text-overflow: ellipsis;
      overflow: hidden;
    }

    table.dataTable.table-sm>thead>tr>th :not(.sorting_disabled) {
      padding-right: 0px !important;
    }

    .dataTables_length {
      margin-top: 0px !important;
    }

    .dataTables_filter {
      margin-bottom: 3px !important;
    }

    #bordaImagem {
      width: 100%;
      height: 55vh;
      border: solid #fff;
      border-radius: 4px;
      border-width: 2px;
      padding: 20px;
      margin-top: 25px;
    }

    #infoimagem {
      max-width: 100%;
      max-height: 100%;
      width: auto;
      height: auto;

    }

  </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">
  <div class="wrapper">

    <div class="content-wrapper">
      <div class="content-header">
        <div class="container-fluid">
          <div class="row mb-2">
            <div class="col-sm-6 flex">
              <h1 class="m-0 text-dark">Material</h1>
              <button type="button" class="btn btn-info btn-sm ml-2" title="Tutorial" style="color: white;" id="tutorial">
                <i class="fas fa-question-circle"></i></button>
            </div>
            <div class="col-sm-6">
              <!-- <ol class="breadcrumb float-sm-right">
                                
                                <li class="breadcrumb-item active">Material</li>
                            </ol> -->
            </div><!-- /.col -->
          </div><!-- /.row -->
        </div>
        <div class="container-fluid">
          <div class="row card form-group" id="tabelaCadMaterialForne">
            <div class="col-12 d-flex justify-content-between" style="margin-top: 8px; padding-left: 20px; padding-right: 20px; margin-bottom: 5px">
              <div class="d-flex align-items-center" style="z-index:9999 !important">
                <button class="btn btn-sisp btnFiltros" id="btnFiltros"><span class="fas fa-search"></span> Filtros</button>
                <button class="btn btn-sisp btn-danger ml-1" id="btnNovoMaterial"><span class="fas fa-plus"></span> Incluir</button>
                <button id="btnImprimirAcessoMat" class="btn-sisp btn btn-primary ml-1"><i class="fas fa-print"></i> Imprimir</button>
                <button id="btnAlterarDadosEmMassa" data-target="modalAlterarDadosEmMassa" class="btn-sisp btn btnVerde ml-1" title="Clique para alterar dados em massa dos materiais selecionados."><i class="fas fa-sync"></i> Alterar Selecionados</button>
                <button id="btnUtilizacao" data-target="modalUtilizacao" class="btn-sisp btn btnFiltros ml-1"><i class="fas fa-clipboard-list"></i> Utilização</button>
              </div>
            </div>

            <div class="col-sm-12 table-responsive card-body pb-0" style="height: 65vh;">
              <h5 class="mb-0">Lista de Materiais</h5>
              <table id="tabelaCadMaterial" class="table table-sm table-select table-hover" width="100%" style="white-space: nowrap; width:100%">
                <thead>
                </thead>
                <tbody>
                </tbody>
              </table>
            </div>
            <hr>
            <div class="row">
              <div class="col-sm-6 table-responsive card-body pb-0 pt-2 border-r-1" style="height: 65vh;">
                <h5 class="mb-0">Cores</h5>
                <table id="tabelaCores" class="table table-sm table-select table-hover" width="100%" style="white-space: nowrap; width:100%">
                  <thead>
                  </thead>
                  <tbody>
                  </tbody>
                </table>
              </div>
              <div class="col-sm-6 table-responsive card-body pb-0 pt-2" style="height: 65vh;">
                <h5 class="mb-0">Imagem do material</h5>
                <div class="d-flex justify-content-center" id="bordaImagem">
                  <img class="pop img img-fluid imagem" id="infoimagem" alt="Imagem Material" src="./dist/img/prod-1.png">
                </div>
              </div>
            </div>

          </div>
          <div id="modal-filtros" class="modal" tabindex="-1" role="dialog">
            <div class="modal-dialog modal-xl" role="document">
              <div class="modal-content" id="modalBody">
                <div class="modal-header">
                  <h4 class="modal-title">Filtros</h4>
                  <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                  </button>
                </div>
                <div class="modal-body">

                  <div class="row justify-content-sm-start justify-content-center mb-3">
                    <div class="col-auto">
                      <fieldset class="form border-Field mb-0 pb-0 d-sm-flex d-block">
                        <legend class="textoBorda mb-0 pb-0">Opções</legend>
                        <div class="m-1 icheck-primary">
                          <input type="radio" id="cbTodos" name="cbStatus" value="" checked>
                          <label for="cbTodos">Todos</label>
                        </div>
                        <div class="m-1 icheck-primary">
                          <input type="radio" id="cbAtivo" name="cbStatus" value="S">
                          <label for="cbAtivo">Ativo</label>
                        </div>
                        <div class="m-1 icheck-primary">
                          <input type="radio" id="cbInativo" name="cbStatus" value="N">
                          <label for="cbInativo">Inativo</label>
                        </div>
                      </fieldset>
                    </div>
                  </div>
                  <div class="form-row">
                    <div class="col-xl-2 col-lg-3 col-6 form-group">
                      <div>
                        <label for="txtCadastroDe">Data Cadastro De:</label>
                        <div class="relative">
                          <input type="date" max="2500-12-31" value="1200-01-01" class="input-default focus form-control validate" id="txtCadastroDe">
                        </div>
                      </div>
                    </div>
                    <div class="col-xl-2 col-lg-3 col-6 form-group">
                      <div>
                        <label for="txtCadastroAte">Até:</label>
                        <div class="relative">
                          <input type="date" max="2500-12-31" value="2500-12-31" class="input-default focus form-control validate" id="txtCadastroAte">
                        </div>
                      </div>
                    </div>
                    <div class="col-xl-2 col-lg-3 col-6 form-group">
                      <div>
                        <label for="txtAlteracaoDe">Data Alteração De:</label>
                        <div class="relative">
                          <input type="date" max="2500-12-31" value="1200-01-01" class="input-default focus form-control validate" id="txtAlteracaoDe">
                        </div>
                      </div>
                    </div>
                    <div class="col-xl-2 col-lg-3 col-6 form-group">
                      <div>
                        <label for="txtAlteracaoAte">Até:</label>
                        <div class="relative">
                          <input type="date" max="2500-12-31" value="2500-12-31" class="input-default focus form-control validate" id="txtAlteracaoAte">
                        </div>
                      </div>
                    </div>
                    <div class="col-xl-4 col-lg-6 col-12 form-group">
                      <label data-error="wrong" data-success="right" for="txtMaterial">Material: </label>
                      <div class="relative">
                        <div class="input-group">
                          <select class="js-example-programmatic js-states form-control" id="txtMaterial" name="txtMaterial"
                            multiple="multiple"></select>
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnMaterial" name="btnMaterial" data-button="absolute"
                              type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaMaterial" type="button"><i
                                class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="col-xl-4 col-lg-6 col-12 form-group">
                      <label data-error="wrong" data-success="right" for="txtGrupo">Grupo: </label>
                      <div class="relative">
                        <div class="input-group">
                          <select class="js-example-programmatic js-states form-control" id="txtGrupo" name="txtGrupo"
                            multiple="multiple"></select>
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnGrupo" name="btnGrupo" data-button="absolute" type="button"><i
                                class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaGrupo" type="button"><i
                                class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="col-xl-4 col-lg-6 col-12 form-group">
                      <label data-error="wrong" data-success="right" for="txtSubGrupo">SubGrupo: </label>
                      <div class="relative">
                        <div class="input-group">
                          <select class="js-example-programmatic js-states form-control" id="txtSubGrupo" name="txtSubGrupo"
                            multiple="multiple"></select>
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnSubGrupo" name="btnSubGrupo" data-button="absolute"
                              type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaSubGrupo" type="button"><i
                                class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="col-xl-4 col-lg-6 col-12 form-group">
                      <label data-error="wrong" data-success="right" for="txtLinha">Linha: </label>
                      <div class="relative">
                        <div class="input-group">
                          <select class="js-example-programmatic js-states form-control" id="txtLinha" name="txtLinha"
                            multiple="multiple"></select>
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnLinha" name="btnLinha" data-button="absolute" type="button"><i
                                class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaLinha" type="button"><i
                                class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="col-xl-4 col-lg-6 col-12 form-group">
                      <label data-error="wrong" data-success="right" for="txtNcm">NCM: </label>
                      <div class="relative">
                        <div class="input-group">
                          <select class="js-example-programmatic js-states form-control" id="txtNcm" name="txtNcm"
                            multiple="multiple"> </select>
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnNcm" name="btnNcm" data-button="absolute" type="button"><i
                                class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaNcm" type="button"><i
                                class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="col-xl-4 col-lg-6 col-12 form-group">
                      <label data-error="wrong" data-success="right" for="txtClienteFornecedor">Cliente/Fornecedor: </label>
                      <div class="relative">
                        <div class="input-group">
                          <select class="js-example-programmatic js-states form-control" id="txtClienteFornecedor" name="txtClienteFornecedor"
                            multiple="multiple"> </select>
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnClienteFornecedor" name="btnClienteFornecedor" data-button="absolute" type="button"><i
                                class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaClienteFornecedor" type="button"><i
                                class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="col-xl-4 col-lg-6 col-12 form-group">
                      <label data-error="wrong" data-success="right" for="txtComposicao">Composição: </label>
                      <div class="relative">
                        <div class="input-group">
                          <select class="js-example-programmatic js-states form-control" id="txtComposicao" name="txtComposicao"
                            multiple="multiple"> </select>
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnComposicao" name="btnComposicao" data-button="absolute" type="button"><i
                                class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaComposicao" type="button"><i
                                class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="col-xl-4 col-lg-6 col-12 form-group">
                      <label data-error="wrong" data-success="right" for="txtStatus">Status: </label>
                      <div class="relative">
                        <div class="input-group">
                          <select class="js-example-programmatic js-states form-control" id="txtStatus" name="txtStatus"
                            multiple="multiple"> </select>
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnStatus" name="btnStatus" data-button="absolute" type="button"><i
                                class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaStatus" type="button"><i
                                class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="col-xl-4 col-lg-6 col-12 form-group">
                      <label data-error="wrong" data-success="right" for="txtIcmsSaida">ICMS Saída: </label>
                      <div class="relative">
                        <div class="input-group">
                          <select class="js-example-programmatic js-states form-control" id="txtIcmsSaida" name="txtIcmsSaida"
                            multiple="multiple"> </select>
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnIcmsSaida" name="btnIcmsSaida" data-button="absolute" type="button"><i
                                class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaIcmsSaida" type="button"><i
                                class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="col-xl-4 col-lg-6 col-12 form-group">
                      <label data-error="wrong" data-success="right" for="txtIcmsEntrada">ICMS Entrada: </label>
                      <div class="relative">
                        <div class="input-group">
                          <select class="js-example-programmatic js-states form-control" id="txtIcmsEntrada" name="txtIcmsEntrada"
                            multiple="multiple"> </select>
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnIcmsEntrada" name="btnIcmsEntrada" data-button="absolute" type="button"><i
                                class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaIcmsEntrada" type="button"><i
                                class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="col-xl-4 col-lg-6 col-12 form-group">
                      <label data-error="wrong" data-success="right" for="txtIpiSaida">IPI Saída: </label>
                      <div class="relative">
                        <div class="input-group">
                          <select class="js-example-programmatic js-states form-control" id="txtIpiSaida" name="txtIpiSaida"
                            multiple="multiple"> </select>
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnIpiSaida" name="btnIpiSaida" data-button="absolute" type="button"><i
                                class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaIpiSaida" type="button"><i
                                class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="col-xl-4 col-lg-6 col-12 form-group">
                      <label data-error="wrong" data-success="right" for="txtIpiEntrada">IPI Entrada: </label>
                      <div class="relative">
                        <div class="input-group">
                          <select class="js-example-programmatic js-states form-control" id="txtIpiEntrada" name="txtIpiEntrada"
                            multiple="multiple"> </select>
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnIpiEntrada" name="btnIpiEntrada" data-button="absolute" type="button"><i
                                class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaIpiEntrada" type="button"><i
                                class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="col-xl-4 col-lg-6 col-12 form-group">
                      <label data-error="wrong" data-success="right" for="txtFaixa">Faixa: </label>
                      <div class="relative">
                        <div class="input-group">
                          <select class="js-example-programmatic js-states form-control" id="txtFaixa" name="txtFaixa"
                            multiple="multiple"> </select>
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnFaixa" name="btnFaixa" data-button="absolute" type="button"><i
                                class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaFaixa" type="button"><i
                                class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="col-xl-4 col-lg-6 col-12 form-group">
                      <label data-error="wrong" data-success="right" for="txtCor">Cor: </label>
                      <div class="relative">
                        <div class="input-group">
                          <select class="js-example-programmatic js-states form-control" id="txtCor" name="txtCor"
                            multiple="multiple">
                          </select>
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnCor" name="btnCor" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaCor" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="col-xl-4 col-lg-6 col-12 form-group">
                      <label data-error="wrong" class="labelGeral" data-success="right" for="selectTipoVenda">Tipo Venda:</label>
                      <select class="input-default focus form-control" title='Quando a opção selecionada for "Não considerar", esse campo não será considerado na consulta.' data-dropdown-css-class="select2-danger" id="selectTipoVenda" aria-describedby="tipoError" class="custom-select focus">
                        <option value="">Não considerar</option>
                        <option value="0">Produção</option>
                        <option value="1">Revenda</option>
                      </select>
                    </div>
                    <div class="col-xl-4 col-lg-6 col-12 form-group">
                      <label data-error="wrong" class="labelGeral" data-success="right" for="selectPosse">Posse:</label>
                      <select class="input-default focus form-control" title='Quando a opção selecionada for "Não considerar", esse campo não será considerado na consulta.' data-dropdown-css-class="select2-danger" id="selectPosse" aria-describedby="tipoError" class="custom-select focus">
                        <option value="">Não considerar</option>
                        <option value="1">0 - Mercadoria de propriedade do informante e em seu poder</option>
                        <option value="2">1 - Mercadoria de propriedade do informante em poder de terceiros</option>
                        <option value="3">2 - Mercadoria de propriedade de terceiros em poder do informante</option>
                      </select>
                    </div>
                  </div>
                </div>
                <div class="modal-footer justify-content-start pl-0">
                  <div class="row col-12">
                    <div class="col-md-4 col-4">
                      <label for="txtOrdem">Opção de Relatório:</label>
                      <div class="relative d-flex align-items-center">
                        <select id="txtOrdem" class="input-default focus custom-select">
                        </select>
                        <button class="btn btn-sm btn-success ml-2 btnEdicaoRelatorio" title="Edição de ordenações">
                          <i class="fas fa-check"></i>
                        </button>
                      </div>
                    </div>
                    <div class="col-md-8 col-8 d-flex justify-content-end align-items-end pr-2">
                      <div class="d-flex">
                        <button class="btn btn-primary btn-sisp mr-2" id="btnLimparFiltros" style="background-color: #B22222; border-color: #B22222">
                          <span class="fas fa-trash"></span> Limpar Filtros
                        </button>
                        <button id="btnConsultar" class="btn btn-primary btn-sisp" type="button">
                          <span class="fas fa-search"></span> Consultar
                        </button>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="modal fade" data-backdrop="static" id="modalAlterarDadosEmMassa" tabindex="-1" role="dialog" aria-labelledby="modalAlterarDadosEmMassa" aria-hidden="true">
    <div class="modal-dialog" style="min-width: 80%; min-height: 100%">
      <div class="modal-content">
        <div class="modal-header">
          <h4 class="modal-title">Alterar Dados Em Massa</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body pb-0">
          <div class="form-row">
            <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
              <label data-error="wrong" class="labelGeral" data-success="right" for="txtCodigo2AlterarDados">Código 2:</label>
              <input class="input-default focus form-control campoAlterarDadosEmMassa" id="txtCodigo2AlterarDados" placeholder="Código 2" name="codigo2">
            </div>
            <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
              <label data-error="wrong" class="labelGeral" data-success="right" for="txtDescricaoAlterarDados">Descrição:</label>
              <input class="input-default focus form-control campoAlterarDadosEmMassa" id="txtDescricaoAlterarDados" placeholder="Descrição" name="txtDescricaoAlterarDados">
            </div>
            <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
              <label data-error="wrong" class="labelGeral" data-success="right" for="txtDescricao2AlterarDados">Descrição 2:</label>
              <input class="input-default focus form-control campoAlterarDadosEmMassa" id="txtDescricao2AlterarDados" placeholder="Descrição 2" name="txtDescricao2AlterarDados">
            </div>
            <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
              <label data-error="wrong" class="labelGeral" data-success="right" for="txtStatusAlterarDados">Status:</label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control campoAlterarDadosEmMassa" id="txtStatusAlterarDados" name="txtStatusAlterarDados" placeholder="Status">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btnStatusAlterarDados" name="btnStatusAlterarDados" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btnLimpaStatusAlterarDados" name="btnLimpaStatusAlterarDados" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>
            <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
              <label data-error="wrong" class="labelGeral" data-success="right" for="txtGrupoAlterarDados">Grupo:</label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control campoAlterarDadosEmMassa" id="txtGrupoAlterarDados" name="txtGrupoAlterarDados" placeholder="Grupo">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btnGrupoAlterarDados" name="btnGrupoAlterarDados" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btnLimpaGrupoAlterarDados" name="btnLimpaGrupoAlterarDados" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>
            <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
              <label data-error="wrong" class="labelGeral" data-success="right" for="txtSubgrupoAlterarDados">Subgrupo:</label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control campoAlterarDadosEmMassa" id="txtSubgrupoAlterarDados" name="txtSubgrupoAlterarDados" placeholder="Subgrupo">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btnSubgrupoAlterarDados" name="btnSubgrupoAlterarDados" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btnLimpaSubgrupoAlterarDados" name="btnLimpaSubgrupoAlterarDados" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>
            <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
              <label data-error="wrong" class="labelGeral" data-success="right" for="txtLinhaAlterarDados">Linha:</label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control campoAlterarDadosEmMassa" id="txtLinhaAlterarDados" name="txtLinhaAlterarDados" placeholder="Linha">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btnLinhaAlterarDados" name="btnLinhaAlterarDados" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btnLimpaLinhaAlterarDados" name="btnLimpaLinhaAlterarDados" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>
            <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
              <label data-error="wrong" class="labelGeral" data-success="right" for="txtComposicaoAlterarDados">Composição:</label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control campoAlterarDadosEmMassa" id="txtComposicaoAlterarDados" name="txtComposicaoAlterarDados" placeholder="Composição">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btnComposicaoAlterarDados" name="btnComposicaoAlterarDados" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btnLimpaComposicaoAlterarDados" name="btnLimpaComposicaoAlterarDados" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>
            <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
              <label data-error="wrong" class="labelGeral" data-success="right" for="txtClienteFornecedorAlterarDados">Cliente/Fornecedor:</label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control campoAlterarDadosEmMassa" id="txtClienteFornecedorAlterarDados" name="txtClienteFornecedorAlterarDados" placeholder="Cliente/Fornecedor">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btnClienteFornecedorAlterarDados" name="btnClienteFornecedorAlterarDados" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btnLimpaClienteFornecedorAlterarDados" name="btnLimpaClienteFornecedorAlterarDados" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>
            <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
              <label data-error="wrong" class="labelGeral" data-success="right" for="txtCstIcmsSaidaAlterarDados">CST ICMS Saída:</label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control campoAlterarDadosEmMassa" id="txtCstIcmsSaidaAlterarDados" name="txtCstIcmsSaidaAlterarDados" placeholder="CST ICMS">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btnCstIcmsSaidaAlterarDados" name="btnCstIcmsSaidaAlterarDados" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btnLimpaCstIcmsSaidaAlterarDados" name="btnLimpaCstIcmsSaidaAlterarDados" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>
            <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
              <label data-error="wrong" class="labelGeral" data-success="right" for="txtCstIcmsEntradaAlterarDados">CST ICMS Entrada:</label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control campoAlterarDadosEmMassa" id="txtCstIcmsEntradaAlterarDados" name="txtCstIcmsEntradaAlterarDados" placeholder="CST ICMS">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btnCstIcmsEntradaAlterarDados" name="btnCstIcmsEntradaAlterarDados" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btnLimpaCstIcmsEntradaAlterarDados" name="btnLimpaCstIcmsEntradaAlterarDados" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>
            <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
              <label data-error="wrong" class="labelGeral" data-success="right" for="txtCstIpiSaidaAlterarDados">CST IPI Saída:</label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control campoAlterarDadosEmMassa" id="txtCstIpiSaidaAlterarDados" name="txtCstIpiSaidaAlterarDados" placeholder="CST IPI">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btnCstIpiSaidaAlterarDados" name="btnCstIpiSaidaAlterarDados" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btnLimpaCstIpiSaidaAlterarDados" name="btnLimpaCstIpiSaidaAlterarDados" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>
            <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
              <label data-error="wrong" class="labelGeral" data-success="right" for="txtCstIpiEntradaAlterarDados">CST IPI Entrada:</label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control campoAlterarDadosEmMassa" id="txtCstIpiEntradaAlterarDados" name="txtCstIpiEntradaAlterarDados" placeholder="CST IPI">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btnCstIpiEntradaAlterarDados" name="btnCstIpiEntradaAlterarDados" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btnLimpaCstIpiEntradaAlterarDados" name="btnLimpaCstIpiEntradaAlterarDados" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>
            <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
              <label data-error="wrong" class="labelGeral" data-success="right" for="txtEnquadramentoIpiAlterarDados">Enquadramento IPI:</label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control campoAlterarDadosEmMassa" id="txtEnquadramentoIpiAlterarDados" name="txtEnquadramentoIpiAlterarDados" placeholder="Enquadramento IPI">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btnEnquadramentoIpiAlterarDados" name="btnEnquadramentoIpiAlterarDados" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btnLimpaEnquadramentoIpiAlterarDados" name="btnLimpaEnquadramentoIpiAlterarDados" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>
            <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
              <label data-error="wrong" class="labelGeral" data-success="right" for="selectPosseAlterarDados">Posse:</label>
              <select class="input-default focus form-control campoAlterarDadosEmMassa" title='Quando a opção selecionada for "Não informado", esse campo não será atualizado.' data-dropdown-css-class="select2-danger" id="selectPosseAlterarDados" aria-describedby="tipoError" class="custom-select focus">
                <option value="">Não informado</option>
                <option value="0">0 - Mercadoria de propriedade do informante e em seu poder</option>
                <option value="1">1 - Mercadoria de propriedade do informante em poder de terceiros</option>
                <option value="2">2 - Mercadoria de propriedade de terceiros em poder do informante</option>
              </select>
            </div>
            <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
              <label data-error="wrong" class="labelGeral" data-success="right" for="selectAtivoAlterarDados">Ativo:</label>
              <select class="input-default focus form-control campoAlterarDadosEmMassa" title='Quando a opção selecionada for "Não informado", esse campo não será atualizado.' data-dropdown-css-class="select2-danger" id="selectAtivoAlterarDados" aria-describedby="tipoError" class="custom-select focus">
                <option value="">Não informado</option>
                <option value="S">Sim</option>
                <option value="N">Não</option>
              </select>
            </div>
          </div>
          <div class="modal-footer px-0">
            <button type="submit" class="btn btn-primary btn-sisp" id="btnConfirmarAlterarDados">Confirmar</button>
            <button class="btn btn-danger btn-sisp" id="btnLimparCamposAlterarDados"><span class="fas fa-trash"></span>Limpar Campos</button>
            <button class="btn btn-danger btn-sisp" class="close" data-dismiss="modal" aria-label="Close" id="btnCancelarAlterarDados">Cancelar</button>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="modal fade" data-backdrop="static" id="modalUtilizacao" tabindex="-1" role="dialog" aria-labelledby="modalUtilizacao" aria-hidden="true">
    <div class="modal-dialog" style="min-width: 97%; min-height: 100vh">
      <div class="modal-content">
        <div class="modal-header">
          <h4 class="modal-title">Utilização</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body pb-0">
          <div class="form-row">
            <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
              <label data-error="wrong" data-success="right" for="txtMaterialUtilizacao">Material: </label>
              <div class="relative">
                <div class="input-group">
                  <select class="js-example-programmatic js-states form-control" id="txtMaterialUtilizacao" name="txtMaterialUtilizacao" multiple="multiple"></select>
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btnMaterialUtilizacao" name="btnMaterialUtilizacao" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btnLimpaMaterialUtilizacao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                  </div>
                </div>
              </div>
            </div>
            <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
              <label data-error="wrong" data-success="right" for="txtGrupoUtilizacao">Grupo: </label>
              <div class="relative">
                <div class="input-group">
                  <select class="js-example-programmatic js-states form-control" id="txtGrupoUtilizacao" name="txtGrupoUtilizacao" multiple="multiple"></select>
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btnGrupoUtilizacao" name="btnGrupoUtilizacao" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btnLimpaGrupoUtilizacao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                  </div>
                </div>
              </div>
            </div>
            <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
              <label data-error="wrong" data-success="right" for="txtSubgrupoUtilizacao">Subgrupo: </label>
              <div class="relative">
                <div class="input-group">
                  <select class="js-example-programmatic js-states form-control" id="txtSubgrupoUtilizacao" name="txtSubgrupoUtilizacao" multiple="multiple"></select>
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btnSubgrupoUtilizacao" name="btnSubgrupoUtilizacao" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btnLimpaSubgrupoUtilizacao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                  </div>
                </div>
              </div>
            </div>
            <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
              <label data-error="wrong" data-success="right" for="txtLinhaUtilizacao">Linha: </label>
              <div class="relative">
                <div class="input-group">
                  <select class="js-example-programmatic js-states form-control" id="txtLinhaUtilizacao" name="txtLinhaUtilizacao" multiple="multiple"></select>
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btnLinhaUtilizacao" name="btnLinhaUtilizacao" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btnLimpaLinhaUtilizacao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                  </div>
                </div>
              </div>
            </div>
            <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
              <label data-error="wrong" data-success="right" for="txtStatusUtilizacao">Status: </label>
              <div class="relative">
                <div class="input-group">
                  <select class="js-example-programmatic js-states form-control" id="txtStatusUtilizacao" name="txtStatusUtilizacao" multiple="multiple"></select>
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btnStatusUtilizacao" name="btnStatusUtilizacao" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btnLimpaStatusUtilizacao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                  </div>
                </div>
              </div>
            </div>
            <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
              <label data-error="wrong" data-success="right" for="txtCorUtilizacao">Cor: </label>
              <div class="relative">
                <div class="input-group">
                  <select class="js-example-programmatic js-states form-control" id="txtCorUtilizacao" name="txtCorUtilizacao" multiple="multiple"></select>
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btnCorUtilizacao" name="btnCorUtilizacao" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btnLimpaCorUtilizacao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                  </div>
                </div>
              </div>
            </div>
            <div class="col-xl-1 col-lg-2 col-md-3 col-6 form-group">
              <label data-error="wrong" class="labelGeral" data-success="right" for="selectSituacaoUtilizacao">Situação:</label>
              <select class="input-default focus form-control" data-dropdown-css-class="select2-danger" id="selectSituacaoUtilizacao" aria-describedby="tipoError" class="custom-select focus">
                <option value="">Todos</option>
                <option value="S">Ativos</option>
                <option value="N">Inativos</option>
              </select>
            </div>
            <div class="col-xl-1 col-lg-2 col-md-3 col-6 form-group">
              <label data-error="wrong" class="labelGeral" data-success="right" for="selectSituacaoCorUtilizacao">Situação Cor:</label>
              <select class="input-default focus form-control" data-dropdown-css-class="select2-danger" id="selectSituacaoCorUtilizacao" aria-describedby="tipoError" class="custom-select focus">
                <option value="">Todos</option>
                <option value="S">Ativos</option>
                <option value="N">Inativas</option>
              </select>
            </div>
            <div class="flex form-group ml-1 align-items-end">
              <button class="btn btn-primary btn-sisp" id="btnConsultarUtilizacao"><i class="fas fa-search"></i>Consultar</button>
            </div>
          </div>
          <div class="form-row">
            <div class="flex flex-column col-6">
              <div class="bordaTabelasUtilizacao">
                <h5 class="mb-0">Itens</h5>
                <div class="table-responsive">
                  <table id="tabelaItensUtilizacao" class="table table-sm table-select table-hover" width="100%">
                    <thead>
                    </thead>
                    <tbody>
                    </tbody>
                  </table>
                </div>
              </div>
            </div>
            <div class="flex flex-column col-6">
              <div class="bordaTabelasUtilizacao">
                <h5 class="mb-0">Cores</h5>
                <div class="table-responsive">
                  <table id="tabelaCoresUtilizacao" class="table table-sm table-select table-hover" width="100%">
                    <thead>
                    </thead>
                    <tbody>
                    </tbody>
                  </table>
                </div>
              </div>
            </div>
            <div class="flex flex-column col-12 my-2">
              <div class="bordaTabelasUtilizacao">
                <h5 class="mb-0">Produtos</h5>
                <div class="table-responsive">
                  <table id="tabelaProdutosUtilizacao" class="table table-select table-hover" width="100%">
                    <thead>
                    </thead>
                    <tbody>
                    </tbody>
                  </table>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <button class="btn btn-danger btn-sisp" id="btnLimparFiltrosUtilizacao"><i class="fas fa-trash"></i>Limpar Filtros</button>
          <button class="btn btn-danger btn-sisp" class="close" data-dismiss="modal" aria-label="Close" id="btnFecharUtilizacao">Fechar</button>
        </div>
      </div>
    </div>
  </div>

  <?php
  include_once('../../../modais.php');
  include_once('../../../modals/modal_anexos.html');
  ?>
  <aside class="control-sidebar control-sidebar-dark">
  </aside>
  </div>
  <script src="plugins/jquery/jquery.min.js?versao=3.2511.28.1"></script>
  <script type="text/javascript" src="dist/js/jquery.dataTables.js?versao=3.2511.28.1"></script>
  <script type="text/javascript" src="dist/js/dataTables.bootstrap4.min.js?versao=3.2511.28.1"></script>
  <script src="plugins/jquery-ui/jquery-ui.min.js?versao=3.2511.28.1"></script>
  <script>
    $.widget.bridge('uibutton', $.ui.button);
  </script>
  <script src="plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.2511.28.1"></script>
  <script src="dist/js/adminlte.min.js?versao=3.2511.28.1"></script>
  <script src="dist/js/sisplan.js?versao=3.2511.28.1"></script>
  <script src="utils/funcoes.js?versao=3.2511.28.1"></script>
  <script src="utils/cookies.js?versao=3.2511.28.1"></script>
  <script src="dist/js/requisicoes.js?versao=3.2511.28.1"></script>
  <script src="dist/js/loadingoverlay.min.js?versao=3.2511.28.1"></script>
  <script src="dist/js/driver.min.js?versao=3.2511.28.1"></script>
  <script src="plugins/toastr/toastr.min.js?versao=3.2511.28.1"></script>
  <script type="text/javascript" src="dist/js/sum().js?versao=3.2511.28.1"></script>
  <script type="text/javascript" src="config.js?versao=3.2511.28.1"></script>
  <script type="text/javascript" src="modals/modal_anexos.js?versao=3.2511.28.1"></script>
  <script type="text/javascript" src="modals/modal_medidas.js?versao=3.2511.28.1"></script>
  <script type="text/javascript" src="modals/modal_combinacao.js?versao=3.2511.28.1"></script>
  <script type="text/javascript" src="modals/modal_histprod.js?versao=3.2511.28.1"></script>
  <script type="text/javascript" src="modals/modal_fluxo_produto.js?versao=3.2511.28.1"></script>
  <script type="text/javascript" src="modals/modal_proditensest.js?versao=3.2511.28.1"></script>
  <script src="plugins/datatables-colreorder/js/dataTables.colReorder.min.js?versao=3.2511.28.1"></script>
  <script src="plugins/select2/js/select2.full.min.js?versao=3.2511.28.1"></script>
  <script src="dist/js/dataTables.keyTable2.js?versao=3.2511.28.1"></script>
  <script src="https://cdn.datatables.net/select/1.6.0/js/dataTables.select.min.js"></script>
  <script type="text/javascript" src="plugins/datatables-buttons/js/dataTables.buttons.min.js?versao=3.2511.28.1"></script>
  <script type="text/javascript" src="plugins/datatables-buttons/js/buttons.html5.min.js?versao=3.2511.28.1"></script>
  <script>
    $(document).ready(async function() {
      if (getCookie('usuario') == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
      }

      let usuario = getCookie('usuario');
      let empresa = getCookie('empresa');

      ipInterno = IP_INTERNO;
      ipExterno = IP_EXTERNO;
      basicAuth = BASIC_AUTH;

      const temAcesso = await temAcessoTela('MATERIAL');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, BASE_URI);
        return;
      }

      sArquivo = `${BASE_URI}/pages/material/acesso_material/acesso_material.js?versao=3.2511.28.1`;
      insereJavaScriptPagina(sArquivo);

    });
  </script>
</body>

</html>