$('#tutorial').on('click', function () {
	$(document).ready(async function () {
		const driver = new Driver({
			doneBtnText: 'Sair',
			closeBtnText: 'Fechar',
			nextBtnText: 'Próximo',
			prevBtnText: 'Anterior',
			allowClose: false,
		});
		driver.defineSteps([
			{
				element: '#txtEmpresa',
				popover: {
					title: 'Botões',
					description: 'Aqui estão os botões do caixa, onde você poderá filtrar sua busca, imprimir um relatório, fazer uma sangria ou um suprimento.',
					position: 'bottom'
				}
			},
			{
				element: '#tourlancamentosmanuais',
				popover: {
					title: 'Lançamentos Manuais',
					description: 'Aqui você poderá ver e criar lançamentos manuais para o caixa.',
					position: 'top'
				}
			},
			{
				element: '#caixatour',
				popover: {
					title: 'Dados Caixa',
					description: 'Aqui você poderá verificar os valores de cada moeda, sendo possível adicionar o valor de troco nas moedas que possuem essa opção.',
					position: 'top'
				}
			},
			{
				element: '#btnGravarTransferencia',
				popover: {
					title: 'Botao Gravar',
					description: 'Clicando aqui você grava a movimentação de saída, sendo possível assim receber os produtos em outra empresa.',
					position: 'left'
				}
			}
		]);
		//iniciar tour
		driver.start();
	});
});

$(document).ready(async function () {
	let colunas = JSON.parse(localStorage.getItem("colunasInvisiveisRelatorios"));

	if (colunas == null || colunas.tabelaItens == undefined) {
		localStorage.setItem(
			"colunasInvisiveisRelatorios",
			JSON.stringify({ ...colunas, tabelaItens: [] })
		);
		colunas = JSON.parse(localStorage.getItem("colunasInvisiveisRelatorios"));
	}

	$("#btnConfirmarColunas").on("click", async function () {
		try {
			$.LoadingOverlay("show");

			const novasColunas = retornaNovasColunasInvisiveis();

			localStorage.setItem(
				"colunasInvisiveisRelatorios",
				JSON.stringify({ ...colunas, tabelaItens: novasColunas })
			);

			$("#tabelaItens").DataTable().columns().visible(true);

			$("#tabelaItens")
				.DataTable()
				.columns()
				.every(function () {
					if (novasColunas.indexOf(this.dataSrc()) != -1) {
						this.visible(false);
					}
				});
		} finally {
			$.LoadingOverlay("hide");
			$("#modal-ColunasVisiveis").modal("hide");
		}
	});

	const parametrosSistema = await BuscaParametrosSistema()
	const parametrosMercadorias = await BuscaParametrosMercadorias()

	const utilizaDepositoTransitorio = parametrosMercadorias[0].VALOR == '1';
	const somenteBipagem = parametrosMercadorias[1].VALOR == '1'
	const bObrigaEntradaNota = parametrosMercadorias[2].VALOR == '1'
	const integracaoEPC = parametrosSistema[3].VALOR;
	const bloqNatureza = await CopiaParametro('FATURAMENTO', 13) == '1';
	const tabelaPadrao = await CopiaParametro('VENDA', 2)

	const bBarraLog = parametrosSistema[0].VALOR;
	const bApenasBarraLog = parametrosSistema[0].VALOR == '2';
	const bNFEAutomatico = parametrosMercadorias[3].VALOR;

	let bloqueiaSaida = false;

	if (integracaoEPC != '0') {
		$('.divRFID').removeClass("d-none");
	}

	if (utilizaDepositoTransitorio) {
		$('#divTipoMovSaida')
			.removeClass('col-lg-5')
			.addClass('col-lg-2')

		$('#divDepositoTransitorio').removeClass('d-none')
	}

	if (somenteBipagem || bApenasBarraLog) {
		$('#selectConferencia option[value="ConfTudo"], #selectConferencia option[value="ConfManual"]').addClass('d-none');
	}

	await carregaValoresPadroes();
	$("#txtNaturezaNFE").prop('disabled', bloqNatureza);
	let numeroDocNota = ''

	let codigoMovimentoSaida = '';
	let codigoMovimentoEntrada = '';

	async function carregaTipoTransferencia() {
		const pesquisaParam = {
			tabela: 'TABBAI',
			camposSelect: ['CODIGO', 'DESCRICAO', 'TIPO', 'ATIVO'],
			where: [`ATIVO = 'S'`],
		}
		const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

		let entrada = '';
		let saida = '';

		jsonStr.forEach(tipoEntradaSaida => {
			if (tipoEntradaSaida.TIPO) {
				if (tipoEntradaSaida.TIPO.charAt(19) === 'S') { //Saida Loja
					saida += saida ? `,'${tipoEntradaSaida.CODIGO}'` : `'${tipoEntradaSaida.CODIGO}'`;
				}
				if (tipoEntradaSaida.TIPO.charAt(18) === 'S') { //Entrada Loja
					entrada += entrada ? `,'${tipoEntradaSaida.CODIGO}'` : `'${tipoEntradaSaida.CODIGO}'`;
				}
			}
		});

		codigoMovimentoSaida = saida;
		codigoMovimentoEntrada = entrada;
	}

	await carregaTipoTransferencia();

	const tipoBanco = await retornaDatabase();
	setarDataAtual('dtEnvioDe')
	setarDataAtual('dtEnvioAte')
	setarDataAtual('dtDe')
	setarDataAtual('dtAte')

	insereValor('#txtEmpresaEntrada', getCookie('emp_id'), { tabela: 'EMPRESA', campoBusca: 'EMP_FANTASIA', campoWhere: 'EMP_ID', valorWhere: getCookie('emp_id') })

	// componenteFiltro('depositoUsuario', false, false, 'DepositoSaida')
	// componenteFiltro('empresa', false, false, 'EmpresaSaida')
	componenteFiltro('depositoUsuario', false, false, 'DepositoEntrada')
	componenteFiltro('depositoUsuario', false, false, 'DepositoTransitorio')
	componenteFiltro('pedido', false, false)
	componenteFiltro('pedido', false, false, 'PedidoConf')
	componenteFiltro('tabPreco', false, false, 'TabelaPreco')


	$('#txtPedido').on('blur', async function () {
		if (!$(this).val()) return
		const deposito = (await buscaValor('PEDIDO', 'DEPOSITO', 'NUMERO', pegaChave(this))).DEPOSITO

		insereValor('#txtDepositoSaida', deposito, { tabela: 'DEPOSITO', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: deposito })

		$('.controlaDepositoSaida').attr('disabled', true)

		$('#btnLimpaPedido').on('click', function () {
			$('#txtPedido').val('')
			$('#txtDepositoSaida').val('')
			$('.controlaDepositoSaida').attr('disabled', false)
		})

		new Promise((resolve, reject) => {
			msgAlerta('Deseja abrir a tela de conferência do pedido?',
				() => {
					$('#modal-conferencia-pedido')
						.off('hidden.bs.modal')
						.on('hidden.bs.modal', function () {
							reject();
							// $('#btnLimpaPedido').trigger('click')
						})
						.modal('show');
				},
				() => {
					resolve()
					$('#btnLimpaPedido').trigger('click')
				},
				() => {
					$('#modal-conferencia-pedido')
						.off('hidden.bs.modal')
						.on('hidden.bs.modal', function () {
							reject();
							// $('#btnLimpaPedido').trigger('click')
						})
						.modal('show');
				},
				() => {
					resolve()
					$('#btnLimpaPedido').trigger('click')
				}
			)
		})


	})

	$('#modal-conferencia-pedido').on('show.bs.modal', async function () {
		$.LoadingOverlay('show')
		try {
			const pedido = pegaChave("#txtPedido");

			let sWhere = '';
			sWhere += pedido ? ` AND PED_ITEN.NUMERO = '${pedido}'` : ''

			const pesquisa = {
				camposSelect: [
					"PRODUTO.CODIGO",
					"PRODUTO.DESCRICAO",
					"PED_ITEN.COR",
					"CADCOR.DESCRICAO DESC_COR",
					"PED_ITEN.TAM",
					"PED_ITEN.QUALIDADE TIPO",
					"SUM(PED_ITEN.QTDE) QTDE",
					"0 QTDE_CONF",
					// "PA_ITEN.BARRA",
					// "PA_ITEN.BARRA28",
					// "PA_ITEN.DT_VAL",
					// "PA_ITEN.DT_FAB",
				],
				tabela: "PED_ITEN",
				leftJoin: [
					{
						tabela: "PRODUTO",
						condicao: "PRODUTO.CODIGO = PED_ITEN.CODIGO",
					},
					{
						tabela: "CADCOR",
						condicao: "CADCOR.COR = PED_ITEN.COR",
					},
					// {
					// 	tabela: "PA_ITEN",
					// 	condicao: "PA_ITEN.CODIGO = PED_ITEN.CODIGO AND PA_ITEN.TAM = PED_ITEN.TAM AND PA_ITEN.COR = PED_ITEN.COR AND PED_ITEN.DEPOSITO = PA_ITEN.DEPOSITO",
					// },
				],
				where: [`1=1 ${sWhere}`],
				groupBy: [
					"PRODUTO.CODIGO",
					"PED_ITEN.CODIGO",
					"PRODUTO.DESCRICAO",
					"PED_ITEN.COR",
					"CADCOR.DESCRICAO",
					"PED_ITEN.QUALIDADE",
					"PED_ITEN.TAM",
					// "PA_ITEN.BARRA",
					// "PA_ITEN.BARRA28",
					// "PA_ITEN.DT_VAL",
					// "PA_ITEN.DT_FAB",
				],
			};

			retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));
			const table = $("#tabelaConferenciaPedido").DataTable();
			for (const item of retornoSelect) {
				const dados = {
					CODIGO: item.CODIGO,
					DESCRICAO: item.DESCRICAO,
					COR: item.COR,
					DESC_COR: item.DESC_COR,
					TAM: item.TAM,
					TIPO: item.TIPO,
					QTDE: item.QTDE,
					QTDE_CONF: item.QTDE_CONF,
					QTDE_TOTAL: item.QTDE,
					// BARRA: item.BARRA,
					// BARRA28: item.BARRA28,
					// DT_VAL: item.DT_VAL,
					// DT_FAB: item.DT_FAB,
				};

				if (item.QTDE === 0 && !estornaQuantidade) {
					msgAlerta("Quantidade em estoque insuficiente, verifique");
					continue;
				}

				const indexItem = table.data().toArray().findIndex(
					row => row.CODIGO === dados.CODIGO && row.COR === dados.COR && row.TIPO === dados.TIPO && dados.TAM === row.TAM && dados.BARRA === row.BARRA
				);

				if (indexItem === -1) {
					table.row.add(dados).draw(false);
					table.rows().nodes().to$().last().click();
				} else {
					const rowData = table.row(indexItem).data();
					let newQtde = estornaQuantidade ? rowData.QTDE - 1 : rowData.QTDE + 1;

					if (newQtde > dados.ESTOQUE) {
						msgAlerta("Quantidade excedida, verifique");
						continue;
					}

					if (newQtde < 0) {
						msgAlerta("Quantidade não pode ser negativa, verifique");
						continue;
					}

					if (newQtde === 0) {
						table.row(indexItem).remove().draw(false);
					} else {
						rowData.QTDE = newQtde;
						rowData.QUANTIDADE = `<input type="text" class="input-default focus form-control text-right txtQtdeIt" value="${rowData.QTDE}">`;
						table.row(indexItem).data(rowData).draw(false);
					}
				}
			}

		} catch (error) {

		} finally {
			$.LoadingOverlay('hide')
		}
	})

	$('#btnMais').on('click', function () {
		$('#barraBipar').addClass('d-none');
		$('#barraEstorno').removeClass('d-none');
		$('#txtBarraConfPedidoEstorno').focus();
	});

	$('#btnMenos').on('click', function () {
		$('#barraEstorno').addClass('d-none');
		$('#barraBipar').removeClass('d-none');
		$('#txtBarraConfPedido').focus();
	});

	$('#txtBarraConfPedidoEstorno').on('keydown', async function (event) {
		if ((event.key == 'Enter')) {
			$('#txtBarraConfPedidoEstorno').trigger('blur');
			$('#txtBarraConfPedidoEstorno').focus();
		}
	});

	$('#txtBarraConfPedido').on('keydown', async function (event) {
		if ((event.key == 'Enter')) {
			$('#txtBarraConfPedido').trigger('blur');
			$('#txtBarraConfPedido').focus();
		}
	});

	class BarraManager {
		constructor() {
			this.barrasLog = [];
			this.barrasLogsBipadas = [];
			this.listaBarrasBipadas = [];
			this.inicializaEventos();
		}

		inicializaEventos() {
			$('#txtBarraConfPedido').on('blur', () => {
				if ($('#txtBarraConfPedido').val() != '') {
					(async () => {
						await this.saidaBarra(true, false);
					})();
				}
			});

			$('#txtBarraConfPedidoEstorno').on('blur', () => {
				if ($('#txtBarraConfPedidoEstorno').val() != '') {
					(async () => {
						await this.saidaBarra(true, false);
					})();
				}
			});
		}

		async saidaBarra(bBipar = true, bEstornoEpc = false) {
			$.LoadingOverlay('show');
			try {
				let barra = bEstornoEpc
					? $('#txtBarraConfPedidoEstorno').val()
					: $('#txtBarraConfPedido').val();

				if (!barra) return;

				if ((($('#modal-warning').data('bs.modal') || {})._isShown == true) && (!bEstornoEpc)) {
					if (bEstornoEpc)
						$('#txtBarraConfPedidoEstorno').val('');
					else
						$('#txtBarraConfPedido').val('');
					return;
				}

				let barraLog = false;
				let barra28 = '';

				if ((bBarraLog == '1') || (bBarraLog == '2')) {
					barra28 = await extraiBarra28(barra);
					if (barra28 && (barra28 != '')) {
						barraLog = barra;
						barra = barra28;
					}
				}

				// if (!barraLog && (bBarraLog == '2')) {
				// 	msgAlerta('Necessário bipar uma BarraLog.', undefined, undefined, () => {
				// 		$('#txtBarraConfPedido').val('')
				// 		// if (bEstornoEpc)
				// 		// 	$('#txtBarraConfPedidoEstorno').val('').focus();
				// 		// else
				// 		// 	$('#txtBarraConfPedido').val('').focus();
				// 	});
				// 	return;
				// }

				await this.confereBarra(bBipar, barra, barraLog);

				// if (bEstornoEpc)
				// 	$('#txtBarraConfPedidoEstorno').focus();
				// else
				// 	$('#txtBarraConfPedido').focus();

			} catch (error) {
				console.error(error);
				msgAlerta(error.message || 'Não foi possível processar a barra.');
			} finally {
				$.LoadingOverlay('hide');
			}
		}

		async confereBarra(biparEstornar, barra, barraLog = false) {
			try {
				const params = `BARRA=${encodeURIComponent(barra)}&BARRA_LOG=${encodeURIComponent(barraLog)}&ESTORNO=${!biparEstornar ? 'S' : 'N'}`;
				const response = await requisicao('GET', '/sisplan/movimentacaofaccao/v1/retornadadosbarra?', params);

				if (!response) return;

				const jsonStr = await response.json();
				if (!jsonStr.length) {
					if (jsonStr.codigo != 200) throw new Error(jsonStr.mensagem);
					throw new Error('Nenhum item encontrado para a barra lida, verifique!');
				}

				const cor = jsonStr[0].COR;
				const tam = jsonStr[0].TAM;
				const codigo = jsonStr[0].CODIGO;
				const deposito = jsonStr[0].DEPOSITO;

				if (deposito !== '' && deposito !== pegaChave('#txtDepositoSaida')) {
					throw new Error('Barra não encontrada no depósito do pedido. Por favor, verifique!');
				}

				if (jsonStr[0].BARRA_LOG == 'S') {
					if (!biparEstornar) {
						if (!await this.estornaBarraBipadaPedido(barra)) {
							throw new Error('Barra não encontrada!');
						}
					} else if (!await barraJaEstaBipada(barra, biparEstornar)) {
						await this.adicionaBarraBipada({ codigo, cor, tam, barra });
					} else {
						return;
					}
				}

				const retorno = await this.bipaBarra(jsonStr, cor, tam, codigo, biparEstornar, barraLog);
				this.trataRetorno(retorno);

			} finally {
				$('#txtBarraConfPedido').focus()
				$('#txtBarraConfPedido').val('');
				$('#txtBarraConfPedidoEstorno').val('');
				$('#txtQtde').val('1');
			}
		}

		async bipaBarra(indices, cor, tam, codigo, biparEstornar, barraLog) {
			let retorno = 0;
			const tabela = $('#tabelaConferenciaPedido').DataTable();
			const tabelaItens = tabela.rows().data();
			let bEncontrou = false;

			tabelaItens.map((item, i) => {
				if (item.COR === cor && item.TAM === tam && item.CODIGO === codigo) {
					bEncontrou = true;
					let saldo = item.QTDE;
					let quant = item.QTDE_CONF;

					if (!biparEstornar) {
						if (saldo > item.QTDE) throw msgAlerta('Saldo não pode ser negativo, verifique!');
						item.QTDE = saldo + 1;
						item.QTDE_CONF = quant - 1;
						retorno = 0;
						this.removeBarraLogLida(barraLog);
						this.estornaBarraBipadaPedido(barraLog)
						// estornaBarraBipadaEPC();
					} else {
						if (item.QTDE == 0) throw msgAlerta('Nenhum saldo para a barra lida, verifique!');
						if (!this.addBarraLogLida(barraLog)) {
							retorno = 6;
						} else {
							item.QTDE = saldo - 1;
							item.QTDE_CONF = quant + 1;
							retorno = 0;
							if (!barraLog) item.BARRA = $('#txtBarraConfPedido').val()
						}
					}

					tabela.row(i).data(item).invalidate().draw(false);
					const rowNode = tabela.row(i).node();
					if (item.QTDE_CONF == item.QTDE_TOTAL) {
						$(rowNode).css('background-color', 'green');
					} else {
						$(rowNode).css('background-color', '');
					}
				}
			});

			if (!bEncontrou) throw new Error('Nenhum item encontrado para a barra lida, verifique!');

			if ((indices.length > 1) && (retorno != 0)) {
				indices.shift();
				return await this.bipaBarra(indices, cor, tam, codigo, biparEstornar, barraLog);
			} else {
				return retorno;
			}
		}

		trataRetorno(retorno) {
			switch (retorno) {
				case 0: SomAlerta(); break;
				case 1: msgAlerta('Impossível bipar quantidade maior do que há de pendente.'); SomAlerta(BASE_URI, true); break;
				case 2: msgAlerta('Quantidade total do item já conferida'); SomAlerta(BASE_URI, true); break;
				case 3: msgAlerta('Impossível estornar quantidade maior do que a conferida.'); SomAlerta(BASE_URI, true); break;
				case 4: msgAlerta('Toda a quantidade já foi estornada.'); SomAlerta(BASE_URI, true); break;
				case 5: msgAlerta('Estoque insuficiente para o item bipado.'); SomAlerta(BASE_URI, true); break;
				case 6: msgAlerta('Barra Log já lida, impossível ler novamente.'); SomAlerta(BASE_URI, true); break;
			}
		}

		removeBarraLogLida(barraLog) {
			if (this.barrasLogsBipadas.includes(barraLog) && barraLog) {
				this.barrasLogsBipadas.splice(this.barrasLogsBipadas.indexOf(barraLog), 1);
			}
		}

		async adicionaBarraBipada(objItem) {
			try {
				this.listaBarrasBipadas.push(objItem);
			} catch (error) {
				console.error(error);
			}
		}

		async estornaBarraBipadaPedido(sBarra) {
			if (!this.listaBarrasBipadas.find(item => item.barra == sBarra)) {
				return false;
			}
			this.listaBarrasBipadas = [...this.listaBarrasBipadas.filter(item => item.barra !== sBarra)];
			return true;
		}

		addBarraLogLida(barraLog) {
			if (!barraLog) return true;

			if (!this.barrasLogsBipadas.includes(barraLog)) {
				if (!validaBarraLogLiberada(barraLog.replace(/#/g, '[HASHTAG]')).then(result => !result)) {
					return false;
				}
				this.barrasLogsBipadas.push(barraLog);
				return true;
			} else {
				return false;
			}
		}
	}

	const barraManager = new BarraManager();

	$('#btnConfirmarConfPedido').on('click', async function () {
		try {
			const tabelaConf = $('#tabelaConferenciaPedido').DataTable();
			const dadosTabela = tabelaConf.rows().data().toArray();

			if (!dadosTabela.length) {
				msgAlerta('Não há itens na conferência para confirmar.');
				return;
			}

			const temPendentes = dadosTabela.some(item => item.QTDE_CONF < item.QTDE_TOTAL);

			if (temPendentes) {
				await new Promise((resolve, reject) => {
					msgAlerta(
						'Ainda existem quantidades pendentes. Se você confirmar, não será possível conferir o pedido novamente. Tem certeza que deseja confirmar?',
						() => resolve(),
						() => reject(),
						() => reject()
					);
				});
			}

			const dadosTratados = dadosTabela.map((item) => ({
				CODIGO: item.CODIGO || '',
				DESCRICAO: item.DESCRICAO || '',
				COR: item.COR || '',
				DESC_COR: item.DESC_COR || '',
				TAM: item.TAM || '',
				TIPO: item.TIPO || '',
				LOTE: '000000',
				ESTOQUE: item.QTDE_TOTAL || item.QTDE_CONF || 0,
				QUANTIDADE: item.QTDE_CONF || 0,
				BARRA28: item.BARRA28 || '',
				BARRA: item.BARRA || '',
				DT_FAB: item.DT_FAB || '',
				DT_VAL: item.DT_VAL || '',
				PEDIDO: pegaChave('#txtPedido')
			}));

			const tabelaEnvio = $('#tabelaEnvio').DataTable();
			tabelaEnvio.clear();
			tabelaEnvio.rows.add(dadosTratados).draw(false);

			$('#modal-conferencia-pedido').modal('hide')

		} catch (error) {
			console.log(error);
			if (error) return;
		}
	});

	const columnsConferenciaPedido = [
		{ "data": "CODIGO", "title": "Código" },
		{ "data": "DESCRICAO", "title": "Descrição" },
		{ "data": "COR", "title": "Cor" },
		{ "data": "DESC_COR", "title": "Desc_Cor" },
		{ "data": "TAM", "title": "Tamanho" },
		{ "data": "TIPO", "title": "Qualidade" },
		{ "data": "QTDE", "title": "Quantidade" },
		{ "data": "QTDE_CONF", "title": "Qtde. Conf." },
		// { "data": "BARRA28", "title": "Barra28" },
		// { "data": "DT_VAL", "title": "Dt. Validade" },
		// { "data": "DT_FAB", "title": "Dt. Fabricação" },
	]

	const columnsEnvio = [
		{ "data": "CODIGO", "title": "Código" },
		{ "data": "DESCRICAO", "title": "Descrição" },
		{ "data": "COR", "title": "Cor" },
		{ "data": "DESC_COR", "title": "Desc_Cor" },
		{ "data": "TAM", "title": "Tamanho" },
		{ "data": "TIPO", "title": "Qualidade" },
		{ "data": "LOTE", "title": "Lote" },
		{ "data": "ESTOQUE", "title": "Estoque" },
		{ "data": "QUANTIDADE", "title": "Qtde" },
		{ "data": "BARRA28", "title": "Barra28" },
		{ "data": "BARRA", "title": "Barra" },
		{ "data": "DT_FAB", "title": "Data de Fabricação" },
		{ "data": "DT_VAL", "title": "Data de Validade" },
		{ "data": "PEDIDO", "title": "Pedido" },
	]

	const columnsNotas = [
		{ "data": "SEL", "title": "Sel" },
		{ "data": "DOCUMENTO", "title": "Documento Envio" },
		{ "data": "USUARIO", "title": "Usuário" },
		{ "data": "DATA_HORA", "title": "Data" },
		{ "data": "NOTA_FISCAL", "title": "Nota Fiscal" },
		{ "data": "SERIE", "title": "Serie" },
		{ "data": "VOLUMES", "title": "Volumes" },
		{ "data": "DEPOSITO", "title": "Depósito" },
		{ "data": "EMP_ENVIO", "title": "Empresa Envio" },
		{ "data": "EMP_RECEB", "title": "Empresa Receb." },
		{ "data": "QTDE", "title": "Qtde" },
		{ "data": "QTDE_CONFERIDA", "title": "Qtde Conferida" },
		{ "data": "QTDE_PENDENTE", "title": "Qtde Pendente" },
		{ "data": "QTDE_CANC", "title": "Qtde Cancelada" },
		{ "data": "QTDE_REJEITADA", "title": "Qtde Rejeitada" },
		{ "data": "IMPRESSO", "title": "Status do Envio" },
		{ "data": "CONFERIDA", "title": "Status da Conferência" },
	]

	const columnsNotasEnviadas = [
		{ "data": "DOCUMENTO", "title": "Documento" },
		{ "data": "USUARIO", "title": "Usuário" },
		{ "data": "DATA_HORA", "title": "Data" },
		{ "data": "NOTA_FISCAL", "title": "Nota Fiscal" },
		{ "data": "SERIE", "title": "Serie" },
		{ "data": "EMP_RECEB", "title": "Emp_receb" },
		{ "data": "VOLUMES", "title": "Volumes" },
		{ "data": "QTDE", "title": "Qtde" },
		{ "data": "QTDE_CONFERIDA", "title": "Qtde Conferida" },
		{ "data": "QTDE_CANC", "title": "Qtde Cancelada" },
		{ "data": "QTDE_REJEITADA", "title": "Qtde Rejeitada" },
		{ "data": "CONFERIDA", "title": "Status Conferência" },
		{ "data": "LANCAMENTO", "title": "Lançamento" },
		{ "data": "IMPRESSO", "title": "Status do Envio" },
	]

	const columnsItens = [
		{ "data": "CODIGO", "title": "Código" },
		{ "data": "CODIGO2", "title": "Código2" },
		{ "data": "COR", "title": "Cor" },
		{ "data": "TAMANHO", "title": "Tamanho" },
		{ "data": "QUALIDADE", "title": "Qualidade" },
		{ "data": "LOTE", "title": "Lote" },
		{ "data": "BARRA28", "title": "Barra28" },
		{ "data": "BARRA", "title": "Barra" },
		{ "data": "QTDE", "title": "Qtde" },
		{ "data": "QTDE_CONFERIDA", "title": "Qtde_Conferida" },
		{ "data": "QTDE_PENDENTE", "title": "Qtde_Pendente" },
		{ "data": "NUMERO", "title": "Numero" },
		{ "data": "DOCUMENTO", "title": "Documento Envio" },
		{ "data": "TIPO_CONF", "title": "Tipo da Conferência" },
		{ "data": "DT_FAB", "title": "Data de Fabricação" },
		{ "data": "OBS", "title": "Observação" },
		{ "data": "DT_VAL", "title": "Data de Validade" },
		{ "data": "CUSTO", "title": "Custo" },
		{ "data": "BARRACLI", "title": "Barracli" },
	]

	const columnsVisualizarItens = [
		{ "data": "ID", "title": "Id" },
		{ "data": "CODIGO", "title": "Código" },
		{ "data": "COR", "title": "Cor" },
		{ "data": "TAM", "title": "Tamanho" },
		{ "data": "QUALIDADE", "title": "Qualidade" },
		{ "data": "DT_FAB", "title": "Data de Fabricação" },
		{ "data": "BARRA", "title": "Barra" },
		{ "data": "QTDE", "title": "Qtde" },
		{ "data": "QTDE_CONFERIDA", "title": "Qtde_Conferida" },
		{ "data": "QTDE_PENDENTE", "title": "Qtde_Pendente" },
		{ "data": "QTDE_CANC", "title": "Qtde_Cancelada" },
		{ "data": "QTDE_REJEITADA", "title": "Qtde_Rejeitada" },
		{ "data": "PESO_BRUTO", "title": "Peso Bruto" },
		{ "data": "DOCTO_E", "title": "Documento Entrada" },
		{ "data": "USUARIO_CONF", "title": "Usuário Conf." },
		{ "data": "DT_ENTRADA", "title": "Data Entrada" },
		{ "data": "TIPO_CONF", "title": "Tipo da Conferência" },
		{ "data": "DEPOSITO_E", "title": "Depósito Entrada" },
	]

	if (!navigator.mediaDevices || !navigator.mediaDevices.enumerateDevices) {
		console.log("enumerateDevices() not supported.");
	} else {
		encontraCamera();
	}

	var backCamID;

	function encontraCamera() {
		navigator.mediaDevices.enumerateDevices()
			.then(function (devices) {
				devices.forEach(function (device) {
					if (device.kind == "videoinput" && device.label.match(/back/) != null) {
						backCamID = device.deviceId;
					}
				});
			})
			.catch(function (err) {
				console.log(err.name + ": " + err.message);
			});

		if (typeof (backCamID) == "undefined") {
			console.log("back camera not found.");
		}
	}

	function iniciaCamera() {
		if (!navigator.mediaDevices) {
			navigator.mediaDevices.getUserMedia({
				video: true
			}.then(function (stream) {
				console.log('forçado inicio da câmera')
			}))
		}
		Quagga.init({
			locate: false,
			numOfWorkers: 2,
			inputStream: {
				name: "Live",
				type: "LiveStream",
				target: document.querySelector('#cam'),
				constraints: {
					//  width: '100%',
					//  height: '100%',
					//  facingMode: "environment"
					deviceId: backCamID
				},
				area: {
					// update area if its small mobile
					top: "32%",
					right: "10%",
					left: "10%",
					bottom: "32%"
				}
			},
			decoder: {
				readers: ["code_128_reader"]
			},
		}, function (err) {
			if (err) {
				msgAlertaSemConfirmacao('Nenhum dispositivo com câmera encontrado para realizar a bipagem, verifique!', 'modalCamera');
				return;
			} else {

				fixiOSVideo();

				if (typeof resolve === "function") {
					resolve.call(this);
				}
			}
			console.log("Initialization finished. Ready to start");
			Quagga.start();
		});
	}

	Quagga.onDetected(({
		codeResult
	}) => {
		const regexBarra = /[^/\\a-zA-Z0-9]/;
		if (regexBarra.test(codeResult.code)) {
			return;
		}

		if (isValidCode(codeResult)) {
			Quagga.stop();
			$('#txtBarra').val(codeResult.code).trigger('blur');
			$('#modalCamera').modal('hide');
		}

		Quagga.lastScannedCode = codeResult.code;

	});

	Quagga.onProcessed((result) => {
		const drawingCtx = Quagga.canvas.ctx.overlay;

		clearDrow();

		if (result) {
			if (result.boxes) {
				if (!Quagga.drowBox) {
					Quagga.drowBox = result.boxes[0];
				}

				Quagga.ImageDebug.drawPath(Quagga.drowBox, {
					x: 0,
					y: 1
				}, drawingCtx, {
					color: "green",
					lineWidth: 3
				});
			}

			const currentTime = Date.now();

			if (!Quagga.lastDetectingTime) {
				Quagga.lastDetectingTime = currentTime;
			}

			if (result.codeResult) {
				Quagga.lastDetectingTime = currentTime;
			} else if ((currentTime - Quagga.lastDetectingTime) / 1000 >= 2) {
				Quagga.lastDetectingTime = currentTime;
			}

			if (result.codeResult && result.codeResult.code) {
				Quagga.ImageDebug.drawPath(
					result.line, {
					x: "x",
					y: "y"
				},
					drawingCtx, {
					color: "red",
					lineWidth: 3
				}
				);
			}
		}
	});

	function clearDrow() {
		const drawingCtx = Quagga.canvas.ctx.overlay;
		const drawingCanvas = Quagga.canvas.dom.overlay;

		drawingCtx.clearRect(0, 0, parseInt(drawingCanvas.width), parseInt(drawingCanvas.height));
	}

	function fixiOSVideo() {
		const videoElement = Quagga.canvas.dom.overlay.parentElement.querySelector("video");

		setTimeout(() => {
			videoElement.play();
		}, 10);
	}

	function isValidCode({
		decodedCodes
	}) {
		const errors = decodedCodes.filter((x) => x.error !== undefined).map((y) => y.error); // TODO: use reduce
		const median = getMedian(errors);

		return median < 0.8;
	}

	function getMedian(arr) {
		const sorted = [...arr].sort((a, b) => a - b);
		const half = Math.floor(sorted.length / 2);

		if (arr.length % 2 === 1) {
			return arr[half];
		}

		return (arr[half - 1] + arr[half]) / 2;
	}

	$('#modalCamera').on('hidden.bs.modal', function () {
		Quagga.stop();
	});


	$('#btnCamera').on('click', function () {
		if (getCookie('protocolo') == 'http') {
			msgAlerta('Funcionalidade não habilitada, entre em contato com o Suporte da Sisplan!');
			return;
		}
		$('#modalCamera').modal('show');
		iniciaCamera();
	});

	$("#txtEmpresaRecebimento").autocompleta(1, `JSON={"tabela": "EMPRESA", "camposSelect": ["EMP_ID CHAVE", "EMP_FANTASIA DESCRICAO"], "where": []}`, [], [], []);
	$('#btnEmpresaRecebimento').pesquisa_serverside(['#txtEmpresaRecebimento'], ['EMP_ID'], ['EMP_FANTASIA'], `{"tabela":"EMPRESA", "camposSelect":[ "EMP_ID", "EMP_FANTASIA"], "where": []}`, 'Pesquisa de Empresa');
	$('#btnLimpaEmpresaRecebimento').on('click', function () {
		$('#txtEmpresaRecebimento').val('')
	})

	$("#txtEmpresaEnvio").autocompleta(1, `JSON={"tabela": "EMPRESA", "camposSelect": ["EMP_ID CHAVE", "EMP_FANTASIA DESCRICAO"], "where": []}`, [], [], []);
	$('#btnEmpresaEnvio').pesquisa_serverside(['#txtEmpresaEnvio'], ['EMP_ID'], ['EMP_FANTASIA'], `{"tabela":"EMPRESA", "camposSelect":[ "EMP_ID", "EMP_FANTASIA", "EMP_CNPJ"], "where": []}`, 'Pesquisa de Empresa');
	$('#btnLimpaEmpresaEnvio').on('click', function () {
		$('#txtEmpresaEnvio').val('')
	})

	$("#txtCor").autocompleta(1, `JSON={"tabela": "CADCOR", "camposSelect": ["COR CHAVE", "DESCRICAO DESCRICAO"], "where": null}`, [], [], []);
	$("#txtQualidade").autocompleta(1, `JSON={"tabela": "TABQUL", "camposSelect": ["CODIGO CHAVE", "DESCRICAO"], "where": null}`, [], [], []);
	$("#txtEmpresaSaida").autocompleta(3, `JSON={"tabela": "EMPRESA", "camposSelect": ["EMP_ID CHAVE", "EMP_FANTASIA DESCRICAO"], "where": []}`, [], [], []);
	$("#txtTipoMovEntrada").autocompleta(1, `JSON={"tabela": "TABBAI", "camposSelect": ["CODIGO CHAVE", "DESCRICAO"], "where": ["CODIGO IN (${codigoMovimentoEntrada})"]}`);
	$("#txtTipoMovSaida").autocompleta(1, `JSON={"tabela": "TABBAI", "camposSelect": ["CODIGO CHAVE", "DESCRICAO"], "where": ["CODIGO IN (${codigoMovimentoSaida})"]}`);

	$("#btnCor").pesquisa_array(["#txtCor"], ["CHAVE"], ["DESCRICAO"], '/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "CADCOR", "camposSelect": ["COR CHAVE", "DESCRICAO DESCRICAO"], "where": null}', "Pesquisa Cor", "cadcor");
	$("#btnQualidade").pesquisa_array(["#txtQualidade"], ["CHAVE"], ["DESCRICAO"], '/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "TABQUL", "camposSelect": ["CODIGO CHAVE", "DESCRICAO"], "where": null}', "Pesquisa Qualidade", "tabqul");
	$('#btnEmpresaSaida').pesquisa_serverside(['#txtEmpresaSaida'], ['EMP_ID'], ['EMP_FANTASIA'], `{"tabela":"EMPRESA", "camposSelect":[ "EMP_ID", "EMP_FANTASIA", "EMP_CNPJ"], "where": []}`, 'Pesquisa de Empresa');

	$('#btnNotaFiscalPesquisa').pesquisa_serverside(['#txtNotaFiscalPesquisa', '#txtNotaFiscalPesquisaDescInv'], ['NOTA.FATURA'], ['NOTA.SERIE'], `{"tabela": "NOTA", "camposSelect": ["NOTA.FATURA", "NOTA.SERIE", "NF_CONF_ENTRA.CONFERIDA", "NF_CONF_ENTRA.IMPRESSO"], "leftJoin": [{"tabela": "NF_CONF_ENTRA", "condicao": "NF_CONF_ENTRA.NUMERO = NOTA.FATURA"}], "where": ["NF_CONF_ENTRA.EMP_ID_ORIGEM = ${getCookie('emp_id')}", "NF_CONF_ENTRA.NUMERO = NOTA.FATURA"], "groupBy": ["NOTA.FATURA", "NOTA.SERIE", "NF_CONF_ENTRA.CONFERIDA", "NF_CONF_ENTRA.IMPRESSO"]}`, "Pesquisa Nota", '', [true, true]);
	$('#btnLimpaNotaFiscalPesquisa').on('click', function () {
		$('#txtNotaFiscalPesquisa').val('')
	});

	$('#btnNotaFiscalPesquisaConf').pesquisa_serverside(['#txtNotaFiscalPesquisaConf', '#txtNotaFiscalPesquisaDescInv'], ['NOTA.FATURA'], ['NOTA.SERIE'], `{"tabela": "NOTA", "camposSelect": ["NOTA.FATURA", "NOTA.SERIE", "NF_CONF_ENTRA.CONFERIDA", "NF_CONF_ENTRA.IMPRESSO"], "leftJoin": [{"tabela": "NF_CONF_ENTRA", "condicao": "NF_CONF_ENTRA.NUMERO = NOTA.FATURA"}], "where": ["NF_CONF_ENTRA.EMP_ID = ${getCookie('emp_id')}","NF_CONF_ENTRA.NUMERO = NOTA.FATURA"], "groupBy": ["NOTA.FATURA", "NOTA.SERIE", "NF_CONF_ENTRA.CONFERIDA", "NF_CONF_ENTRA.IMPRESSO"]}`, "Pesquisa Nota", '', [true, true]);
	$('#btnLimpaNotaFiscalPesquisaConf').on('click', function () {
		$('#txtNotaFiscalPesquisaConf').val('')
	});

	$('#btnTipoMovEntrada').on('click', function () {
		if (!codigoMovimentoEntrada) {
			msgErro('Não existe Tipo Movimento Entrada cadastrada como Entrada Loja na tela "Tipo Baixa" para essa consulta.');
			return;
		}

		$('#btnTipoMovEntrada').pesquisa_array(['#txtTipoMovEntrada'], ['CODIGO'], ['DESCRICAO'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABBAI", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": ["CODIGO IN (${codigoMovimentoEntrada})"]}`, 'Pesquisa Tipo Entrada', 'TABBAI');
	});

	$('#btnTipoMov').on('click', function () {
		if (!codigoMovimentoSaida) {
			msgErro('Não existe Tipo Movimento Saída cadastrada como Saída Loja na tela "Tipo Baixa" para essa consulta.');
			return;
		}

		$('#btnTipoMov').pesquisa_array(['#txtTipoMovSaida'], ['CODIGO'], ['DESCRICAO'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABBAI", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": ["CODIGO IN (${codigoMovimentoSaida})"]}`, 'Pesquisa Tipo Entrada', 'TABBAI');
	});

	$("#btnLimpaProduto").on("click", function () {
		$("#txtProduto").val("");
	});

	$("#btnLimpaCor").on("click", function () {
		$("#txtCor").val("");
	});

	$("#btnLimpaLote").on("click", function () {
		$("#txtLote").val("");
	});

	$("#btnLimpaQualidade").on("click", function () {
		$("#txtQualidade").val("");
	});

	$('#btnLimparTipoMovEntrada').on('click', function () {
		$('#txtTipoMovEntrada').val('')
	})

	$('#btnLimparTipoMov').on('click', function () {
		$('#txtTipoMovSaida').val('')
	})

	$('#btnLimpaEmpresaSaida').on('click', function () {
		$('#txtEmpresaSaida').val('')
	})

	$('#txtNatureza').autocompleta(1, `JSON={ "tabela":"natureza", "camposSelect":["NATUREZA CHAVE, DESCRICAO DESCRICAO"], "where": ["ATIVO = 'S' and TP_BASE = '1'"] }`);
	$('#txtCliente').autocompleta(3, `JSON={ "tabela":"entidade", "camposSelect":["ENTIDADE.CODCLI CHAVE, ENTIDADE.NOME DESCRICAO"], "where": [], "innerjoin": [{"tabela": "EMPRESA", "condicao": "EMPRESA.EMP_CNPJ = ENTIDADE.CNPJ"}] }`);
	$("#txtOperacao").autocompleta(1, `JSON={ "tabela":"oper_fiscal", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": [] }`);
	$("#txtTabelaPreco").autocompleta(1, `JSON={ "tabela":"REGIAO", "camposSelect":["REGIAO CHAVE, DESCRICAO DESCRICAO"], "where": [] }`);

	$('#btnCliente').pesquisa_serverside(['#txtCliente'], ['ENTIDADE.CODCLI'], ['ENTIDADE.NOME'], '{"tabela":"ENTIDADE", "camposSelect":[ "ENTIDADE.CODCLI", "ENTIDADE.NOME", "ENTIDADE.FANTASIA", "ENTIDADE.CNPJ"], "where": null, "innerjoin": [{"tabela": "EMPRESA", "condicao": "EMPRESA.EMP_CNPJ = ENTIDADE.CNPJ"}]}', 'Pesquisa de Cliente');
	$('#btnNatureza').pesquisa('#txtNatureza', 'NATUREZA', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"natureza", "camposSelect":[ "natureza", "descricao" ], "where": ["ATIVO = 'S' and TP_BASE = '1'"]}`, 'Pesquisa Natureza', 'natureza');
	$("#btnOperacao").pesquisa("#txtOperacao", "CODIGO", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"oper_fiscal", "camposSelect":[ "codigo", "descricao" ], "where": null}', "Pesquisa Operação", "oper_fiscal");
	$("#btnTabelaPreco").pesquisa("#txtTabelaPreco", "REGIAO", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"REGIAO", "camposSelect":[ "REGIAO", "DESCRICAO" ], "where": null}', "Pesquisa Tabela Preço", "REGIAO");

	$('#btnLimpaCliente').on('click', function () {
		$('#txtCliente').val('')
	})
	$('#btnLimpaNatureza').on('click', function () {
		$('#txtNatureza').val('')
	})
	$('#btnLimpaOperacao').on('click', function () {
		$('#txtOperacao').val('')
	})
	$('#btnLimpaTabelaPreco').on('click', function () {
		$('#txtTabelaPreco').val('')
	})

	let filtroDeposito;
	let depositos;
	filtroDeposito = await buscaDepositoEmpresaUsuario();
	depositos = `(${filtroDeposito})`;
	filtroDeposito = filtroDeposito == '' ? null : `CODIGO IN (${filtroDeposito})`;

	$("#txtDepositoSaida").autocompleta(
		1,
		`JSON={"tabela": "DEPOSITO", "camposSelect": ["CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": ["${filtroDeposito}"]}`,
		[],
		[],
		[],
		() => {
			if ($('#txtDepositoSaida').val()) {
				if (bBarraLog == 0) {
					$('.controlaDisabled').attr('disabled', false)
					$('.controlaDepositoSaida').attr('disabled', true)
				}
				$('#txtBarra').attr('disabled', false)
			}
			rotinaSaidaDeposito()
		}
	);

	$("#btnDepositoSaida").pesquisa_array(
		["#txtDepositoSaida"],
		["CHAVE"],
		["DESCRICAO"],
		`/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "DEPOSITO", "camposSelect": ["CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": ["${filtroDeposito}"]}`,
		"Pesquisa Depósito",
		"DEPOSITO",
		() => {
			if ($('#txtDepositoSaida').val()) {
				if (bBarraLog == 0) {
					$('.controlaDisabled').attr('disabled', false)
					$('.controlaDepositoSaida').attr('disabled', true)
				}
				$('#txtBarra').attr('disabled', false)
			}
			rotinaSaidaDeposito()
		}
	);

	$('#btnLimpaDepositoSaida').on('click', function () {
		$('#txtDepositoSaida').val('');
	})

	$("#CampoConferenciaQtde").hide();

	criaDataTable()
	async function criaDataTable(data = [], data2 = [], data3 = [], data4 = [], data5 = []) {
		$('#tabelaNotas').DataTable({
			searching: false,
			ordering: false,
			paging: false,
			info: true,
			destroy: true,
			colReorder: true,
			pageLength: 5,
			"language": {
				"sEmptyTable": "Nenhum registro encontrado",
				"sInfo": "_TOTAL_ registros",
				"sInfoEmpty": " 0 registros",
				"sInfoFiltered": "(Filtrados de _MAX_ registros)",
				"sInfoPostFix": "",
				"sInfoThousands": ".",
				"sLengthMenu": "_MENU_ resultados",
				"sLoadingRecords": "Carregando...",
				"sProcessing": "Processando...",
				"sZeroRecords": "Nenhum registro encontrado",
				"sSearch": "Pesquisar",
				"oPaginate": {
					"sNext": "Próximo",
					"sPrevious": "Anterior",
					"sFirst": "Primeiro",
					"sLast": "Último"
				},
				"oAria": {
					"sSortAscending": ": Ordenar colunas de forma ascendente",
					"sSortDescending": ": Ordenar colunas de forma descendente"
				}
			},
			"autoWidth": true,
			"data": data,
			"columns": columnsNotas,
			"columnDefs": []
		});

		$('#tabelaItens').DataTable({
			order: false,
			info: false,
			destroy: true,
			searching: false,
			lengthChange: false,
			paging: false,
			pageLength: 10,
			"language": {
				"sEmptyTable": "Nenhum registro encontrado",
				"sInfo": "_TOTAL_ registros",
				"sInfoEmpty": " 0 registros",
				"sInfoFiltered": "(Filtrados de _MAX_ registros)",
				"sInfoPostFix": "",
				"sInfoThousands": ".",
				"sLengthMenu": "_MENU_ resultados",
				"sLoadingRecords": "Carregando...",
				"sProcessing": "Processando...",
				"sZeroRecords": "Nenhum registro encontrado",
				"sSearch": "Pesquisar",
				"oPaginate": {
					"sNext": "Próximo",
					"sPrevious": "Anterior",
					"sFirst": "Primeiro",
					"sLast": "Último"
				},
				"oAria": {
					"sSortAscending": ": Ordenar colunas de forma ascendente",
					"sSortDescending": ": Ordenar colunas de forma descendente"
				}
			},
			"columnDefs": [{
				targets: [13, 14, 15, 16, 17, 18],
				visible: false
			},],
			"autoWidth": true,
			"data": data2,
			"columns": columnsItens,
		});

		const colunasInvisiveis = JSON.parse(
			localStorage.getItem("colunasInvisiveisRelatorios")
		);

		$("#tabelaItens")
			.DataTable()
			.columns()
			.every(function () {
				if (
					colunasInvisiveis.tabelaItens.indexOf(this.dataSrc()) != -1
				) {
					this.visible(false);
				}
			});

		$('#tabelaConferenciaPedido').DataTable({
			ordering: false,
			searching: false,
			paging: false,
			pageLength: 5,
			destroy: true,
			autoWidth: true,
			scrollX: true,
			"language": {
				"sEmptyTable": "Nenhum registro encontrado",
				"sInfo": "_TOTAL_ registros",
				"sInfoEmpty": " 0 registros",
				"sInfoFiltered": "(Filtrados de _MAX_ registros)",
				"sInfoPostFix": "",
				"sInfoThousands": ".",
				"sLengthMenu": "_MENU_ resultados",
				"sLoadingRecords": "Carregando...",
				"sProcessing": "Processando...",
				"sZeroRecords": "Nenhum registro encontrado",
				"sSearch": "Pesquisar",
				"oPaginate": {
					"sNext": "Próximo",
					"sPrevious": "Anterior",
					"sFirst": "Primeiro",
					"sLast": "Último"
				},
				"oAria": {
					"sSortAscending": ": Ordenar colunas de forma ascendente",
					"sSortDescending": ": Ordenar colunas de forma descendente"
				}
			},
			"autoWidth": true,
			"data": [],
			"columns": columnsConferenciaPedido,
			"columnDefs": [
				// {
				// 	targets: [8, 9, 10],
				// 	visible: false
				// },
				// {
				// 	targets: [7],
				// 	className: "text-right"
				// },
			]
		});

		$('#tabelaEnvio').DataTable({
			ordering: false,
			searching: false,
			paging: false,
			pageLength: 5,
			destroy: true,
			autoWidth: true,
			scrollX: true,
			"language": {
				"sEmptyTable": "Nenhum registro encontrado",
				"sInfo": "_TOTAL_ registros",
				"sInfoEmpty": " 0 registros",
				"sInfoFiltered": "(Filtrados de _MAX_ registros)",
				"sInfoPostFix": "",
				"sInfoThousands": ".",
				"sLengthMenu": "_MENU_ resultados",
				"sLoadingRecords": "Carregando...",
				"sProcessing": "Processando...",
				"sZeroRecords": "Nenhum registro encontrado",
				"sSearch": "Pesquisar",
				"oPaginate": {
					"sNext": "Próximo",
					"sPrevious": "Anterior",
					"sFirst": "Primeiro",
					"sLast": "Último"
				},
				"oAria": {
					"sSortAscending": ": Ordenar colunas de forma ascendente",
					"sSortDescending": ": Ordenar colunas de forma descendente"
				}
			},
			"autoWidth": true,
			"data": data3,
			"columns": columnsEnvio,
			"columnDefs": [
				{
					targets: [11, 12, 13],
					visible: false
				},
				{
					targets: [7],
					className: "text-right"
				},
			]
		});

		$('#tabelaNotasEnviadas').DataTable({
			ordering: false,
			searching: false,
			paging: false,
			info: true,
			destroy: true,
			colReorder: true,
			"language": {
				"sEmptyTable": "Nenhum registro encontrado",
				"sInfo": "_TOTAL_ registros",
				"sInfoEmpty": " 0 registros",
				"sInfoFiltered": "(Filtrados de _MAX_ registros)",
				"sInfoPostFix": "",
				"sInfoThousands": ".",
				"sLengthMenu": "_MENU_ resultados",
				"sLoadingRecords": "Carregando...",
				"sProcessing": "Processando...",
				"sZeroRecords": "Nenhum registro encontrado",
				"sSearch": "Pesquisar",
				"oPaginate": {
					"sNext": "Próximo",
					"sPrevious": "Anterior",
					"sFirst": "Primeiro",
					"sLast": "Último"
				},
				"oAria": {
					"sSortAscending": ": Ordenar colunas de forma ascendente",
					"sSortDescending": ": Ordenar colunas de forma descendente"
				}
			},
			"autoWidth": true,
			"data": data4,
			"columns": columnsNotasEnviadas,
			"columnDefs": []
		});

		$('#tabelaVisualizarItens').DataTable({
			destroy: true,
			filter: false,
			lengthChange: false,
			search: false,
			paginate: false,
			info: false,
			ordering: false,
			autoWidth: true,
			"language": {
				"sEmptyTable": "Nenhum registro encontrado",
				"sInfo": "_TOTAL_ registros",
				"sInfoEmpty": " 0 registros",
				"sInfoFiltered": "(Filtrados de _MAX_ registros)",
				"sInfoPostFix": "",
				"sInfoThousands": ".",
				"sLengthMenu": "_MENU_ resultados",
				"sLoadingRecords": "Carregando...",
				"sProcessing": "Processando...",
				"sZeroRecords": "Nenhum registro encontrado",
				"sSearch": "Pesquisar",
				"oPaginate": {
					"sNext": "Próximo",
					"sPrevious": "Anterior",
					"sFirst": "Primeiro",
					"sLast": "Último"
				},
				"oAria": {
					"sSortAscending": ": Ordenar colunas de forma ascendente",
					"sSortDescending": ": Ordenar colunas de forma descendente"
				}
			},
			"data": data5,
			"columns": columnsVisualizarItens,
			"columnDefs": []
		});
	}

	function retornaBotaoOpcoesEnviadas(sDocumento) {
		var retorno = '<div style="text-align:center;"> ' +
			'    <div class="dropdown" width="200px!important"> ' +
			'       <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
			'         ' + sDocumento + ' ' +
			'       </button> ' +
			'       <div class="dropdown-menu dropDownVenda" style="z-index: 999999; max-height: 380px !important; min-heigth: 380px !important; overflow-y: scroll; scrollbar-color: var(--drop-down-theme);min-width: 200px !important"> ' +
			'          <a id="btnVisualizarItensEnviadas" class="dropdown-item" href="#"><i class="fas fa-search"></i> Visualizar Itens</a>' +
			'          <a id="btnImprimirEnviadas" title="TransfMercadoriasProduto" class="dropdown-item" href="#"><i class="fas fa-print"></i> Imprimir</a>' +
			'          <a id="btnGerarNfeEnvio" class="dropdown-item" href="#"><i class="fas fa-clipboard-list"></i> Gerar Nfe Envio</a>' +
			'          <a id="btnCancelarEnvio" class="dropdown-item" href="#"><i class="far fa-times-circle"></i> Cancelar Envio</a>' +
			'       </div>' +
			'   </div>' +
			'</div>';

		return retorno;
	}

	$("#tabelaNotasEnviadas").on("click", "#btnImprimirEnviadas", async function () {
		const table = $('#tabelaNotasEnviadas').DataTable().row($(this).parents("tr")).data();
		await imprimirTransferencia(table.DOCUMENTO);
	});

	$("#tabelaNotasEnviadas").on("click", "#btnVisualizarItensEnviadas", async function () {
		const table = $('#tabelaNotasEnviadas').DataTable().row($(this).parents("tr")).data();
		buscaDadosVisualizarItens(table.DOCUMENTO)
		$('#modalVisualizarItens').modal('show');
	});

	async function buscaEmpresaDestino(empId) {

		let sWhere = ''
		sWhere += ` AND EMPRESA.EMP_ID = ${empId}`

		const sql = {
			camposSelect: [
				"ENTIDADE.CODCLI",
				"ENTIDADE.NOME",
			],
			tabela: "ENTIDADE",
			innerJoin: [
				{
					tabela: "EMPRESA",
					condicao: "ENTIDADE.CNPJ = EMPRESA.EMP_CNPJ",
				},
			],
			where: [`1=1 ${sWhere}`]
		};

		const dados = await retornaJsonPesquisaPadrao(JSON.stringify(sql));

		return { codcli: dados[0]?.CODCLI, nome: dados[0]?.NOME }
	}

	$("#tabelaNotasEnviadas").on("click", "#btnGerarNfeEnvio", async function () {
		const table = $('#tabelaNotasEnviadas').DataTable().row($(this).parents("tr")).data();
		if (table.NOTA_FISCAL) {
			throw msgAlerta('Já existe uma nota fiscal para esta transfarência, impossível continuar.')
		}
		if (table.IMPRESSO === 'C') {
			throw msgAlerta('Documento já está cancelado, impossível continuar.')
		}

		const { codcli, nome } = await buscaEmpresaDestino(table.EMP_RECEB.split(' ')[0]);
		if (!codcli) {
			$('.cliente').prop('disabled', false)
		} else {
			insereValor('#txtCliente', codcli, nome);
			$('#txtCliente').attr('disabled', true)
			$('#btnCliente').attr('disabled', true)
			$('#btnLimpaCliente').attr('disabled', true)
		}

		const operacao = await retornaValorCadPadrao('TRANSF_MERCADORIAS', 'OPERACAO') ?? ''
		insereValor('#txtOperacao', operacao, { tabela: 'OPER_FISCAL', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: operacao });
		if (operacao) {
			$('#txtNatureza').attr('disabled', true)
			$('#btnNatureza').attr('disabled', true)
			$('#btnLimpaNatureza').attr('disabled', true)
		} else {
			$('#txtNatureza').attr('disabled', false)
			$('#btnNatureza').attr('disabled', false)
			$('#btnLimpaNatureza').attr('disabled', false)
		}
		numeroDocNota = table.DOCUMENTO;
		$('#modalFaturarTransferencia').modal('show')
	});

	$("#tabelaNotasEnviadas").on("click", "#btnCancelarEnvio", async function () {
		const table = $('#tabelaNotasEnviadas').DataTable().row($(this).parents("tr")).data();
		if (table.IMPRESSO === 'C') {
			throw msgAlerta('Documento já está cancelado, impossível cancelar.')
		}
		if (table.QTDE_CONFERIDA > 0) {
			throw msgAlerta('Já existe quantidades conferidas para esse documento, impossível cancelar.')
		}
		if (table.NOTA_FISCAL) {
			if ((await buscaValor('NOTA', 'IMPRESSO', 'FATURA', table.NOTA_FISCAL)).IMPRESSO !== 'C') {
				throw msgAlerta('Existe uma nota fiscal vinculada a esta transferência. Você precisa cancelar a nota para prosseguir.')
			}
		}
		await cancelaEnvio(table.LANCAMENTO);
	});

	function retornaBotaoOpcoesNotas(sDocumento) {
		var retorno = '<div style="text-align:center;"> ' +
			'    <div class="dropdown" width="200px!important"> ' +
			'       <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
			'         ' + sDocumento + ' ' +
			'       </button> ' +
			'       <div class="dropdown-menu dropDownVenda" style="z-index: 999999; max-height: 380px !important; min-heigth: 380px !important; scrollbar-color: var(--drop-down-theme);min-width: 200px !important;top:-50px !important"> ' +
			'       <a id="btnVisualizarItensNotas" class="dropdown-item" href="#"><i class="fas fa-search"></i> Visualizar Itens</a>' +
			'       <a id="btnImprimirNotas" class="dropdown-item" title="TransfMercadoriasProduto" href="#"><i class="fas fa-print"></i> Imprimir</a>' +
			'       </div>' +
			'   </div>' +
			'</div>';

		return retorno;
	}

	$("#tabelaNotas").on("click", "#btnImprimirNotas", async function () {
		const table = $('#tabelaNotas').DataTable().row($(this).parents("tr")).data();
		await imprimirTransferencia(table.DOCUMENTO);
	});

	$("#tabelaNotas").on("click", "#btnVisualizarItensNotas", async function () {
		const table = $('#tabelaNotas').DataTable().row($(this).parents("tr")).data();
		buscaDadosVisualizarItens(table.DOCUMENTO)
		$('#modalVisualizarItens').modal('show');
	});

	async function buscaDadosVisualizarItens(docto) {
		if ($.fn.DataTable.isDataTable('#tabelaVisualizarItens')) {
			$('#tabelaVisualizarItens').DataTable().destroy();
			$('#tabelaVisualizarItens').empty();
		};

		let sWhere = ''
		sWhere += ` AND NF_CONF_ENTRA.DOCTO_S = '${docto}'`
		const separador = "' - '"
		const sql = {
			camposSelect: [
				"NF_CONF_ENTRA.ID",
				`PRODUTO.CODIGO || ${separador} || PRODUTO.DESCRICAO CODIGO`,
				`CADCOR.COR  || ${separador} || CADCOR.DESCRICAO COR`,
				"NF_CONF_ENTRA.TAM",
				"NF_CONF_ENTRA.QUALIDADE",
				"NF_CONF_ENTRA.DT_FAB",
				"NF_CONF_ENTRA.BARRA",
				"NF_CONF_ENTRA.QTDE",
				"NF_CONF_ENTRA.QTDE_CONFERIDA",
				"NF_CONF_ENTRA.QTDE_REJEITADA",
				"NF_CONF_ENTRA.QTDE_CANC",
				"SUM(NF_CONF_ENTRA.QTDE - NF_CONF_ENTRA.QTDE_CONFERIDA - NF_CONF_ENTRA.QTDE_CANC - NF_CONF_ENTRA.QTDE_REJEITADA) QTDE_PENDENTE",
				"NF_CONF_ENTRA.PESO_BRUTO",
				"NF_CONF_ENTRA.DOCTO_E",
				"ACESSO_USUARIOS.NOME USUARIO_CONF",
				"NF_CONF_ENTRA.DT_ENTRADA",
				"NF_CONF_ENTRA.TIPO_CONF",
				"DEPOSITO.CODIGO DEPOSITO_E",
			],
			tabela: "NF_CONF_ENTRA",
			leftJoin: [
				{
					tabela: "PRODUTO",
					condicao: "NF_CONF_ENTRA.ID_PRO = PRODUTO.ID",
				},
				{
					tabela: "CADCOR",
					condicao: "NF_CONF_ENTRA.ID_COR = CADCOR.ID",
				},
				{
					tabela: "DEPOSITO",
					condicao: "DEPOSITO.ID = NF_CONF_ENTRA.ID_DEP_E",
				},
				{
					tabela: "ACESSO_USUARIOS",
					condicao: "ACESSO_USUARIOS.ID = NF_CONF_ENTRA.ID_ACE_USU_CONF",
				},
			],
			where: [`1=1 ${sWhere}`],
			groupBy: [
				"NF_CONF_ENTRA.ID",
				"PRODUTO.CODIGO",
				"PRODUTO.DESCRICAO",
				"CADCOR.COR",
				"CADCOR.DESCRICAO",
				"NF_CONF_ENTRA.TAM",
				"NF_CONF_ENTRA.QUALIDADE",
				"NF_CONF_ENTRA.DT_FAB",
				"NF_CONF_ENTRA.BARRA",
				"NF_CONF_ENTRA.QTDE",
				"NF_CONF_ENTRA.QTDE_CONFERIDA",
				"NF_CONF_ENTRA.QTDE_REJEITADA",
				"NF_CONF_ENTRA.QTDE_CANC",
				"NF_CONF_ENTRA.PESO_BRUTO",
				"NF_CONF_ENTRA.DOCTO_E",
				"ACESSO_USUARIOS.NOME",
				"NF_CONF_ENTRA.DT_ENTRADA",
				"NF_CONF_ENTRA.TIPO_CONF",
				"DEPOSITO.CODIGO",
			]
		};

		const dados = await retornaJsonPesquisaPadrao(JSON.stringify(sql));

		$('#tabelaVisualizarItens').DataTable({
			destroy: true,
			filter: false,
			lengthChange: false,
			search: false,
			paginate: false,
			info: false,
			ordering: false,
			autoWidth: true,
			"language": {
				"sEmptyTable": "Nenhum registro encontrado",
				"sInfo": "_TOTAL_ registros",
				"sInfoEmpty": " 0 registros",
				"sInfoFiltered": "(Filtrados de _MAX_ registros)",
				"sInfoPostFix": "",
				"sInfoThousands": ".",
				"sLengthMenu": "_MENU_ resultados",
				"sLoadingRecords": "Carregando...",
				"sProcessing": "Processando...",
				"sZeroRecords": "Nenhum registro encontrado",
				"sSearch": "Pesquisar",
				"oPaginate": {
					"sNext": "Próximo",
					"sPrevious": "Anterior",
					"sFirst": "Primeiro",
					"sLast": "Último"
				},
				"oAria": {
					"sSortAscending": ": Ordenar colunas de forma ascendente",
					"sSortDescending": ": Ordenar colunas de forma descendente"
				}
			},
			"data": dados,
			"columns": columnsVisualizarItens,
			"columnDefs": [
				{
					type: 'date-br',
					targets: [5, 15],
					render: function (data) {
						if (data != undefined && data != '') {
							x = data.slice(0, 10).split('-');
							hora = data.split(' ')[1]
							if (x[2]) {
								return `${x[2]}/${x[1]}/${x[0]}`
							} else {
								return `${x} ${hora} `;
							}
						} else {
							return ''
						}
					}
				},
			],
		});
	}

	async function imprimirTransferencia(sDocumento) {
		try {
			$.LoadingOverlay('show');

			url = `/sisplan/impressao/v1/transfmercadorias?`;
			const bImprimeAutomatico = await verificaImprimirAutomatico('TransfMercadoriasProduto');
			arquivo = await GeraRelatorio(`${url}&DOCUMENTO=${sDocumento}&IS_PRODUTO=${'S'}`, "POST", 15000, false, 'TransfMercadoriasProduto');
			if (arquivo != undefined && arquivo != "") {
				if (!bImprimeAutomatico) {
					window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
				}
				await limparRelatorios();
			}

		} catch (error) {
			console.log(error)
		} finally {
			$.LoadingOverlay('hide');
		}
	}

	function atualizaQuantidade() {
		let quantidadeTotal = 0;

		$('.txtQtdeIt').each(function () {
			const valor = parseFloat($(this).val()) || 0;
			quantidadeTotal += valor;
		});
		$('#txtQuantidadeItens').val(TruncaDecimaisNova(2, quantidadeTotal));
	}

	async function cancelaEnvio(sLancamento) {
		$.LoadingOverlay('show')
		try {
			const sCodBaixa = await retornaValorCadPadrao('TRANSF_MERCADORIAS', 'COD_BAIXA_CANC_ENVIO') ?? ''
			const response = await requisicao('PUT',
				`/sisplan/estoque/v1/transferenciamercadorias_produto?`,
				`LANCAMENTO=${sLancamento}&COD_BAIXA=${sCodBaixa}&COD_USUARIO=${getCookie('cod_usuario')}`
			);

			if (!response) {
				return;
			}

			if (response.status != 200) {
				const jsonStr = await response.json();
				msgErro(jsonStr.mensagem);
				return;
			}

			toastr.success(
				'Cancelamento de envio efetuado com sucesso!',
				'Confirmação', {
				toastClass: 'alert',
				iconClasses: {
					error: 'alert-error',
					info: 'alert-info',
					success: 'alert-success',
					warning: 'alert-warning'
				},
				positionClass: "toast-top-center",
				progressBar: true,
				timeOut: 3000,
				fadeOut: 1000,
				onHidden() {
					$('#btnConsultarEnviadas').trigger('click')
				}
			},
			).css({
				"margin-top": "20%",
				width: "500px",
				"max-width": "500px"
			});

		} catch (error) {
			console.error(error);
		} finally {
			$.LoadingOverlay('hide')
		}
	}

	async function adicionaRegistroGrid() {
		const ehbarralog = await retornaBarraLogLida($('#txtBarra').val()) == "barra_log";

		if (!ehbarralog && bApenasBarraLog) {
			msgAlerta('Barra log não encontrada, impossível continuar!');
			return;
		}

		if (ehbarralog) {
			$('#txtBarra').val(await extraiBarra28($('#txtBarra').val()));
		}

		const barra = $("#txtBarra").val();
		const codigo = pegaChave("#txtProduto");
		const deposito = pegaChave("#txtDepositoSaida");
		const estornaQuantidade = $('#btnMenosOuMais').attr('data-estorno') === 'true';

		if (!deposito) {
			msgAlerta('É necessário informar um depósito, verifique!');
			return;
		}

		const campos = ['BARRA', 'BARRACLI', 'BARRA28'];
		let dadosSelect = null;
		let retornoSelect = []

		for (const campo of campos) {
			dadosSelect = retornaSQL(campo, estornaQuantidade, barra);
			retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
			if (retornoSelect.length > 0) break;
		}

		if (retornoSelect.length === 0) {
			msgAlerta("Produto não encontrado ou sem estoque disponível, verifique");
			return;
		}

		const table = $("#tabelaEnvio").DataTable();
		limpaCampos();

		for (const item of retornoSelect) {
			const dados = {
				CODIGO: item.CODIGO,
				DESCRICAO: item.DESCRICAO,
				COR: item.COR,
				DESC_COR: item.DESC_COR,
				TAM: item.TAM,
				TIPO: item.TIPO,
				BARRA28: item.BARRA28,
				ESTOQUE: item.QUANTIDADE,
				QTDE: 0,
				DT_FAB: item.DT_FAB,
				BARRA: item.BARRA,
				DT_VAL: item.DT_VAL,
				LOTE: item.LOTE,
				QUANTIDADE: '',
				PEDIDO: ''
			};

			if (dados.ESTOQUE === 0 && !estornaQuantidade) {
				msgAlerta("Quantidade em estoque insuficiente, verifique");
				continue;
			}

			const indexItem = table.data().toArray().findIndex(
				row => $(row.CODIGO).find('button').first().html().trim() === dados.CODIGO && row.COR === dados.COR && row.TIPO === dados.TIPO && dados.BARRA === row.BARRA
			);

			if (indexItem === -1) {
				if (estornaQuantidade && codigo === '') {
					msgAlerta('Nenhum item para estornar!');
					continue;
				}
				dados.QTDE = 1;
				dados.QUANTIDADE = `<input type="text" class="input-default focus form-control text-right txtQtdeIt" value="${dados.QTDE}">`;
				dados.CODIGO = adicionaBotoes(dados.CODIGO)
				table.row.add(dados).draw(false);
				table.rows().nodes().to$().last().click();
			} else {
				const rowData = table.row(indexItem).data();
				let newQtde = estornaQuantidade ? rowData.QTDE - 1 : rowData.QTDE + 1;

				if (newQtde > dados.ESTOQUE) {
					msgAlerta("Quantidade excedida, verifique");
					continue;
				}

				if (newQtde < 0) {
					msgAlerta("Quantidade não pode ser negativa, verifique");
					continue;
				}

				if (newQtde === 0) {
					table.row(indexItem).remove().draw(false);
				} else {
					rowData.QTDE = newQtde;
					rowData.QUANTIDADE = `<input type="text" class="input-default focus form-control text-right txtQtdeIt" value="${rowData.QTDE}">`;
					table.row(indexItem).data(rowData).draw(false);
				}
			}
		}

		table.columns.adjust().draw(false);
		calculaQuantidadeTotalNovoItem();

		$('#tabelaEnvio').off('blur', '.txtQtdeIt').on('blur', '.txtQtdeIt', function () {
			try {
				const input = $(this);
				const index = input.closest('tr').index();
				const rowData = table.row(index).data();
				let newQtde = parseFloat(input.val()) || 0;

				if (newQtde > rowData.ESTOQUE) {
					msgAlerta('Quantidade excedida, verifique!');
					input.val(rowData.ESTOQUE);
					newQtde = rowData.ESTOQUE;
				} else if (newQtde < 0) {
					msgAlerta('Quantidade não pode ser menor que 0, verifique!');
					input.val(0);
					newQtde = 0;
				}

				if (newQtde === 0) {
					table.row(index).remove().draw(false);
				} else {
					rowData.QTDE = newQtde;
					rowData.QUANTIDADE = `<input type="text" class="input-default focus form-control text-right txtQtdeIt" value="${rowData.QTDE}">`;
					table.row(index).data(rowData).draw(false);
				}
			} finally {
				calculaQuantidadeTotalNovoItem();
				atualizaQuantidade()
			}
		});
	}

	function adicionaBotoes(data, row) {
		var retorno = '<div style="text-align:start;"> ' +
			'    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
			'      ' + data + ' ' +
			'    </button> ' +
			'    <div class="dropdown-menu"> ' +
			'    <button class="dropdown-item btn-excluir" type="button" title="Excluir" id="btn-excluir">Excluir</button>     ' +
			'</div>';
		return retorno;
	};


	$('#tabelaEnvio').on('click', '.btn-excluir', async function () {
		$('#tabelaEnvio').DataTable().row($(this).parents('tr')).remove().draw(false);
	})

	$("#txtDocumento").on("blur", async function () {
		try {
			$.LoadingOverlay("show");
			if ($(this).val() == "") {
				const docto = await RetornaProximo("NUM_DOCTO", "PA_MOV", "NUM_DOCTO", "6");
				insereValor("#txtDocumento", docto);
				$(this).attr("disabled", $(this).val() != "");
			}
		} finally {
			$.LoadingOverlay("hide");
		}
	});

	$("#tabRecebimento").on("click", async function () {
		try {
			$.LoadingOverlay("show");
			await buscaDocumentoEntrada()
		} finally {
			$.LoadingOverlay("hide");
		}
	});

	async function buscaDocumentoEntrada() {
		if ($('#txtDocumentoEntrada').val() == "") {
			const docto = await RetornaProximo("NUM_DOCTO", "PA_MOV", "NUM_DOCTO", "6");
			insereValor("#txtDocumentoEntrada", docto);
			$('#txtDocumentoEntrada').attr("disabled", $('#txtDocumentoEntrada').val() != "");
		}
	}

	$("#txtBarra").on("blur", async function () {
		if ($(this).val() !== "") {
			await adicionaRegistroGrid();
			limpaCampos();
			$("#txtBarra").focus();
		}
		atualizaQuantidade()
	});

	$("#btnConsultar").on("click", async function () {
		if (pegaChave('#txtProduto') == '') {
			msgAlerta('Necessário informar um produto para adicionar ao grid.');
			return;
		}

		await adicionaRegistroGrid();
		$("#txtProduto").focus();
		atualizaQuantidade()
	});

	rotinaSaidaDeposito();
	rotinaSaidaProduto();
	rotinaSaidaCor();
	rotinaSaidaTamanho();

	function rotinaSaidaProduto() {
		$("#txtProduto").on("blur", async function () {
			$("#txtCor").autocompleta(
				1,
				`JSON={"tabela": "CADCOR", "camposSelect": ["COR CHAVE", "DESCRICAO DESCRICAO"], "where": ["COR IN (SELECT DISTINCT COR FROM [PA_ITEN] WHERE CODIGO='${pegaChave(
					"#txtProduto"
				)}' AND DEPOSITO='${pegaChave('#txtDepositoSaida')}' AND QUANTIDADE > 0)"]}`,
				[],
				[],
				[],
			);

			$("#btnCor").pesquisa_array(
				["#txtCor"],
				["CHAVE"],
				["DESCRICAO"],
				`/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "CADCOR", "camposSelect": ["COR CHAVE", "DESCRICAO DESCRICAO"], "where": ["COR IN (SELECT DISTINCT COR FROM [PA_ITEN] WHERE CODIGO='${pegaChave(
					"#txtProduto"
				)}' AND DEPOSITO='${pegaChave('#txtDepositoSaida')}' AND QUANTIDADE > 0)"]}`,
				"Pesquisa Cor",
				"cadcor",
			);

			rotinaSaidaCor();
		});
	}

	function rotinaSaidaDeposito() {
		setTimeout(() => {
			const sDeposito = pegaChave("#txtDepositoSaida");

			$("#txtProduto").autocompleta(
				1,
				`JSON={"tabela": "PRODUTO", "camposSelect": ["PRODUTO.CODIGO CHAVE", "PRODUTO.DESCRICAO DESCRICAO"], "leftJoin": [{"tabela":"PA_ITEN", "condicao": "PA_ITEN.CODIGO = PRODUTO.CODIGO"}], "where": ["PA_ITEN.DEPOSITO = '${sDeposito}' AND pa_iten.quantidade > 0"], "groupBy": ["PRODUTO.CODIGO", "PRODUTO.DESCRICAO"]}`,
				[],
				[],
				[],
			);

			$('#btnProduto').pesquisa_serverside(['#txtProduto'], ['PRODUTO.CODIGO'], ['PRODUTO.DESCRICAO'], `{"tabela": "PRODUTO", "camposSelect": ["PRODUTO.CODIGO", "PRODUTO.DESCRICAO", "PRODUTO.CODIGO2"], "leftJoin": [{"tabela":"PA_ITEN", "condicao": "PA_ITEN.CODIGO = PRODUTO.CODIGO"}], "where": ["PA_ITEN.DEPOSITO = '${sDeposito}' AND pa_iten.quantidade > 0"], "groupBy": ["PRODUTO.CODIGO", "PRODUTO.CODIGO2", "PRODUTO.DESCRICAO"]}`, 'Pesquisa de Produto');

			rotinaSaidaProduto()
		}, 500)
	}

	function rotinaSaidaCor() {
		$("#txtCor").on("blur", function () {
			const sCodigo = pegaChave("#txtProduto");
			const sCor = pegaChave("#txtCor");
			const sDeposito = pegaChave("#txtDepositoSaida");

			$("#txtTamanho").autocompleta(
				1,
				`JSON={"tabela": "PA_ITEN", "camposSelect": ["TAM CHAVE", "TAM DESCRICAO"], "where": ["CODIGO = '${sCodigo}' AND COR = '${sCor}' AND DEPOSITO = '${sDeposito}' AND QUANTIDADE > 0"]}`,
				[],
				[],
				[],
			);
			$("#btnTamanho").pesquisa_array(
				["#txtTamanho"],
				["CHAVE"],
				["DESCRICAO"],
				`/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "PA_ITEN", "camposSelect": ["TAM CHAVE", "TAM DESCRICAO"], "where": ["CODIGO = '${sCodigo}' AND COR = '${sCor}' AND DEPOSITO = '${sDeposito}' AND QUANTIDADE > 0"]}`,
				"Pesquisa Tamanho",
				"PA_ITEN",
			);
			rotinaSaidaTamanho()
		});

	}

	function rotinaSaidaTamanho() {
		$("#txtTamanho").on("blur", function () {
			const sCodigo = pegaChave("#txtProduto");
			const sCor = pegaChave("#txtCor");
			const sDeposito = pegaChave("#txtDepositoSaida");
			const sTamanho = pegaChave('#txtTamanho');

			$("#txtQualidade").autocompleta(
				1,
				`JSON={"tabela": "PA_ITEN", "camposSelect": ["TIPO CHAVE", "TIPO DESCRICAO"], "where": ["CODIGO = '${sCodigo}' AND COR = '${sCor}' AND DEPOSITO = '${sDeposito}' AND TAM='${sTamanho}'"], "groupBy": ["TIPO"]}`,
				[],
				[],
				[],
			);
			$("#btnQualidade").pesquisa_array(
				["#txtQualidade"],
				["CHAVE"],
				["DESCRICAO"],
				`/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "PA_ITEN", "camposSelect": ["TIPO CHAVE", "TIPO DESCRICAO"], "where": ["CODIGO = '${sCodigo}' AND COR = '${sCor}' AND DEPOSITO = '${sDeposito}' AND TAM='${sTamanho}'"], "groupBy": ["TIPO"]}`,
				"Pesquisa de Qualidade",
				"PA_ITEN",
			)
		});
	}

	$("#btnConsultar").on("keypress", async function () {
		$("#btnConsultar").trigger("click");
	});

	function limpaCampos() {
		$("#txtProduto").val("");
		$("#txtCor").val("");
		$("#txtLote").val("");
		$("#txtQualidade").val("");
		$("#txtBarra").val("");
		$("#txtTamanho").val("");
	}

	function VerificaQuantidadeBipada() {
		let QuantidadeBipada = 0;
		const tabelaItens = $("#tabelaItens").DataTable().data().toArray();
		for (let item of tabelaItens) {
			QuantidadeBipada = parseFloat(QuantidadeBipada) + parseFloat(item.QTDE_CONFERIDA)
		}

		$("#txtQuantidadeBipada").val(TruncaDecimaisNova(2, QuantidadeBipada));
	}

	function atualizaVolumesConferidos() {
		const dados = $('#tabelaItens').DataTable().data().toArray();
		const volumes = dados.reduce((acc, item) => {
			return acc + (item.QTDE_CONFERIDA > 0 ? 1 : 0);
		}, 0);
		$('#txtVolumesConferidos').val(volumes);
	}

	function VerificaQuantidadePendente() {
		let QuantidadePendente = 0
		const tabelaItens = $("#tabelaItens").DataTable().data();
		for (let i = 0; i < tabelaItens.length; i++) {
			QuantidadePendente = parseFloat(QuantidadePendente) + tabelaItens[i].QTDE_PENDENTE;
		}
		$("#txtQuantidadePendente").val(TruncaDecimaisNova(2, QuantidadePendente));
	}

	function atualizaVolumesPendentes() {
		const dados = $('#tabelaItens').DataTable().data().toArray();
		const VolumesPendentes = dados.reduce((acc, item) => {
			return acc + (item.QTDE_CONFERIDA === 0 ? 1 : 0);
		}, 0);

		$("#txtVolumesPendentes").val(VolumesPendentes);
	}

	$("#txtBarra").on("keydown", async function (event) {
		if (event.key == "Enter") {
			$("#txtBarra").trigger("blur");
			$("#txtBarra").focus();
		}
	});

	$('#btnGravarTransferencia').on('click', async function () {
		try {
			if (!$('#txtEmpresaSaida').val()) {
				throw new Error('Empresa de destino não informada. É necessário a empresa que irá receber a nota, verifique!')
			}
			if ($('#tabelaEnvio').DataTable().data().length == 0) {
				throw new Error('Nenhum item para ser transferido, verifique!')
			}
			if (!$('#txtTipoMovSaida').val()) {
				throw new Error('Necessário inserir um tipo de movimentação!')
			}
			if (utilizaDepositoTransitorio == '1') {
				if (!$('#txtDepositoTransitorio').val()) {
					throw new Error('Necessário inserir um depósito transitório!')
				}
			}
			$('#btnGravarTransferencia').prop('disabled', true);
			$.LoadingOverlay('show');

			await gravarMovimentacao();

		} catch (error) {
			msgAlerta(error.message || 'Não foi possível gravar a movimentação!')
		} finally {
			$('#btnGravarTransferencia').prop('disabled', false);
			$.LoadingOverlay('hide');
		}
	});

	function retornaTabelaSaida() {
		const tabela = $('#tabelaEnvio').DataTable().rows().data().toArray()

		const objetoMovimentacao = tabela.map((item, i) => {
			return {
				DOCTO: $('#txtDocumento').val(),
				NUM_DOCTO: $('#txtDocumento').val(),
				CODIGO: $(item.CODIGO).find('button').length ? $(item.CODIGO).find('button').first().html().trim() : item.CODIGO,
				COR: item.COR,
				TAMANHO: item.TAM,
				QUALIDADE: item.TIPO,
				QUANTIDADE: $('.txtQtdeIt').eq(i).val() ? $('.txtQtdeIt').eq(i).val() : item.QUANTIDADE,
				DEPOSITO: pegaChave('#txtDepositoSaida'),
				CODBAIXA: pegaChave('#txtTipoMovSaida'),
				DT_FAB: !item.DT_FAB ? '1899-01-01' : item.DT_FAB,
				BARRA: item.BARRA,
				BARRA28: item.BARRA28,
				DT_VAL: !item.DT_VAL ? '1899-01-01' : item.DT_VAL,
				PEDIDO: pegaChave('#txtPedido')
			}
		})

		return objetoMovimentacao;
	}

	async function gravarMovimentacao(nfe = false) {
		try {
			const objeto = retornaTabelaSaida();
			const body = {
				produtos: objeto,
				DEPOSITO_TRANSITORIO: pegaChave('#txtDepositoTransitorio')
			}
			const response = await requisicao('POST',
				`/sisplan/estoque/v1/transferenciamercadorias_produto?`,
				`TIPO=SAIDA&EMP_DESTINO=${pegaChave('#txtEmpresaSaida')}`,
				JSON.stringify(body)
			);

			if (response.status != 200) {
				const jsonStr = await response.json();

				toastr.error(
					jsonStr.mensagem,
					'Confirmação', {
					toastClass: 'alert',
					iconClasses: {
						error: 'alert-error',
						info: 'alert-info',
						success: 'alert-success',
						warning: 'alert-warning'
					},
					positionClass: "toast-top-center",
					progressBar: true,
					timeOut: 3000,
					fadeOut: 1000,
					onHidden() {
						if (nfe) {
							faturaNFe()
						}
						// window.location.href = `${BASE_URI}/mercadorias_produto`;
					}
				},
				).css({
					"margin-top": "20%",
					width: "500px",
					"max-width": "500px"
				});

				return
			}

			toastr.success(
				'Saída de mercadoria efetuada com sucesso!',
				'Confirmação', {
				toastClass: 'alert',
				iconClasses: {
					error: 'alert-error',
					info: 'alert-info',
					success: 'alert-success',
					warning: 'alert-warning'
				},
				positionClass: "toast-top-center",
				progressBar: true,
				timeOut: 3000,
				fadeOut: 1000,
				onHidden() {
					if (nfe) {
						faturaNFe()
					}
					// window.location.href = `${BASE_URI}/mercadorias_produto`;
				}
			},
			).css({
				"margin-top": "20%",
				width: "500px",
				"max-width": "500px"
			});
			await imprimirTransferencia($('#txtDocumento').val())

		} catch (error) {
			console.error(error);
			// window.location.href = `${BASE_URI}/mercadorias_produto`;
		}
	}

	function calculaQuantidadeTotalNovoItem() {
		try {
			let quantidadeTotal = 0
			$('.txtQtdeIt').toArray().forEach((e) => {
				quantidadeTotal += parseFloat($(e).val())
			})

			quantidadeTotal = parseFloat(quantidadeTotal)

			if (isNaN(quantidadeTotal)) {
				$('#txtQtdeNovoItem').val(0)
				return
			}

			const quantidadeTotalFormatada = quantidadeTotal.toFixed(6)

			$('#txtQtdeNovoItem').val(quantidadeTotalFormatada)
		} catch (error) {
			console.error(error)
			$('#txtQtdeNovoItem').val(0)
		}
	}

	function retornaLeftJoin() {
		let leftJoin = []
		leftJoin.push({ tabela: "PRODUTO", condicao: "NF_CONF_ENTRA.ID_PRO = PRODUTO.ID" })
		leftJoin.push({ tabela: "CADCOR", condicao: "NF_CONF_ENTRA.ID_COR = CADCOR.ID" })
		leftJoin.push({ tabela: "EMPRESA", alias: "EMPRESA_ORIGEM", condicao: "EMPRESA_ORIGEM.EMP_ID = NF_CONF_ENTRA.EMP_ID_ORIGEM" })
		leftJoin.push({ tabela: "EMPRESA", alias: "EMPRESA_DESTINO", condicao: "EMPRESA_DESTINO.EMP_ID = NF_CONF_ENTRA.EMP_ID" })
		leftJoin.push({ tabela: "DEPOSITO", condicao: "DEPOSITO.ID = NF_CONF_ENTRA.ID_DEP_S" })
		leftJoin.push({ tabela: "DEPOSITO", alias: "DEPOSITO_T", condicao: "DEPOSITO_T.ID = NF_CONF_ENTRA.ID_DEP_T" })
		leftJoin.push({ tabela: "NOTA_ENTRA", condicao: "NOTA_ENTRA.NOTAFISCAL = NF_CONF_ENTRA.NUMERO" })
		return leftJoin
	}


	function retornaInnerJoin() {
		let innerJoin = []
		// if (bObrigaEntradaNota){
		// 	innerJoin.push({ tabela: "NOTA_ENTRA", condicao: "NOTA_ENTRA.NOTAFISCAL = NF_CONF_ENTRA.NUMERO" })
		// }
		return innerJoin
	}

	function retornaCamposSelect() {
		const separador = "' - '"
		let camposSelect = []

		camposSelect.push("'' SEL",
			"NF_CONF_ENTRA.DOCTO_S DOCUMENTO",
			"NF_CONF_ENTRA.USUARIO",
			"MAX(NF_CONF_ENTRA.DT_SAIDA) DATA_HORA",
			"NF_CONF_ENTRA.NUMERO NOTA_FISCAL",
			"NF_CONF_ENTRA.SERIE",
			"COUNT(NF_CONF_ENTRA.DOCTO_S) VOLUMES",
			// `DEPOSITO.CODIGO || ${separador} || DEPOSITO.DESCRICAO DEPOSITO`,

			" CASE " +
			" WHEN NF_CONF_ENTRA.ID_DEP_T IS NOT NULL THEN DEPOSITO_T.CODIGO " +
			" ELSE DEPOSITO.CODIGO" +
			` END || ${separador} || ` +
			" CASE " +
			" WHEN NF_CONF_ENTRA.ID_DEP_T IS NOT NULL THEN DEPOSITO_T.DESCRICAO " +
			" ELSE DEPOSITO.DESCRICAO " +
			" END AS DEPOSITO ",

			`NF_CONF_ENTRA.EMP_ID_ORIGEM || ${separador} || EMPRESA_ORIGEM.EMP_FANTASIA EMP_ENVIO`,
			`NF_CONF_ENTRA.EMP_ID || ${separador}  || EMPRESA_DESTINO.EMP_FANTASIA EMP_RECEB`,
			"SUM(NF_CONF_ENTRA.QTDE) QTDE",
			"SUM(NF_CONF_ENTRA.QTDE_CONFERIDA) QTDE_CONFERIDA",
			"SUM(NF_CONF_ENTRA.QTDE - NF_CONF_ENTRA.QTDE_CONFERIDA - NF_CONF_ENTRA.QTDE_REJEITADA) QTDE_PENDENTE",
			"SUM(NF_CONF_ENTRA.QTDE_REJEITADA) QTDE_REJEITADA",
			"SUM(NF_CONF_ENTRA.QTDE_CANC) QTDE_CANC",
			"CASE " +
			"WHEN SUM(NF_CONF_ENTRA.QTDE) > SUM(NF_CONF_ENTRA.QTDE_CONFERIDA) AND SUM(NF_CONF_ENTRA.QTDE_CONFERIDA) > 0 THEN 'F'" +
			"WHEN SUM(NF_CONF_ENTRA.QTDE) = SUM(NF_CONF_ENTRA.QTDE_CONFERIDA) THEN 'S'" +
			"WHEN SUM(NF_CONF_ENTRA.QTDE_REJEITADA) > 0 AND SUM(NF_CONF_ENTRA.QTDE_CONFERIDA) = 0 THEN 'R'" +
			"ELSE 'P'" +
			"END CONFERIDA",
			// "NF_CONF_ENTRA.CONFERIDA",
			"NF_CONF_ENTRA.IMPRESSO")

		if (bObrigaEntradaNota) {
			camposSelect.push("CASE WHEN NOTA_ENTRA.NOTAFISCAL = NF_CONF_ENTRA.NUMERO THEN 'EXISTE_ENTRADA_NOTA' ELSE 'NAO_EXISTE_ENTRADA_NOTA' END SITUACAO_ENTRADA")
			// camposSelect.push("CASE WHEN EXISTS (SELECT * FROM PRECONF WHERE PRECONF.ID_NOTA_ENTRA = NOTA_ENTRA.ID) THEN 'EXISTE_PRECONF' WHEN NOT EXISTS (SELECT * FROM PRECONF WHERE PRECONF.ID_NOTA_ENTRA = NOTA_ENTRA.ID) THEN 'NAO_EXISTE_PRECONF' END SITUACAO_PRECONF")
		}

		return camposSelect
	}

	function retornaGroupBy() {
		let groupBy = []
		groupBy.push("NF_CONF_ENTRA.DOCTO_S",
			"NF_CONF_ENTRA.NUMERO",
			"NF_CONF_ENTRA.USUARIO",
			"NF_CONF_ENTRA.SERIE",
			"NF_CONF_ENTRA.EMP_ID_ORIGEM",
			"EMPRESA_ORIGEM.EMP_FANTASIA",
			"NF_CONF_ENTRA.EMP_ID",
			"EMPRESA_DESTINO.EMP_FANTASIA",
			"DEPOSITO.CODIGO",
			"DEPOSITO.DESCRICAO",
			// "NF_CONF_ENTRA.CONFERIDA",
			"NF_CONF_ENTRA.IMPRESSO",
			"NF_CONF_ENTRA.ID_DEP_T",
			"DEPOSITO_T.CODIGO",
			"DEPOSITO_T.DESCRICAO",
		)

		if (bObrigaEntradaNota) {
			groupBy.push("NOTA_ENTRA.NOTAFISCAL")
		}

		return groupBy
	}

	await buscaNotas()
	async function buscaNotas(statusConf = '', statusEnvio = '') {
		let sWhere = ''
		let sWhereSubSelect = ''
		let pedido = pegaChave('#txtPedidoConf') ? (await buscaValor('PEDIDO', 'ID', 'NUMERO', pegaChave('#txtPedidoConf'))).ID : ''

		sWhere += ` AND NF_CONF_ENTRA.EMP_ID = ${getCookie('emp_id')}`;
		if (statusConf === 'R') {
			sWhereSubSelect += statusConf ? ` AND QTDE_REJEITADA > 0` : '';
		} else {
			sWhere += statusConf ? ` AND NF_CONF_ENTRA.CONFERIDA = '${statusConf}'` : '';
		}
		sWhere += statusEnvio ? ` AND NF_CONF_ENTRA.IMPRESSO = '${statusEnvio}'` : '';

		if (tipoBanco == 'ORACLE') {
			sWhere += $('#dtDe').val() != '' ? ` AND NF_CONF_ENTRA.DT_SAIDA >= TO_TIMESTAMP('${$('#dtDe').val()} 00:00:00', 'YYYY-MM-DD HH24:MI:SS')` : '';
			sWhere += $('#dtAte').val() != '' ? ` AND NF_CONF_ENTRA.DT_SAIDA <= TO_TIMESTAMP('${$('#dtAte').val()} 23:59:59', 'YYYY-MM-DD HH24:MI:SS')` : '';
		} else {
			sWhere += $('#dtDe').val() != '' ? ` AND NF_CONF_ENTRA.DT_SAIDA >= '${$('#dtDe').val()}T00:00:00Z'` : '';
			sWhere += $('#dtAte').val() != '' ? ` AND NF_CONF_ENTRA.DT_SAIDA <= '${$('#dtAte').val()}T23:59:59Z'` : '';
		}
		sWhere += pegaChave('#txtEmpresaEnvio') ? ` AND NF_CONF_ENTRA.EMP_ID_ORIGEM = '${pegaChave('#txtEmpresaEnvio')}'` : '';

		sWhere += $('#txtDocumentoPesquisaConf').val() ? ` AND NF_CONF_ENTRA.DOCTO_S = '${$('#txtDocumentoPesquisaConf').val()}'` : '';
		sWhere += $('#txtNotaFiscalPesquisaConf').val() ? ` AND NF_CONF_ENTRA.NUMERO = '${$('#txtNotaFiscalPesquisaConf').val()}'` : '';

		sWhere += $('#txtPedidoConf').val() ? ` AND NF_CONF_ENTRA.ID_PED = '${pedido}'` : '';

		let sql = {
			camposSelectSubSelect: ['*'],
			camposSelect: retornaCamposSelect(),
			tabela: "NF_CONF_ENTRA",
			leftJoin: retornaLeftJoin(),
			innerJoin: retornaInnerJoin(),
			groupBy: retornaGroupBy(),
			where: [`1=1 ${sWhere}`],
			whereSubSelect: [`1=1 ${sWhereSubSelect}`],
		};

		const dados = await retornaJsonPesquisaPadrao(JSON.stringify(sql));

		$('#tabelaNotas').DataTable({
			order: [1, 'desc'],
			searching: false,
			ordering: false,
			paging: true,
			info: true,
			destroy: true,
			colReorder: true,
			pageLength: 5,
			lengthChange: false,
			"language": {
				"sEmptyTable": "Nenhum registro encontrado",
				"sInfo": "_TOTAL_ registros",
				"sInfoEmpty": " 0 registros",
				"sInfoFiltered": "(Filtrados de _MAX_ registros)",
				"sInfoPostFix": "",
				"sInfoThousands": ".",
				"sLengthMenu": "_MENU_ resultados",
				"sLoadingRecords": "Carregando...",
				"sProcessing": "Processando...",
				"sZeroRecords": "Nenhum registro encontrado",
				"sSearch": "Pesquisar",
				"oPaginate": {
					"sNext": "Próximo",
					"sPrevious": "Anterior",
					"sFirst": "Primeiro",
					"sLast": "Último"
				},
				"oAria": {
					"sSortAscending": ": Ordenar colunas de forma ascendente",
					"sSortDescending": ": Ordenar colunas de forma descendente"
				}
			},
			"autoWidth": true,
			"data": dados,
			"columns": columnsNotas,
			"columnDefs": [
				{
					//title: Nota ainda não teve o preço de custo alterado
					targets: [0], render: function (_data, _type, _row, meta) {
						let bDisabled = _row.IMPRESSO === 'C' || (bObrigaEntradaNota && _row.NOTA_FISCAL !== '') && _row.SITUACAO_ENTRADA === 'NAO_EXISTE_ENTRADA_NOTA' && _row.CONFERIDA === 'P' || _row.CONFERIDA === 'R' || _row.CONFERIDA === 'S' ? 'disabled' : ''
						let bAdicionaTitleAndIcon = (bObrigaEntradaNota && _row.NOTA_FISCAL !== '') && _row.SITUACAO_ENTRADA === 'NAO_EXISTE_ENTRADA_NOTA' && _row.CONFERIDA === 'P'
						return `<div title="${bAdicionaTitleAndIcon ? 'Só pode ser conferido após a entrada da nota fiscal.' : ''}" class="icheck-primary d-inline">
											<input type="checkbox" ${bDisabled} id="check_col_${meta.row}_row_${meta.col}" class="checkSel"> 
											<label for="check_col_${meta.row}_row_${meta.col}">${bAdicionaTitleAndIcon ? '<i class="fas fa-question pt-1" style="color: yellow"></i>' : ''}</label>
										</div>`;
					},
				},
				{
					render(data, type, row) {
						return retornaBotaoOpcoesNotas(row.DOCUMENTO);
					},
					targets: 1,
				},
				{
					type: 'date-br',
					targets: [3],
					render: function (data) {
						if (data != undefined && data != '') {
							x = data.slice(0, 10).split('-');
							hora = data.split(' ')[1]
							if (x[2]) {
								return `${x[2]}/${x[1]}/${x[0]}`
							} else {
								return `${x} ${hora} `;
							}
						} else {
							return ''
						}
					}
				},
				{
					targets: [10, 11, 12, 13, 14],
					className: "text-right"
				}
			],
			rowCallback: function (row, data) {
				if ($('td:eq(15)', row).text() === 'C') {
					$('td:eq(15)', row).text('Cancelado')
					$('td:eq(15)', row).css('color', 'red');
				}
				if ($('td:eq(15)', row).text() === 'S') {
					$('td:eq(15)', row).text('Enviado')
				}
				if ($(`td:eq(16)`, row).text() === 'F') {
					$(`td:eq(16)`, row).text('Parcial')
				}
				if ($(`td:eq(16)`, row).text() === 'S') {
					$(`td:eq(16)`, row).text('Conferida')
				}
				if ($(`td:eq(16)`, row).text() === 'P') {
					$(`td:eq(16)`, row).text('Pendente')
				}
				if ($(`td:eq(16)`, row).text() === 'R') {
					$(`td:eq(16)`, row).text('Rejeitada')
				}

				if (data.CONFERIDA === 'R') {
					$(row).css('color', 'red');
					$(row).css('font-weigth', 'bold');
				} else if (data.CONFERIDA === 'F') {
					$(row).css('color', 'var(--linhaAmarela)');
					$(row).css('font-weigth', 'bold');
				} else if (data.CONFERIDA === 'S') {
					$(row).css('color', 'green');
					$(row).css('font-weigth', 'bold');
				}
			}
		});

		let registrosSelecionados = [];
		$('#tabelaNotas').DataTable().on('click', ".checkSel", async function () {
			const dados = $('#tabelaNotas').DataTable().rows($(this).closest('tr')).data().toArray();
			if (!$(this).prop('checked')) {
				registrosSelecionados = registrosSelecionados.filter(cod => (cod[1] != dados[0][1]));
				$($(this).closest('tr')).removeClass('selected');
			} else {
				$($(this).closest('tr')).addClass('selected');
			}
		});
	}

	$('#btnConsultarEnviadas').on('click', async function () {
		const statusEnvio = $('#txtStatusEnvioE').val()
		const statusConf = $('#txtStatusConfE').val()
		await buscaNotasEnviadas(statusConf, statusEnvio)
	})

	$('#btnConsultarEnviadas').trigger('click')
	async function buscaNotasEnviadas(statusConf = '', statusEnvio = '') {
		if ($.fn.DataTable.isDataTable('#tabelaNotasEnviadas')) {
			$('#tabelaNotasEnviadas').DataTable().destroy();
			$('#tabelaNotasEnviadas').empty();
		};

		let sWhere = ''

		sWhere += ` AND NF_CONF_ENTRA.EMP_ID_ORIGEM = ${getCookie('emp_id')}`;
		sWhere += $('#dtEnvioDe').val() != '' ? ` AND NF_CONF_ENTRA.DT_SAIDA >= TO_TIMESTAMP('${$('#dtEnvioDe').val()} 00:00:00', 'YYYY-MM-DD HH24:MI:SS')` : '';
		sWhere += $('#dtEnvioAte').val() != '' ? ` AND NF_CONF_ENTRA.DT_SAIDA <= TO_TIMESTAMP('${$('#dtEnvioAte').val()} 23:59:59', 'YYYY-MM-DD HH24:MI:SS')` : '';
		sWhere += $('#txtDocumentoPesquisa').val() ? ` AND NF_CONF_ENTRA.DOCTO_S = '${$('#txtDocumentoPesquisa').val()}'` : '';
		sWhere += $('#txtNotaFiscalPesquisa').val() ? ` AND NF_CONF_ENTRA.NUMERO = '${$('#txtNotaFiscalPesquisa').val()}'` : '';
		sWhere += pegaChave('#txtEmpresaRecebimento') ? ` AND NF_CONF_ENTRA.EMP_ID = '${pegaChave('#txtEmpresaRecebimento')}'` : '';

		if (statusConf === 'R') {
			sWhere += statusConf ? ` AND NF_CONF_ENTRA.QTDE_REJEITADA > 0` : '';
		} else {
			sWhere += statusConf ? ` AND NF_CONF_ENTRA.CONFERIDA = '${statusConf}'` : '';
		}
		sWhere += statusEnvio ? ` AND NF_CONF_ENTRA.IMPRESSO = '${statusEnvio}'` : '';

		const separador = "' - '"
		const sql = {
			camposSelect: [
				"NF_CONF_ENTRA.DOCTO_S DOCUMENTO",
				"NF_CONF_ENTRA.USUARIO",
				"MAX(NF_CONF_ENTRA.DT_SAIDA) DATA_HORA",
				"NF_CONF_ENTRA.NUMERO NOTA_FISCAL",
				"COUNT(NF_CONF_ENTRA.DOCTO_S) VOLUMES",
				"NF_CONF_ENTRA.SERIE",
				`NF_CONF_ENTRA.EMP_ID || ${separador}  || EMPRESA_DESTINO.EMP_FANTASIA EMP_RECEB`,
				"SUM(NF_CONF_ENTRA.QTDE) QTDE",
				"SUM(NF_CONF_ENTRA.QTDE_CONFERIDA) QTDE_CONFERIDA",
				"SUM(NF_CONF_ENTRA.QTDE - NF_CONF_ENTRA.QTDE_CONFERIDA) QTDE_PENDENTE",
				"SUM(NF_CONF_ENTRA.QTDE_REJEITADA) QTDE_REJEITADA",
				"SUM(NF_CONF_ENTRA.QTDE_CANC) QTDE_CANC",
				"NF_CONF_ENTRA.CONFERIDA",
				"PA_MOV.LANCAMENTO",
				"NF_CONF_ENTRA.IMPRESSO",
			],
			tabela: "NF_CONF_ENTRA",
			leftJoin: [
				{
					tabela: "PRODUTO",
					condicao: "NF_CONF_ENTRA.ID_PRO = PRODUTO.ID",
				},
				{
					tabela: "CADCOR",

					condicao: "NF_CONF_ENTRA.ID_COR = CADCOR.ID",
				},
				{
					tabela: "PA_MOV",
					condicao: "PA_MOV.CODIGO = PRODUTO.CODIGO AND PA_MOV.COR = CADCOR.COR AND PA_MOV.TAMANHO = NF_CONF_ENTRA.TAM AND NF_CONF_ENTRA.QUALIDADE = PA_MOV.TIPO AND NF_CONF_ENTRA.DOCTO_S = PA_MOV.NUM_DOCTO AND PA_MOV.OPERACAO = 'S'",
				},
				{
					tabela: "EMPRESA",
					alias: "EMPRESA_DESTINO",
					condicao: "EMPRESA_DESTINO.EMP_ID = NF_CONF_ENTRA.EMP_ID",
				},
			],
			groupBy: [
				"NF_CONF_ENTRA.DOCTO_S",
				"NF_CONF_ENTRA.NUMERO",
				"NF_CONF_ENTRA.USUARIO",
				"NF_CONF_ENTRA.SERIE",
				"NF_CONF_ENTRA.EMP_ID",
				"EMPRESA_DESTINO.EMP_FANTASIA",
				"NF_CONF_ENTRA.EMP_ID_ORIGEM",
				"NF_CONF_ENTRA.CONFERIDA",
				"PA_MOV.LANCAMENTO",
				"NF_CONF_ENTRA.IMPRESSO",
			],
			where: [`1=1 ${sWhere}`],
		};

		const dados = await retornaJsonPesquisaPadrao(JSON.stringify(sql));

		$('#tabelaNotasEnviadas').DataTable({
			order: [1, 'desc'],
			searching: false,
			ordering: false,
			paging: true,
			info: true,
			destroy: true,
			colReorder: true,
			pageLength: 5,
			lengthChange: false,
			"language": {
				"sEmptyTable": "Nenhum registro encontrado",
				"sInfo": "_TOTAL_ registros",
				"sInfoEmpty": " 0 registros",
				"sInfoFiltered": "(Filtrados de _MAX_ registros)",
				"sInfoPostFix": "",
				"sInfoThousands": ".",
				"sLengthMenu": "_MENU_ resultados",
				"sLoadingRecords": "Carregando...",
				"sProcessing": "Processando...",
				"sZeroRecords": "Nenhum registro encontrado",
				"sSearch": "Pesquisar",
				"oPaginate": {
					"sNext": "Próximo",
					"sPrevious": "Anterior",
					"sFirst": "Primeiro",
					"sLast": "Último"
				},
				"oAria": {
					"sSortAscending": ": Ordenar colunas de forma ascendente",
					"sSortDescending": ": Ordenar colunas de forma descendente"
				}
			},
			"autoWidth": true,
			"data": dados,
			"columns": columnsNotasEnviadas,
			"columnDefs": [
				{
					visible: false,
					targets: 12
				},
				{
					type: 'date-br',
					targets: [2],
					render: function (data) {
						if (data != undefined && data != '') {
							x = data.slice(0, 10).split('-');
							hora = data.split(' ')[1]
							if (x[2]) {
								return `${x[2]}/${x[1]}/${x[0]}`
							} else {
								return `${x} ${hora} `;
							}
						} else {
							return ''
						}
					}
				},
				{
					render(data, type, row) {
						return retornaBotaoOpcoesEnviadas(row.DOCUMENTO);
					},
					targets: 0,
				},
				{
					targets: [7, 8, 9, 10],
					className: "text-right"
				}
			],
			rowCallback: function (row, data) {
				if ($('td:eq(11)', row).text() === 'F') {
					$('td:eq(11)', row).text('Parcial')
				}
				if ($('td:eq(11)', row).text() === 'S') {
					$('td:eq(11)', row).text('Conferida')
				}
				if ($('td:eq(11)', row).text() === 'P') {
					$('td:eq(11)', row).text('Pendente')
				}
				if ($('td:eq(11)', row).text() === 'R') {
					$('td:eq(11)', row).text('Rejeitada')
				}
				if ($('td:eq(12)', row).text() !== 'C') {
					$('td:eq(12)', row).text('Enviado')
				}
				if ($('td:eq(12)', row).text() === 'C') {
					$('td:eq(12)', row).text('Cancelado')
					$('td:eq(12)', row).css('color', 'red');
				}
				if (data.CONFERIDA === 'R') {
					$(row).css('color', 'red');
				} else if (data.CONFERIDA === 'F') {
					$(row).css('color', 'var(--linhaAmarela)');
				} else if (data.CONFERIDA === 'S') {
					$(row).css('color', 'green');
				}
			}
		});
	}

	function retornaSQL(sCampo = 'BARRA', estorno = false, sBarra = '') {
		const codigo = pegaChave("#txtProduto");
		const deposito = pegaChave("#txtDepositoSaida");
		const cor = pegaChave("#txtCor");
		const tam = $('#txtBarra').val().trim() != '' ? $('#txtBarra').val().trim() : pegaChave("#txtTamanho").trim() != '' ? pegaChave("#txtTamanho").trim() : '';
		const qual = pegaChave("#txtQualidade");
		let having = ''

		sBarra = sBarra.replaceAll('+', '[SOMA]');

		let sWhere = '';
		if (sBarra != '') {
			sWhere += ` AND PA_ITEN.${sCampo} = '${sBarra}'`
		} else {
			sWhere += codigo ? ` AND PA_ITEN.CODIGO = '${codigo}'` : ''
			sWhere += cor ? ` AND PA_ITEN.COR = '${cor}'` : ''
			sWhere += tam ? ` AND PA_ITEN.TAM = '${tam}'` : ''
			sWhere += qual ? ` AND PA_ITEN.TIPO = '${qual}'` : ''
		}
		sWhere += deposito ? ` AND PA_ITEN.DEPOSITO = '${deposito}'` : ''

		if (!estorno) {
			having = "SUM(PA_ITEN.QUANTIDADE) > 0"
		}

		return {
			camposSelect: [
				"PA_ITEN.CODIGO",
				"PRODUTO.DESCRICAO",
				"PA_ITEN.COR",
				"PA_ITEN.TAM",
				"CADCOR.DESCRICAO DESC_COR",
				"PA_ITEN.TIPO",
				"SUM(PA_ITEN.QUANTIDADE) QUANTIDADE",
				"PRODUTO.UNIDADE",
				"PA_ITEN.DT_FAB",
				"PA_ITEN.BARRA",
				"PA_ITEN.BARRA28",
				"PA_ITEN.LOTE",
				"PA_ITEN.DT_VAL",
			],
			tabela: "PA_ITEN",
			leftJoin: [
				{
					tabela: "PRODUTO",
					condicao: "PRODUTO.CODIGO = PA_ITEN.CODIGO",
				},
				{
					tabela: "CADCOR",
					condicao: "CADCOR.COR = PA_ITEN.COR",
				},
			],
			where: [`1=1 ${sWhere}`],
			groupBy: [
				"PA_ITEN.CODIGO",
				"PRODUTO.DESCRICAO",
				"PA_ITEN.COR",
				"PA_ITEN.TAM",
				"CADCOR.DESCRICAO",
				"PA_ITEN.TIPO",
				"PRODUTO.UNIDADE",
				"PA_ITEN.DT_FAB",
				"PA_ITEN.BARRA",
				"PA_ITEN.BARRA28",
				"PA_ITEN.LOTE",
				"PA_ITEN.DT_VAL",
			],

			having: [having],
		};
	}

	$('#btnMenosOuMais').on('click', function () {
		const estaComoEstorno = $('#btnMenosOuMais>i.fa-minus').length > 0;
		$('#labelBarras').html(estaComoEstorno ? 'Barra' : 'Barra Estorno');
		$('#txtBarra').attr('placeholder', estaComoEstorno ? 'Barra' : 'Barra Estorno');
		$('#txtBarra').focus();
		$('#btnMenosOuMais').attr('data-estorno', !estaComoEstorno);
		if (estaComoEstorno) {
			$('#btnMenosOuMais>i.fa-minus').removeClass('fa-minus').addClass('fa-plus');
		} else {
			$('#btnMenosOuMais>i.fa-plus').removeClass('fa-plus').addClass('fa-minus');
		}
	});

	$('#check_todos').on('change', function () {
		$('.campoSel').prop('checked', $('#check_todos').prop('checked'));
		if ($('#check_todos').prop('checked')) {
			$('.campoSel').addClass('selecionado');
		} else {
			$('.campoSel').removeClass('selecionado');
		}
	});

	async function conferirItens() {
		try {
			if (!!$('#btnGravarConferencia').attr('disabled')) {
				$('#btnGravarConferencia').attr('disabled', false)
			}
			// if ($.fn.DataTable.isDataTable('#tabelaItens')) {
			// 	$('#tabelaItens').DataTable().destroy();
			// 	$('#tabelaItens').empty();
			// };

			let registrosSelecionados = [];

			$('#tabelaNotas').DataTable().rows('.selected').every(function () {
				const dadosLinha = this.data();
				registrosSelecionados.push(dadosLinha.DOCUMENTO);
			});

			if (registrosSelecionados.length == 0) {
				throw new Error('Nenhum documento selecionado para conferência, verifique!')
			}
			const numeros = await formataListas(registrosSelecionados.toString());

			let sWhere = ''
			sWhere += ` AND NF_CONF_ENTRA.QTDE_CONFERIDA <> NF_CONF_ENTRA.QTDE`;
			sWhere += ` AND NF_CONF_ENTRA.DOCTO_S IN (${numeros})`

			const separador = "' - '"

			const sql = {
				camposSelect: [
					`PRODUTO.CODIGO || ${separador} || PRODUTO.DESCRICAO CODIGO`,
					`PRODUTO.CODIGO2`,
					`CADCOR.COR || ${separador} || CADCOR.DESCRICAO COR`,
					"NF_CONF_ENTRA.TAM TAMANHO",
					"NF_CONF_ENTRA.QUALIDADE",
					"NF_CONF_ENTRA.LOTE",
					"NF_CONF_ENTRA.BARRA",
					"NF_CONF_ENTRA.QTDE",
					"NF_CONF_ENTRA.QTDE_CONFERIDA",
					"NF_CONF_ENTRA.NUMERO NUMERO",
					"NF_CONF_ENTRA.DOCTO_S DOCUMENTO",
					"'' TIPO_CONF",
					"NF_CONF_ENTRA.DT_FAB",
					"NF_CONF_ENTRA.OBS",
					"NF_CONF_ENTRA.DT_VAL",
					"NF_CONF_ENTRA.VALOR CUSTO",
					" (SELECT PA_ITEN.BARRA28" +
					" FROM [PA_ITEN] PA_ITEN" +
					" INNER JOIN [PRODUTO] PRODUTO ON PRODUTO.ID = NF_CONF_ENTRA.ID_PRO AND PRODUTO.CODIGO = PA_ITEN.CODIGO" +
					" INNER JOIN [CADCOR] CADCOR ON CADCOR.ID = NF_CONF_ENTRA.ID_COR AND CADCOR.COR = PA_ITEN.COR" +
					" WHERE PA_ITEN.TAM = NF_CONF_ENTRA.TAM" +
					" LIMIT 1) BARRA28 ",
					" (SELECT REPLACE(PA_ITEN.BARRACLI, '[SOMA]', 'SOMA') AS BARRACLI" +
					" FROM [PA_ITEN] PA_ITEN" +
					" INNER JOIN [PRODUTO] PRODUTO ON PRODUTO.ID = NF_CONF_ENTRA.ID_PRO AND PRODUTO.CODIGO = PA_ITEN.CODIGO" +
					" INNER JOIN [CADCOR] CADCOR ON CADCOR.ID = NF_CONF_ENTRA.ID_COR AND CADCOR.COR = PA_ITEN.COR" +
					" WHERE PA_ITEN.TAM = NF_CONF_ENTRA.TAM" +
					" LIMIT 1) BARRACLI",
					"DEPOSITO_T.CODIGO DEPOSITO_TRANSITORIO",
				],
				tabela: "NF_CONF_ENTRA",
				leftJoin: [
					{
						tabela: "PRODUTO",
						condicao: "NF_CONF_ENTRA.ID_PRO = PRODUTO.ID",
					},
					{
						tabela: "CADCOR",
						condicao: "NF_CONF_ENTRA.ID_COR = CADCOR.ID",
					},
					{
						tabela: "DEPOSITO",
						alias: "DEPOSITO_T",
						condicao: "DEPOSITO_T.ID = NF_CONF_ENTRA.ID_DEP_T",
					},
				],
				where: [`1=1 ${sWhere}`],
				orderBy: ['NF_CONF_ENTRA.DOCTO_S ASC']
			};

			const dados = await retornaJsonPesquisaPadrao(JSON.stringify(sql));

			dados.map((item) => {
				item.BARRACLI = item.BARRACLI.replaceAll('SOMA', '+');
				item.QTDE_PENDENTE = item.QTDE - item.QTDE_CONFERIDA;
				return item;
			});

			$('#tabelaItens').DataTable({
				order: [8, 'asc'],
				info: false,
				destroy: true,
				searching: false,
				lengthChange: false,
				paging: false,
				pageLength: 6,
				ordering: false,
				sort: false,
				"language": {
					"sEmptyTable": "Nenhum registro encontrado",
					"sInfo": "_TOTAL_ registros",
					"sInfoEmpty": " 0 registros",
					"sInfoFiltered": "(Filtrados de _MAX_ registros)",
					"sInfoPostFix": "",
					"sInfoThousands": ".",
					"sLengthMenu": "_MENU_ resultados",
					"sLoadingRecords": "Carregando...",
					"sProcessing": "Processando...",
					"sZeroRecords": "Nenhum registro encontrado",
					"sSearch": "Pesquisar",
					"oPaginate": {
						"sNext": "Próximo",
						"sPrevious": "Anterior",
						"sFirst": "Primeiro",
						"sLast": "Último"
					},
					"oAria": {
						"sSortAscending": ": Ordenar colunas de forma ascendente",
						"sSortDescending": ": Ordenar colunas de forma descendente"
					}
				},
				"autoWidth": true,
				"data": dados,
				"columns": columnsItens,
				"columnDefs": [
					{
						targets: [13, 14, 15, 16, 17, 18],
						visible: false
					},
					{
						targets: [8, 10],
						className: 'text-right'
					}
				],
				rowCallback: async function (row, data) {
					if ($('#selectConferencia').val()) {
						let indexColuna = encontraIndexColuna('tabelaItens', 'Qtde_Conferida');
						if (indexColuna === -1) {
							indexColuna = 9
						}
						let colunaConferida = $(`td:eq(${indexColuna})`, row);
						let colunaTipoConferencia = $(row).find('td').eq(10);

						colunaTipoConferencia.text($('#selectConferencia').val() || 'N/A');

						let table = $('#tabelaItens').DataTable();
						let rowData = table.row(row).data();
						rowData.TIPO_CONF = $('#selectConferencia').val();

						table.row(row).data(rowData);
						data.QTDE_CONFERIDA = 0

						$(this).on("click", "tr", async function (e) {
							$(this).parent().removeClass("selected");
							$('#tabelaItens tbody').parent().find("tr.selected").removeClass("selected");
							$(this).addClass("selected");
						});

						switch ($('#selectConferencia').val()) {
							case 'ConfTudo':
								$(row).css('background-color', 'green');
								colunaConferida.css('color', 'var(--font-color)').text(data.QTDE);
								data.QTDE_CONFERIDA = data.QTDE;
								data.QTDE_PENDENTE = 0;
								const table = $('#tabelaItens').DataTable();
								table.row(row).data(data);
								break;

							case 'Rejeitar':
								$(row).css({
									'background-color': 'red',
									'text-decoration': 'line-through'
								}).addClass('no-click');
								colunaConferida.css('color', 'var(--font-color)');
								break;

							case 'ConfManual':
								colunaConferida.css('display', 'flex');
								colunaConferida.empty().append(
									$('<input>', {
										type: 'number',
										min: 0,
										class: 'input-default focus form-control text-right txtQtdeItens',
										value: 0,
										change: function () {
											if (data.QTDE_CONFERIDA > data.QTDE) {
												msgAlerta('Quantidade excedida, verifique!')
											}
											data.QTDE_CONFERIDA = $(this).val();
											rowData.QTDE_CONFERIDA = $(this).val()
										},
										blur: function () {
											try {
												const $row = $(this).closest('tr');
												const indexColumn = encontraIndexColuna('tabelaItens', 'Qtde_Conferida');
												const tabela = $('#tabelaItens').DataTable();
												const index = $row.index();
												const dados = tabela.data().toArray()[index];
												let qtdeConferida = parseFloat($(this).val()) || 0;

												if (qtdeConferida < 0) {
													qtdeConferida = 0;
												}

												const $input = $('.txtQtdeItens').eq(index);

												if (qtdeConferida > dados.QTDE_PENDENTE) {
													qtdeConferida = 0;
													$input.val(0).attr('value', 0);
													dados.QTDE_CONFERIDA = 0;
													$row.css('background-color', qtdeConferida === 0 ? 'transparent' : 'green')
														.removeClass('selected');
													throw new Error('Quantidade excedida, verifique!');
												}

												$input.val(qtdeConferida).attr('value', qtdeConferida);
												dados.QTDE_CONFERIDA = qtdeConferida;

												setTimeout(() => {
													$row.find('td').eq(indexColumn).find('input')
														.val(dados.QTDE_CONFERIDA)
														.trigger('change')
														.css('color', 'var(--font-color)');

													$row.css('background-color', qtdeConferida === 0 ? 'transparent' : 'green')
														.removeClass('selected');
												}, 0);

											} catch (error) {
												console.error(error);
												msgAlerta(error.message || 'Não foi possível atualizar a quantidade conferida!');
											} finally {
												VerificaQuantidadeBipada();
												VerificaQuantidadePendente();
											}
										}
									}).css({
										width: '90%',
										'box-sizing': 'border-box'
									}),
									$('<span>', {
										type: 'button',
										class: 'fas fa-check adicionaQtdePesquisaProduto acaoIcon mt-2 ml-2 pt-1',
										click: function (e) {
											e.preventDefault();
											const $row = $(this).closest('tr');
											const indexColumn = encontraIndexColuna('tabelaItens', 'Qtde_Conferida');
											const index = $row.index();
											const tabela = $('#tabelaItens').DataTable();
											const linha = tabela.row(index).data();

											if (!linha) return;

											try {
												if (linha.QTDE_CONFERIDA > 0) {
													linha.QTDE_CONFERIDA = 0
												} else {
													linha.QTDE_CONFERIDA = linha.QTDE_PENDENTE;
												}

												setTimeout(() => {
													const $input = $row.find('td').eq(indexColumn).find('input');
													$input.val(linha.QTDE_CONFERIDA);
													$input.trigger('change');
													$row.find('td').eq(indexColumn).css('color', 'var(--font-color)');
													if (linha.QTDE_CONFERIDA == 0) {
														$row.css("background-color", 'transparent').removeClass("selected");
													} else {
														$row.css("background-color", 'green').removeClass("selected");
													}
												}, 0);

											} catch (err) {
												console.error(err);
											} finally {
												VerificaQuantidadeBipada();
												atualizaVolumesConferidos();
												atualizaVolumesPendentes();
												VerificaQuantidadePendente();
											}
										}
									}).css({
										width: '10%',
										'box-sizing': 'border-box'
									})
								);
								break;

							case 'ConfBipando':
								break;
						}
					}
				},
			});

			const colunasInvisiveis = JSON.parse(
				localStorage.getItem("colunasInvisiveisRelatorios")
			);

			$("#tabelaItens_wrapper").prepend(
				'<button class="buttonColVis" id="buttonColVisItens"><i class="fas fa-cogs"></i></button>'
			);

			$("#buttonColVisItens").on("click", async function () {
				// $.LoadingOverlay("show");
				$("#modal-ColunasVisiveis").modal("show");
				// $.LoadingOverlay("hide");
			});

			$("#buttonColVisItens").prop("title", "Configurar colunas");

			$("#tabelaItens")
				.DataTable()
				.columns()
				.every(function () {
					if (
						colunasInvisiveis.tabelaItens.indexOf(this.dataSrc()) != -1
					) {
						this.visible(false);
					}
				});

			$("#modal-ColunasVisiveis").on("show.bs.modal", function () {
				const cols = [];

				let colunasInvisiveis = JSON.parse(
					localStorage.getItem("colunasInvisiveisRelatorios")
				);

				$("#tabelaItens")
					.DataTable()
					.columns()
					.every(function () {
						cols.push({
							title: $(this.header()).text(),
							data: this.dataSrc(),
						});
					});
				adicionaColunas(cols, colunasInvisiveis.tabelaItens ?? [], ['QTDE', 'QTDE_CONFERIDA', 'QTDE_PENDENTE'], ['DT_FAB', 'OBS', 'DT_VAL', 'CUSTO', 'BARRACLI', 'TIPO_CONF']);
			});

			VerificaQuantidadeBipada()
			atualizaVolumesConferidos()
			atualizaVolumesPendentes()
			VerificaQuantidadePendente()

		} catch (error) {
			return msgAlerta(error.message || 'Não foi possível atualizar a quantidade conferida!')
		} finally {
			$.LoadingOverlay('hide')
		}
	}

	function adicionaColunas(colunas, invisiveis, desabilitadas = [], checkedPadrao = []) {
		$('#colunasInvisiveis').html('');
		colunas.forEach((coluna, i) => {
			$('#colunasInvisiveis').html(`
            ${$('#colunasInvisiveis').html()}
            <label htmlFor="txt${coluna.data}" class="col-3 labelColunasInvisiveis icheck-primary" title='Coluna ${coluna.title}'>
                <input ${desabilitadas.includes(coluna.data) ? 'disabled readonly' : ''} ${checkedPadrao.includes(coluna.data) ? 'disabled readonly checked' : ''} type="checkbox" value=${i} name="txt${coluna.data}" id="txt${coluna.data}" />
                <label for="txt${coluna.data}">${coluna.title}</label>
            </label>
        `);
			if (invisiveis) {
				if (invisiveis.filter((invisivel) => invisivel == coluna.data)[0] == coluna.data) {
					$(`#txt${coluna.data}`).attr('checked', true);
				}
			}
		});
	}

	$('#btnConferir').on('click', async function () {
		$('#txtQuantidadeBipada').val(0)
		$('#txtVolumesConferidos').val(0)

		if ($('#selectConferencia').val() !== 'ConfBipando') {
			$('#CampoConferencia').addClass('d-none')
		} else {
			$('#CampoConferencia').removeClass('d-none')
		}
		if ($('#selectConferencia').val() === 'ConfTudo') {
			await senhaSupervisor('Existem itens selecionados com a opção "Conferir Tudo", coloque a senha de supervisor para poder continuar!',
				async () => conferirItens()
			)
		} else {
			await conferirItens()
		}
	})

	if (await CopiaParametro('VENDA', 44) == 1) {
		$('#PesquisabarraProduto').show();
	} else {
		$('#PesquisabarraProduto').hide();
	}

	async function BarraEncontrada(barraBipada) {
		if (!barraBipada) return;

		const dados = $("#tabelaItens").DataTable().rows().data().toArray();

		const eBarraLog = await retornaBarraLogLida(barraBipada) === "barra_log";
		if (!eBarraLog && bApenasBarraLog) {
			msgAlerta('Barra log não encontrada, impossível continuar!');
			return;
		}

		let sBarraBipada = eBarraLog ? await extraiBarra28(barraBipada) : barraBipada;
		let qtde = eBarraLog ? 1 : (pegaValor('#txtQuantidade') > 0 ? parseFloat(pegaValor('#txtQuantidade')) : 1);

		const indiceEncontrado = dados.findIndex(item => (item.BARRA === sBarraBipada || item.BARRACLI === sBarraBipada || item.BARRA28 === sBarraBipada) && item.QTDE_CONFERIDA < item.QTDE);

		if (indiceEncontrado === -1) {
			$('#txtQuantidade').val('1');
			SomAlerta(BASE_URI, true);
			msgAlerta("Nenhuma barra localizada", null, null, () => $("#txtConferencia").focus());

			$('#btn-iniciar-epc-conferencia').prop('disabled', false);
			$('#btn-parar-epc-conferencia').prop('disabled', true);
			$("#txtConferencia").val("");
			return;
		}

		const dadosItem = $("#tabelaItens").DataTable().row(indiceEncontrado).data();

		if (dadosItem.QTDE_PENDENTE === 0) {
			msgAlerta('O produto já foi conferido, impossível continuar!');
			return;
		}

		const tipoConf = dadosItem.TIPO_CONF;
		if (tipoConf === 'Rejeitar') {
			$('#txtConferencia').val('');
			throw msgAlerta('Nota previamente rejeitada, impossível continuar!');
		}
		if (tipoConf === 'ConfManual') {
			$('#txtConferencia').val('');
			throw msgAlerta('Nota previamente configurada para conferir manualmente, impossível continuar!');
		}
		if (tipoConf === 'ConfTudo') {
			$('#txtConferencia').val('');
			throw msgAlerta('Nota previamente conferida, impossível continuar');
		}

		if (bBarraLog && await barraJaEstaBipada($('#txtConferencia').val())) {
			msgAlerta('Barra já lida, impossível continuar.');
			return;
		}

		const novaQtdeConferida = dadosItem.QTDE_CONFERIDA + qtde;

		if (novaQtdeConferida < 0) {
			$('#txtQuantidade').val('1');
			msgAlerta(`Item ${dadosItem.CODIGO} do lote: ${dadosItem.LOTE} sem quantidade para estornar, verifique!`);
			SomAlerta(BASE_URI, true);
			estornaBarraBipada($('#txtConferencia').val());
			return;
		}

		if (novaQtdeConferida > dadosItem.QTDE) {
			$('#txtQuantidade').val('1');
			SomAlerta(BASE_URI, true);
			msgAlerta(`Quantidade excedida para o item ${dadosItem.CODIGO} do lote: ${dadosItem.LOTE}!`);
			$("#txtConferencia").val("");
			$("#txtConferencia").focus();
			return;
		}

		dadosItem.QTDE_CONFERIDA = novaQtdeConferida;
		dadosItem.QTDE_PENDENTE = dadosItem.QTDE - novaQtdeConferida;

		if (bBarraLog) {
			await adicionaBarraBipada({
				codigo: dadosItem.CODIGO,
				cor: dadosItem.COR,
				tam: dadosItem.TAMANHO,
				barra: $('#txtConferencia').val()
			});
		}

		$('#txtQuantidade').val('1');
		$("#tabelaItens").DataTable().row(indiceEncontrado).data(dadosItem);
		$($("#tabelaItens tbody tr")[indiceEncontrado]).click();

		const cellIndex = encontraIndexColuna('tabelaItens', 'Qtde_Conferida');
		const rowNode = $("#tabelaItens").DataTable().row(indiceEncontrado).node();

		if (dadosItem.QTDE > dadosItem.QTDE_CONFERIDA) {
			$(rowNode).find(`td:eq(${cellIndex})`).css('color', 'red');
		} else {
			$(rowNode).find(`td:eq(${cellIndex})`).css('color', 'var(--font-color)');
			$(rowNode).css('background-color', 'green');
			$(rowNode).removeClass("selected");
		}

		$(rowNode).get(0).scrollIntoView({ behavior: 'smooth', block: 'center' });
		$("#txtConferencia").val("").focus();

		VerificaQuantidadeBipada();
	}

	function encontraIndexColuna(tableId, title) {
		const headers = $(`#${tableId} th`);

		const targetHeader = headers.filter((index, header) => {
			return $(header).css('display') !== 'none' && header.innerText === title;
		});

		return targetHeader.length > 0 ? targetHeader.index() : -1;
	}

	async function LocalizaBarraGrid() {
		const barraBipada = $("#txtConferencia").val().trim();
		await BarraEncontrada(barraBipada);
	}

	$("#txtConferencia").on("blur", async function () {
		if ($(this).val() == '000000') {
			throw msgAlerta(`Você não pode bipar um lote padrão: 000000. Para isso, use a opção de conferir (✓) ao lado da quantidade na lista de itens`)
		}
		await LocalizaBarraGrid();
		atualizaVolumesConferidos()
		atualizaVolumesPendentes()
		VerificaQuantidadePendente()
	});

	$("#txtConferencia").on("keydown", async function (event) {
		if (event.key == "Enter") {
			$("#txtConferencia").trigger("blur");
		}
	});

	function retornaTipoConf(item) {
		if (item.TIPO_CONF === 'Rejeitar') {
			return 'R'
		} else {
			return 'S'
		}
	}

	function retornaTabelaEntrada() {
		const tabela = $('#tabelaItens').DataTable().rows().data().toArray()

		const objetoConferencia = tabela.map((item, i) => {
			return {
				NUM_DOCTO: $('#txtDocumentoEntrada').val(),
				DOCTO: item.DOCUMENTO,
				CODIGO: item.CODIGO.split(' ')[0],
				COR: item.COR.split(' ')[0],
				QUANTIDADE: $('#selectConferencia').val() === 'Rejeitar' ? 0 : item.QTDE_CONFERIDA,
				QTDE_REJEITADA: $('#selectConferencia').val() === 'Rejeitar' ? item.QTDE_PENDENTE : 0,
				QUALIDADE: item.QUALIDADE,
				TAMANHO: item.TAMANHO,
				DEPOSITO: pegaChave('#txtDepositoEntrada'),
				CODBAIXA: pegaChave('#txtTipoMovEntrada'),
				IDEMPRESA: pegaChave('#txtEmpresaEntrada'),
				CONFERIDA: retornaTipoConf(item),
				DT_FAB: item.DT_FAB,
				BARRA: item.BARRA,
				BARRACLI: item.BARRACLI,
				BARRA28: item.BARRA28,
				DT_VAL: item.DT_VAL,
				CUSTO: item.CUSTO,
				DEPOSITO_TRANSITORIO: item.DEPOSITO_TRANSITORIO,
			}
		}).filter(item => item)

		const totalPorDocumento = {};
		const conferidaPorDocumento = {};

		tabela.forEach(item => {
			const numero = item.NUMERO;
			const quantidade = item.QTDE;

			if (totalPorDocumento[numero]) {
				totalPorDocumento[numero] += parseFloat(quantidade);
			} else {
				totalPorDocumento[numero] = parseFloat(quantidade);
			}
		});

		tabela.forEach(item => {
			const numero = item.NUMERO;
			const quantidade = item.QTDE_CONFERIDA;

			if (conferidaPorDocumento[numero]) {
				conferidaPorDocumento[numero] += parseFloat(quantidade);
			} else {
				conferidaPorDocumento[numero] = parseFloat(quantidade);
			}
		});

		objetoConferencia.forEach(conf => {
			const numero = conf.DOCTO;
			const quantidadeTotal = parseFloat(totalPorDocumento[numero]) || 0;
			const conferidaTotal = parseFloat(conferidaPorDocumento[numero]) || 0;

			if (quantidadeTotal > conferidaTotal && conferidaTotal != 0 && conf.CONFERIDA !== 'R') {
				conf.CONFERIDA = "F";
			} else if (conferidaTotal === 0 && $('#selectConferencia').val() === 'Rejeitar') {
				conf.CONFERIDA = 'R'
			} else if (conferidaTotal === 0) {
				conf.CONFERIDA = 'P'
			}
		});

		return objetoConferencia;
	}

	async function gravarConferencia() {
		try {
			if ($('#selectConferencia').val() !== 'Rejeitar') {
				if (!$('#txtDepositoEntrada').val()) {
					return msgAlerta('Necessário informar um depósito de entrada, verifique!')
				}
			}
			if (!$('#txtTipoMovEntrada').val()) {
				return msgAlerta('Necessário informar um tipo de movimento, verifique!')
			}
			if ($('#tabelaItens').DataTable().data().length === 0) {
				return msgAlerta('Nenhum item para conferir. Verifique!')
			}

			const objeto = retornaTabelaEntrada();

			const bExisteConferido = objeto.reduce((acc, item) => acc + item.QUANTIDADE, 0);
			if (bExisteConferido === 0 && $('#selectConferencia').val() !== 'Rejeitar') {
				return msgAlerta('Nenhum item conferido. Verifique!');
			}
			const body = {
				produtos: objeto
			}
			$('#btnGravarConferencia').attr('disabled', true)
			const response = await requisicao('POST',
				`/sisplan/estoque/v1/transferenciamercadorias_produto?`,
				`TIPO=ENTRADA&COD_USUARIO=${getCookie('cod_usuario')}&TIPO_CONF=${$('#selectConferencia').val()}`,
				JSON.stringify(body), 30000000
			);

			if (!response) {
				return;
			}

			if (response.status != 200) {
				const jsonStr = await response.json();
				msgErro(jsonStr.mensagem);
				return;
			}

			toastr.success(
				'Entrada de mercadoria efetuada com sucesso!',
				'Confirmação', {
				toastClass: 'alert',
				iconClasses: {
					error: 'alert-error',
					info: 'alert-info',
					success: 'alert-success',
					warning: 'alert-warning'
				},
				positionClass: "toast-top-center",
				progressBar: true,
				timeOut: 3000,
				fadeOut: 1000,
				onHidden() {
					if ($.fn.DataTable.isDataTable('#tabelaItens')) {
						$('#tabelaItens').DataTable().destroy();
						$('#tabelaItens').empty();
					};
					$('#btnBuscarNotas').trigger('click')
					$('#txtDepositoEntrada').val('')
				}
			}
			).css({
				"margin-top": "20%",
				"width": "500px",
				"max-width": "500px"
			});

		} catch (error) {
			console.error(error);
			window.location.href = `${BASE_URI}/mercadorias`;
		}
	}

	$('#btnGravarConferencia').on('click', async function () {
		try {
			$.LoadingOverlay('show');
			try {
				await gravarConferencia();

			} catch (error) {
				console.error(error);
			}

		} finally {
			$.LoadingOverlay('hide');
		}
	});

	async function buscaFuncionario() {
		const codUsuario = getCookie('cod_usuario');
		try {
			const pesquisaParam = {
				tabela: 'ACESSO_USUARIOS',
				camposSelect: ['ACESSO_USUARIOS.CODFUN', 'PESSOAL.NOME'],
				leftJoin: [{
					tabela: 'PESSOAL',
					condicao: 'PESSOAL.CODIGO = ACESSO_USUARIOS.CODFUN'
				}],
				where: [`ACESSO_USUARIOS.CODIGO = '${codUsuario}'`]
			}
			const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

			return jsonStr.length > 0 ? jsonStr[0].CODFUN : codUsuario;

		} catch (error) {
			console.error(error);
		}
	};

	async function faturarMercadorias(numero, natureza, cliente, operacao, tab_preco, custo) {
		const bNFEAut = parametrosVenda[20] == 3;
		try {
			const codUsuario = await buscaFuncionario();
			const empFat = pegaChave(parametrosVenda[111]);
			let params = `NUMERO=${numero}` +
				`&NATUREZA=${natureza}` +
				`&CLIENTE=${pegaChave(cliente)}` +
				`&OPERACAO=${pegaChave(operacao)}` +
				`&TAB_PRECO=${pegaChave(tab_preco)}` +
				`&CUSTO=${custo}` +
				`&TIPOITEM=P` +
				`&COD_USUARIO=${codUsuario}`;


			if (bNFEAut && empFat != '') {
				params += `&EMPRESA=${empFat}`;
			}

			const response = await requisicao('POST', '/Sisplan/estoque/V1/faturar_mercadorias?', params, null, 300000);

			if (!response) {
				return;
			}

			const jsonStr = await response.json();
			if (response.status != 200) {
				msgErro(jsonStr.mensagem);
				return false;
			}
			return jsonStr;
		} catch (error) {
			msgErro('Erro ao faturar venda.');
			console.error(error);
			return false;
		}
	}

	async function faturaNFe() {
		try {
			$.LoadingOverlay("show");

			let nota = {};
			nota.NATUREZA = pegaChave('#txtNatureza');
			nota.CLIENTE = $('#txtCliente').val();
			nota.NUMERO = numeroDocNota ? numeroDocNota : $('#txtDocumento').val();
			nota.TRANSFERENCIA = 'S';
			nota.TIPOITEM = 'P';
			nota.OPERACAO = $('#txtOperacao').val();
			nota.TABELA = $('#txtTabelaPreco').val() ? $('#txtTabelaPreco').val() : tabelaPadrao; //aqui tem que tratar para não poder passar tabela de preço vazia, tem que dar uma mensagem dizendo pra informar
			nota.PRECO_CUSTO = $('#precoCusto').is(':checked') ? 'S' : 'N'

			const jsonNota = JSON.stringify(nota);

			if (bNFEAutomatico == 1) {
				const result = await faturarMercadorias(nota.NUMERO, nota.NATUREZA, nota.CLIENTE, nota.OPERACAO, nota.TABELA, nota.PRECO_CUSTO);
				if (result.regraAplicada) {
					const transmiteNota = await rotinaTransmiteNota(result.fatura, result.serie);

					if (transmiteNota[0]) {
						await imprimirNfe(result.fatura, result.serie);
						window.location.href = `${BASE_URI}/mercadorias_produto`
					} else {
						if (parametrosVenda[111] == '') {
							msgAlerta(`${transmiteNota[1]}\nRedirecionando a tela de impressão de nota.`, null, null, () => {
								window.location.href = `${BASE_URI}/mercadorias_produto`
								parent.abrirEmNovaAbaIFrame('Impressão NFe', `${BASE_URI}/nfeimpressao/`);
							});
						} else {
							msgAlerta(transmiteNota[1], null, null, () => {
								window.location.href = `${BASE_URI}/mercadorias_produto`
							});
						}
					}
				} else {
					parent.abrirEmNovaAbaIFrame('Faturamento Geral', `${BASE_URI}/faturamento/`, btoa(jsonNota))
					window.location.href = `${BASE_URI}/mercadorias_produto`
				}
			} else {
				parent.abrirEmNovaAbaIFrame('Faturamento Geral', `${BASE_URI}/faturamento/`, btoa(jsonNota))
				window.location.href = `${BASE_URI}/mercadorias_produto`
			}

			// let jsonNota = JSON.stringify(nota);

			// parent.abrirEmNovaAbaIFrame('Faturamento Geral', `${BASE_URI}/faturamento/`, btoa(jsonNota))


		} catch (error) {
			console.log(error);;
		} finally {
			$.LoadingOverlay("hide");
			// window.location.href = `${BASE_URI}/mercadorias_produto`
		}
	}

	$('#btnGerarNFe').on('click', async function () {
		if ($('#tabelaEnvio').DataTable().data().length === 0) {
			throw msgAlerta('Nenhum movimento para gerar nota, verifique!')
		}
		const { codcli, nome } = await buscaEmpresaDestino(pegaChave('#txtEmpresaSaida'));
		if (!codcli) {
			$('.cliente').attr('disabled', false)
		} else {
			insereValor('#txtCliente', codcli, nome);
			$('#txtCliente').attr('disabled', true)
			$('#btnCliente').attr('disabled', true)
			$('#btnLimpaCliente').attr('disabled', true)
		}

		const operacao = await retornaValorCadPadrao('TRANSF_MERCADORIAS', 'OPERACAO') ?? ''
		insereValor('#txtOperacao', operacao, { tabela: 'OPER_FISCAL', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: operacao });
		if (operacao) {
			$('#txtNatureza').attr('disabled', true)
			$('#btnNatureza').attr('disabled', true)
			$('#btnLimpaNatureza').attr('disabled', true)
		} else {
			$('#txtNatureza').attr('disabled', false)
			$('#btnNatureza').attr('disabled', false)
			$('#btnLimpaNatureza').attr('disabled', false)
		}

		$('#btnConfirmarFatura').attr('disabled', false)
		$('#modalFaturarTransferencia').modal('show')
	})

	$('#modalFaturarTransferencia').on('hidden.bs.modal', function () {
		$('#txtCliente').val()
		$('#txtCliente').attr('disabled', false)
		$('#btnCliente').attr('disabled', false)
		$('#btnLimpaCliente').attr('disabled', false)
		$('#btnConfirmarFatura').attr('disabled', false)
	})

	$('#btnConfirmarFatura').on('click', async function () {
		try {
			$.LoadingOverlay('show')
			if ($('#txtCliente').val() === '') {
				return msgAlerta('Nenhum cliente informado, verifique!');
			}
			if (!$('#txtTabelaPreco').val() && !tabelaPadrao) {
				return msgAlerta('Nenhuma tabela de preços foi informada. Verifique o campo ou o parâmetro de tabela de preço padrão para venda!');
			}
			$('#btnConfirmarFatura').attr('disabled', true)
			if (numeroDocNota) {
				await faturaNFe()
			} else {
				await gravarMovimentacao(true)
			}
			numeroDocNota = ''
			$('#modalFaturarTransferencia').modal('hide')
		} finally {
			$.LoadingOverlay('hide')
		}
	})

	$('#btnBuscarNotas').on('click', async function () {
		if (!!$('#btnGravarConferencia').attr('disabled')) {
			$('#btnGravarConferencia').attr('disabled', false)
		}
		if ($.fn.DataTable.isDataTable('#tabelaItens')) {
			$('#tabelaItens').DataTable().destroy();
			$('#tabelaItens').empty();
		};
		const statusEnvio = $('#txtStatusEnvio').val()
		const statusConf = $('#txtStatusConf').val()
		await buscaNotas(statusConf, statusEnvio)
	})

	$('#txtDocumento').trigger('blur')
	$('#btnBuscarNotas').trigger('click')

	async function carregaValoresPadroes() {
		const jsonStr = await buscaValoresPadroes('ESTOQUE')

		jsonStr.map(item => {
			switch (item.CAMPO) {
				case 'MERCAD_TIPO_ENTRADA': {
					if (item.VALOR != '') {
						insereValor('#txtTipoMovEntrada', item.VALOR, { tabela: 'TABBAI', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
					}
					break;
				}
				case 'MERCAD_TIPO_SAIDA': {
					if (item.VALOR != '') {
						insereValor('#txtTipoMovSaida', item.VALOR, { tabela: 'TABBAI', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
					}
					break;
				}
				case 'MERCAD_DEPOSITO_SAIDA': {
					if (item.VALOR != '') {
						insereValor('#txtDepositoSaida', item.VALOR, { tabela: 'DEPOSITO', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
					}
					break;
				}
				case 'MERCAD_DEPOSITO_ENTRADA': {
					if (item.VALOR != '') {
						insereValor('#txtDepositoEntrada', item.VALOR, { tabela: 'DEPOSITO', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
					}
					break;
				}
			}
		});
	};


	// EPC ENVIO
	const epcEnvio = new EPC({
		barra: '#txtBarra',
		quantidade: '#txtQuantidadeEnvio',
		deposito: '#txtDepositoSaida',
		codigoEPC: '#txtCodigoEPCEnvio',
		idItem: '#txtIdItemEnvio',
		integracaoEPC: integracaoEPC,
		listaBarrasBipadasEPC: listaBarrasBipadasEPC ?? [],
		callBackSaidaBarra: async () => {
			console.log('[EPC] Tentando executar adicionaRegistroGrid...');
			if (bloqueiaSaida) {
				console.warn('[EPC] Aguardando liberação do lock anterior...');
				// espera até que bloqueiaSaida seja falso
				while (bloqueiaSaida) {
					await sleep(100);
				}
			}

			bloqueiaSaida = true;
			try {
				console.log('[EPC] Iniciando adicionaRegistroGrid');
				await adicionaRegistroGrid();
				console.log('[EPC] Finalizou adicionaRegistroGrid');
			} catch (error) {
				console.error('[EPC] Erro na adicionaRegistroGrid:', error);
			} finally {
				bloqueiaSaida = false;
			}
		}
	});
	// EPC CONFERENCIA
	const epcConferencia = new EPC({
		barra: '#txtConferencia',
		quantidade: '#txtQuantidadeConferencia',
		deposito: '#txtDepositoEntrada',
		codigoEPC: '#txtCodigoEPCConferencia',
		idItem: '#txtIdItemConferencia',
		integracaoEPC: integracaoEPC,
		listaBarrasBipadasEPC: listaBarrasBipadasEPC ?? [],
		callBackSaidaBarra: undefined
	});

	$('#btn-iniciar-epc-envio').on('click', () => {
		if (epcEnvio.iniciar()) {
			$('#btn-iniciar-epc-envio').prop('disabled', true);
			$('#btn-parar-epc-envio').prop('disabled', false);
			return
		}
		$('#btn-iniciar-epc-envio').prop('disabled', false);
		$('#btn-parar-epc-envio').prop('disabled', true);

	});

	$('#btn-parar-epc-envio').on('click', () => {
		if (epcEnvio.parar()) {
			$('#btn-iniciar-epc-envio').prop('disabled', false);
			$('#btn-parar-epc-envio').prop('disabled', true);
			return
		}
		$('#btn-iniciar-epc-envio').prop('disabled', true);
		$('#btn-parar-epc-envio').prop('disabled', false);
	});

	$('#btn-iniciar-epc-conferencia').on('click', () => {
		if (epcConferencia.iniciar()) {
			$('#btn-iniciar-epc-conferencia').prop('disabled', true);
			$('#btn-parar-epc-conferencia').prop('disabled', false);
			return
		}
		$('#btn-iniciar-epc-conferencia').prop('disabled', false);
		$('#btn-parar-epc-conferencia').prop('disabled', true);
	});

	$('#btn-parar-epc-conferencia').on('click', () => {
		if (epcConferencia.parar()) {
			$('#btn-iniciar-epc-conferencia').prop('disabled', false);
			$('#btn-parar-epc-conferencia').prop('disabled', true);
			return
		}
		$('#btn-iniciar-epc-conferencia').prop('disabled', true);
		$('#btn-parar-epc-conferencia').prop('disabled', false);
	});

})