$(document).ready(async function () {
    $('#tutorial').on('click', function () {
        $(document).ready(async function () {
            const driver = new Driver({
                doneBtnText: 'Sair',
                closeBtnText: 'Fechar',
                nextBtnText: 'Próximo',
                prevBtnText: 'Anterior',
                allowClose: false
            });
            driver.defineSteps([{
                element: '#btnFiltros',
                popover: {
                    title: 'Botão Filtros',
                    description: 'Clique aqui para abrir os filtros e realizar alguma consulta.',
                    position: 'right'
                }
            },
            {
                element: '#btnImprimir',
                popover: {
                    title: 'Botão Imprimir',
                    description: 'Clique aqui para Imprimir um relatório.',
                    position: 'right'
                }
            }
            ]);
            driver.start();
        });
    });

    const permissaoEntidadeUsuarioLogado = await permissaoAcessos("ENTIDADE");

    let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

    // aqui so valida se nao existe tem que criar para nao dar erro
    if (colunas == null || colunas.relClienteSemAtualizacao == undefined) {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relClienteSemAtualizacao: [] }));
        colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
    }

    // confirma as colunas
    $('#btnConfirmarColunas').on('click', async function () {
        try {
            $.LoadingOverlay('show');

            const novasColunas = retornaNovasColunasInvisiveis();
            localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relClienteSemAtualizacao: novasColunas }))

            $('#tabelaClientes').DataTable().columns().visible(true);

            $('#tabelaClientes').DataTable().columns().every(
                function () {
                    if ((novasColunas).indexOf(this.dataSrc()) != -1) {
                        this.visible(false);
                    }
                })

        } finally {
            $.LoadingOverlay('hide');
            $('#modal-ColunasVisiveis').modal('hide');
        }
    })

    $('#btnSelecionarEmpresas').on('click', function () {
        carregaEmpresasDisponiveis();
    });

    componenteFiltro('cliente', true);
    componenteFiltro('representante', true, false);
    componenteFiltro('moeda', true, false);
    componenteFiltro('status', true);
    componenteFiltro('cliente', true, true, 'Responsavel');
    componenteFiltro('pedido', true, true);

    $('#btnFiltros').on('click', async function () {
        $('#modal-filtros').modal('show');
    });

    $('#btnLimpaPedido').on('click', function () {
        if ($('#txtPedido').val() == '') {
            $('#listaPedido').val('');
        }
        $('#txtPedido').val('');
        $('#txtPedido').focus();
    });

    $('#btnLimparFiltros').on('click', function () {
        $('#txtDtEmissaoDe').val('1200-01-01');
        $('#txtDtEmissaoAte').val('2500-12-31');
        $('#txtDtFaturadoDe').val('1200-01-01');
        $('#txtDtFaturadoAte').val('2500-12-31');
        $('#txtDias').val('90');
        $('#txtPedido').val('');
        $('#txtCliente').empty().trigger('change');
        $('#txtRepresentante').empty().trigger('change');
        $('#txtMoeda').empty().trigger('change');
        $("#txtStatus").empty().trigger('change');
    });

    retornaHintRelatorio('btnImprimir', 'RelClienteSemAtualizacao')

    await preencheOrdenacaoTela('RelClienteSemAtualizacao');

    $('#btnImprimir').on('click', async function () {
        try {
            $.LoadingOverlay('show');
            try {
                let url = `/sisplan/impressao/v1/imprimirclientesematualizacao?`;

                const filtros = await retornaFiltros();
                const bImprimeAutomatico = await verificaImprimirAutomatico('RelClienteSemAtualizacao');
                const ordem = `&TELA_ORDENACAO=RelClienteSemAtualizacao&ORDEM_ORDENACAO=${$('#txtOrdem').val()}`;
                let arquivo = await GeraRelatorio(`${url}${filtros}${ordem}&`, 'GET', 1000000, false, 'RelClienteSemAtualizacao');
                if (arquivo != undefined) {
                    if (!bImprimeAutomatico) {
                        window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
                    }
                    await limparRelatorios();
                }

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    });

    function retornaBotaoOpcoes(data) {
        var retorno = '<div> ' +
            '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
            '      ' + data + ' ' +
            '    </button> ' +
            '    <div class="dropdown-menu"> ' +
            '    <button class="dropdown-item" title="Consulta Receita Federal" id="btn-consulta-receita">Consulta Receita Federal</button>     ' +
            '</div>';
        return retorno;
    };

    async function buscaDados() {
        $.LoadingOverlay("show");
        try {

            let params = await retornaFiltros();
            const response = await requisicao('GET', '/sisplan/impressao/v1/consultarelclientesematualizacao?', params, '', 15000);

            if (!response) {
                return;
            }

            const jsonStr = await response.json();

            if (response.status != 200) {
                throw new Error(jsonStr.RESULT[0].mensagem);
            }

            const dataSetCols = [
                {
                    data: "CODCLI",
                    title: "Codcli",
                    render(data) {
                        return retornaBotaoOpcoes(data)
                    }
                },
                {
                    data: "CLIENTE",
                    title: "Nome"
                },
                {
                    data: "CNPJ",
                    title: "CNPJ"
                },
                {
                    data: "DATA_BUSCA",
                    title: "Última Atualização Cli",
                    type: "date-br",
                    render(data) {
                        if (data) {
                            return new Intl.DateTimeFormat("pt-BR").format(
                                new Date(`${data.split(" ")[0]} 23:59:59`)
                            );
                        } else {
                            return ''
                        }
                    }
                },
                {
                    data: "QTDE",
                    title: "Qtde Pedidos",
                    className: 'pr-4 text-right'
                },
            ]

            $('#tabelaClientes').DataTable({
                paging: true,
                lengthChange: true,
                filter: false,
                info: true,
                order: false,
                autoWidth: true,
                destroy: true,
                colReorder: true,
                columns: dataSetCols,
                data: jsonStr
            });

            const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

            $('#tabelaClientes_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
            $('#tabelaClientes_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

            $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
            $('#buttonExcel').prop('title', 'Exportar')

            $('#buttonColVis').on('click', async function () {
                $.LoadingOverlay('show');
                $('#modal-ColunasVisiveis').modal('show');
                $.LoadingOverlay('hide');
            });

            $('#buttonExcel').on('click', async function () {
                const dados = $("#tabelaClientes").DataTable().data().toArray();
                await exportaCSV("", "", undefined, null, 'Relatório de clientes sem atualização', '', '', 999, false, false, dados);
            });

            $('#tabelaClientes').DataTable().columns().every(
                function () {
                    if ((colunasInvisiveis.relClienteSemAtualizacao).indexOf(this.dataSrc()) != -1) {
                        this.visible(false);
                    }
                })

        } catch (error) {
            console.error(error);
            msgErro('Não foi possível buscar os dados.');
        } finally {
            $.LoadingOverlay("hide");
        }
    };

    $('#tabelaClientes').on('click', '#btn-consulta-receita', async function () {
        $.LoadingOverlay("show");
        try {
            const data = $("#tabelaClientes").DataTable().row($(this).parents("tr")).data();

            if (permissaoEntidadeUsuarioLogado.ALTERA == 'S') {
                $("#txtCodCliConsulta").val(data.CODCLI);
                $("#txtCNPJConsulta").val(data.CNPJ);
                $("#modalConsultaReceita").modal("show");
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    })

    $('#modalConsultaReceita').on('hidden.bs.modal', async function () {
        await buscaDados();
    })

    $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
        const cols = [];

        let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

        $('#tabelaClientes').DataTable().columns().every(function () {
            cols.push({
                'title': $(this.header()).text(),
                'data': this.dataSrc()
            })
        });

        adicionaColunas(cols, colunasInvisiveis.relClienteSemAtualizacao ?? [])
    })

    async function retornaFiltros() {
        const sTipo = $($("[name='tipo']").toArray().filter(radio => radio.checked == true)).parent().text().substring();
        const sDias = pegaValor('#txtDias');
        const sEmissaoDe = $('#txtDtEmissaoDe').val();
        const sEmissaoAte = $('#txtDtEmissaoAte').val();
        const sFaturadoDe = $('#txtDtFaturadoDe').val();
        const sFaturadoAte = $('#txtDtFaturadoAte').val();
        const sCliente = await formataListas($('#txtCliente').val().toString());
        const sPedido = await formataListas($('#txtPedido').val().toString());
        const sRepresentante = await formataListas($('#txtRepresentante').val().toString());
        const sMoeda = await formataListas($('#txtMoeda').val().toString());
        const sEmp = $('.empresa_selecionada:checked').toArray().length > 0
            ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length))
            : [getCookie('emp_id')];
        const status = await formataListas($("#txtStatus").val().toString());

        const params = `EMISSAO_DE=${sEmissaoDe}` +
            `&EMISSAO_ATE=${sEmissaoAte}` +
            `&FATURADO_DE=${sFaturadoDe}` +
            `&FATURADO_ATE=${sFaturadoAte}` +
            `&DIAS=${sDias}` +
            `&CLIENTE=${sCliente}` +
            `&PEDIDO=${sPedido}` +
            `&TIPO=${sTipo}` +
            `&REPRESENTANTE=${sRepresentante}` +
            `&MOEDA=${sMoeda}` +
            `&EMPRESAS_FILTRO=${sEmp}` +
            `&STATUS=${status}`;

        return params;
    }

    $('#btnConsultar').on('click', async function () {
        await buscaDados();

        $('#modal-filtros').modal('hide');
    });
});