$(document).ready(async function () {

  let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

  // aqui so valida se nao existe tem que criar para nao dar erro
  if (colunas == null || colunas.relEstoqueTingimento == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relEstoqueTingimento: [] }))
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
  }

  // confirma as colunas
  $('#btnConfirmarColunas').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const novasColunas = retornaNovasColunasInvisiveis();
      localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relEstoqueTingimento: novasColunas }))

      $('#tabelaRelEstoqueTingimento').DataTable().columns().visible(true);
      $('#tabelaRelEstoqueTingimento').DataTable().columns().every(
        function () {
          if ((novasColunas).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        })

    } finally {
      $.LoadingOverlay('hide');
      $('#modal-ColunasVisiveis').modal('hide');
    }
  })

  addTutorial();
  preencheOrdenacaoTela('RelEstoqueTingimento');

  retornaHintRelatorio('btnImprimir', 'RelEstoqueTingimento')

  $('#btnImprimir').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        const url = `/sisplan/impressao/v1/imprimirrelestoquetingimento?`;
        const filtros = await retornaFiltros();
        const ordem = `&TELA_ORDENACAO=RelEstoqueTingimento&ORDEM_ORDENACAO=${$('#txtOrdem').val()}`;
        const bImprimeAutomatico = await verificaImprimirAutomatico('RelEstoqueTingimento');
        const arquivo = await GeraRelatorio(`${url}${filtros}${ordem}&`, 'GET', 100000, false, 'RelEstoqueTingimento');
        if (arquivo != undefined) {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
          }
          await limparRelatorios();
        }

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#btnConsultar').on('click', async function () {
    $.LoadingOverlay('show');
    if ($("#txtOrdem option").toArray().length > 0) {
      retornaHintRelatorio('btnImprimir', $("#txtOrdem option").toArray().map(map => { return [map.selected, $(map).attr('nome_prt')] }).filter(filter => filter[0] == true)[0][1], true)
    }
    try {
      let dataSetCols = [];
      const url = '/sisplan/impressao/v1/consultarelestoquetingimento?';
      const filtros = await retornaFiltros();

      const response = await requisicao('GET', url, filtros, 130000);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();

      if (jsonStr.length == 0) {
        return;
      }

      if (response.status != 200) {
        console.error(jsonStr.mensagem);
        return;
      }

      let keys = Object.keys(jsonStr[0]);

      keys.forEach(k => {
        dataSetCols.push({
          'title': k,
          'data': k
        });
      });

      criaDataTablePadrao('#tabelaRelEstoqueTingimento', true, true, true, true, true, false, false, jsonStr, dataSetCols, [], [0], [], [5, 6, 7], '', 2, 'buttonColVis', 'buttonExcel', true, [], []);

      const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

      $('#buttonColVis').on('click', async function () {
        $.LoadingOverlay('show');
        $('#modal-ColunasVisiveis').modal('show');
        $.LoadingOverlay('hide');
      });

      $('#buttonExcel').on('click', async function () {
        const url = '/sisplan/impressao/v1/consultarelestoquetingimento?';
        const filtros = await retornaFiltros();

        await exportaCSV(url, filtros, false, null, 'Relatório de Estoque Tingimento', '#tabelaRelEstoqueTingimento');
      });


      $('#tabelaRelEstoqueTingimento').DataTable().columns().every(
        function () {
          if ((colunasInvisiveis.relEstoqueTingimento).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        }
      )

      $("#txt_notas").html(
        parseFloat(
          $("#tabelaRelEstoqueTingimento").DataTable().column(5).data().sum().toFixed(2)
        ).toLocaleString("pt-BR", {
          minimumFractionDigits: 2,
        })
      );

      $("#txt_fals").html(
        parseFloat(
          $("#tabelaRelEstoqueTingimento").DataTable().column(6).data().sum().toFixed(2)
        ).toLocaleString("pt-BR", {
          minimumFractionDigits: 2,
        })
      );

      $("#txt_saldo").html(
        parseFloat(
          $("#tabelaRelEstoqueTingimento").DataTable().column(7).data().sum().toFixed(2)
        ).toLocaleString("pt-BR", {
          minimumFractionDigits: 2,
        })
      );

    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay('hide');
      $('#modal-filtros').modal('hide');
    }
  });

  $('#btnConsultar').click();

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];

    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    $('#tabelaRelEstoqueTingimento').DataTable().columns().every(function () {
      cols.push({
        'title': $(this.header()).text(),
        'data': this.dataSrc()
      })
    });

    adicionaColunas(cols, colunasInvisiveis.relEstoqueTingimento ?? [])
  })

  async function retornaFiltros() {
    const retorno = `CODCLI=${getCookie('cod_usuario')}`;
    return retorno;
  }

  function addTutorial() {
    $('#tutorial').on('click', function () {
      $(document).ready(async function () {
        const driver = new Driver({
          doneBtnText: 'Sair',
          closeBtnText: 'Fechar',
          nextBtnText: 'Próximo',
          prevBtnText: 'Anterior',
          allowClose: false
        });
        driver.defineSteps([{
          element: '#btnFiltros',
          popover: {
            title: 'Botão Filtros',
            description: 'Clique aqui para abrir os filtros e realizar uma consulta.',
            position: 'right'
          }
        },
        {
          element: '#btnImprimir',
          popover: {
            title: 'Botão Imprimir',
            description: 'Clique aqui para imprimir um relatório.',
            position: 'right'
          }
        },
        ]);
        driver.start();
      });
    });
  }

});